<?php

defined('BASEPATH') or exit('No direct script access allowed');

/**
 * Return lead campaign status color class
 * 
 * @param string $color
 * @return string
 */
function leadcampaigns_status_color_class($color)
{
    return 'label-color-' . $color;
}

/**
 * Format lead campaign source
 * 
 * @param string $source
 * @return string
 */
function format_campaign_source($source)
{
    return ucfirst($source);
}

/**
 * Get lead campaign full name (if applicable)
 * 
 * @param object $campaign
 * @return string
 */
function get_leadcampaign_name($campaign)
{
    if (!isset($campaign->title)) {
        return '';
    }

    return $campaign->title . (isset($campaign->tagline) ? ' - ' . $campaign->tagline : '');
}
