
<?php
defined('BASEPATH') or exit('No direct script access allowed');

function deals_stage_color_class($hex)
{
    return 'label-color-' . preg_replace('/[^a-z0-9]/i', '', $hex);
}

function format_deal_amount($amount, $currency_id = null)
{
    $currency = $currency_id ? $currency_id : get_base_currency()->id;
    return app_format_money((float)$amount, $currency);
}

function deals_weighted_value($amount, $probability)
{
    $p = (int)$probability;
    if ($p < 0) $p = 0;
    if ($p > 100) $p = 100;
    return ((float)$amount) * ($p / 100);
}

function deals_card_title($deal)
{
    return isset($deal['name']) ? e($deal['name']) : '';
}