<?php defined('BASEPATH') or exit('No direct script access allowed'); ?>
<?php
if (!isset($ratings)) {
    $CI = &get_instance();
    $ratings = $CI->db->order_by('score', 'desc')->get(db_prefix() . 'deals_ratings')->result_array();
}
$csrf_name = $CI->security->get_csrf_token_name();
$csrf_hash = $CI->security->get_csrf_hash();
?>
<!-- <?php //init_head(); ?> -->
<div class="panel_s">
    <div class="panel-body">
        <div class="">
            <div class="row">
                <div class="col-md-12">
                    <div class="tw-mb-2">
                        <a href="#" onclick="new_rating(); return false;" class="btn btn-primary">
                            <i class="fa-regular fa-plus tw-mr-1"></i>
                            <?= _l('new_rating'); ?>
                        </a>
                    </div>
                    <div class="panel_s">
                        <div class="panel-body panel-table-full">
                            <?php if (count($ratings) > 0) { ?>
                                <table class="table dt-table" data-order-col="2" data-order-type="desc">
                                    <thead>
                                        <th><?= _l('id'); ?></th>
                                        <th><?= _l('name'); ?></th>
                                        <th><?= _l('score'); ?></th>
                                        <th><?= _l('options'); ?></th>
                                    </thead>
                                    <tbody>
                                        <?php foreach ($ratings as $rating) { ?>
                                            <tr>
                                                <td><?= e($rating['id']); ?></td>
                                                <td>
                                                    <a href="#" class="tw-font-medium"
                                                        onclick="edit_rating(this,<?= e($rating['id']); ?>); return false;"
                                                        data-name="<?= html_escape($rating['name']); ?>"
                                                        data-score="<?= html_escape($rating['score']); ?>">
                                                        <?= html_entity_decode($rating['name']); ?>
                                                    </a>
                                                </td>
                                                <td><?= e($rating['score']); ?></td>
                                                <td>
                                                    <div class="tw-flex tw-items-center tw-space-x-2">
                                                        <a href="#"
                                                            onclick="edit_rating(this,<?= e($rating['id']); ?>); return false;"
                                                            data-name="<?= html_escape($rating['name']); ?>"
                                                            data-score="<?= html_escape($rating['score']); ?>"
                                                            class="tw-text-neutral-500 hover:tw-text-neutral-700 focus:tw-text-neutral-700">
                                                            <i class="fa-regular fa-pen-to-square fa-lg"></i>
                                                        </a>
                                                        <a href="#"
                                                            onclick="delete_rating(<?= e($rating['id']); ?>); return false;"
                                                            class="tw-text-neutral-500 hover:tw-text-neutral-700 focus:tw-text-neutral-700 _delete">
                                                            <i class="fa-regular fa-trash-can fa-lg"></i>
                                                        </a>
                                                    </div>
                                                </td>
                                            </tr>
                                        <?php } ?>
                                    </tbody>
                                </table>
                            <?php } else { ?>
                                <p class="no-margin">
                                    <?= _l('ratings_not_found'); ?>
                                </p>
                            <?php } ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<div class="modal fade" id="rating_modal" tabindex="-1" role="dialog">
    <div class="modal-dialog">
        <?= form_open(admin_url('deals/ratings'), ['id' => 'rating-form']); ?>
        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span
                        aria-hidden="true">&times;</span></button>
                <h4 class="modal-title">
                    <span class="edit-title"><?= _l('edit_rating'); ?></span>
                    <span class="add-title"><?= _l('new_rating'); ?></span>
                </h4>
            </div>
            <div class="modal-body">
                <div class="row">
                    <div class="col-md-12">
                        <div id="additional"></div>
                        <?= render_input('name', 'rating_name'); ?>
                        <?= render_input('score', 'rating_score', '', 'number'); ?>
                    </div>
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-default" data-dismiss="modal"><?= _l('close'); ?></button>
                <button type="submit" class="btn btn-primary"><?= _l('submit'); ?></button>
            </div>
        </div>
        <?= form_close(); ?>
    </div>
</div>

<script>
    var CSRF = { name: '<?php echo $csrf_name; ?>', value: '<?php echo $csrf_hash; ?>' };

    $(function () {
        appValidateForm($('#rating-form'), {
            name: 'required',
            score: 'required'
        }, manage_ratings);

        $('#rating_modal').on('hidden.bs.modal', function () {
            $('#additional').html('');
            $('#rating_modal input[name="name"]').val('');
            $('#rating_modal input[name="score"]').val('');
            $('.add-title').removeClass('hide');
            $('.edit-title').removeClass('hide');
        });
    });

    function new_rating() {
        $('#rating_modal').modal('show');
        $('.edit-title').addClass('hide');
    }

    function edit_rating(invoker, id) {
        $('#additional').html('<input type="hidden" name="id" value="' + id + '">');
        $('#rating_modal input[name="name"]').val($(invoker).data('name'));
        $('#rating_modal input[name="score"]').val($(invoker).data('score'));
        $('#rating_modal').modal('show');
        $('.add-title').addClass('hide');
    }

    function delete_rating(id) {
        if (!confirm('<?php _l('confirm_action_prompt'); ?>')) return;
        var f = new FormData();
        f.append('action', 'delete');
        f.append('id', id);
        f.append(CSRF.name, CSRF.value);
        fetch('<?php echo admin_url('deals/ratings'); ?>', {
            method: 'POST',
            body: f,
            credentials: 'same-origin'
        }).then(() => location.reload());
    }

    function manage_ratings(form) {
        var data = $(form).serializeArray();
        var f = new FormData();
        var isEdit = false;
        data.forEach(function (item) {
            f.append(item.name, item.value);
            if (item.name === 'id' && item.value) isEdit = true;
        });
        f.append('action', isEdit ? 'update' : 'create');
        f.append(CSRF.name, CSRF.value);
        fetch('<?php echo admin_url('deals/ratings'); ?>', {
            method: 'POST',
            body: f,
            credentials: 'same-origin'
        }).then(response => response.json()).then(data => {
            if (data.success) {
                $('#rating_modal').modal('hide');
                setTimeout(() => location.reload(), 100);
            } else {
                alert('Operation failed');
            }
        });
        return false;
    }
</script>
<?php //init_tail(); ?>
