<?php defined('BASEPATH') or exit('No direct script access allowed'); ?>
<?php
if (!isset($business_categories)) {
    $CI = &get_instance();
    $business_categories = $CI->db->order_by('name', 'asc')->get(db_prefix() . 'deals_business_categories')->result_array();
}
$csrf_name = $CI->security->get_csrf_token_name();
$csrf_hash = $CI->security->get_csrf_hash();
?>
<div class="panel_s">
    <div class="panel-body">
        <div class="">
            <div class="row">
                <div class="col-md-12">
                    <div class="tw-mb-2">
                        <a href="#" onclick="new_business_category(); return false;" class="btn btn-primary">
                            <i class="fa-regular fa-plus tw-mr-1"></i>
                            <?= _l('deal_new_business_category'); ?>
                        </a>
                    </div>
                    <div class="panel_s">
                        <div class="panel-body panel-table-full">
                            <?php if (count($business_categories) > 0) { ?>
                                <table class="table dt-table" data-order-col="1" data-order-type="asc">
                                    <thead>
                                        <th><?= _l('id'); ?></th>
                                        <th><?= _l('business_category_name'); ?></th>
                                        <th><?= _l('options'); ?></th>
                                    </thead>
                                    <tbody>
                                        <?php foreach ($business_categories as $category) { ?>
                                            <tr>
                                                <td><?= e($category['id']); ?></td>
                                                <td>
                                                    <a href="#" class="tw-font-medium"
                                                        onclick="edit_business_category(this,<?= e($category['id']); ?>); return false;"
                                                        data-name="<?= html_escape($category['name']); ?>">
                                                        <?= html_entity_decode($category['name']); ?>
                                                    </a>
                                                    <br>
                                                    <span class="text-muted">
                                                        <?= _l('deals_table_total', total_rows(db_prefix() . 'deals', ['business_category' => $category['id']])); ?>
                                                    </span>
                                                </td>
                                                <td>
                                                    <div class="tw-flex tw-items-center tw-space-x-2">
                                                        <a href="#"
                                                            onclick="edit_business_category(this,<?= e($category['id']); ?>); return false;"
                                                            data-name="<?= html_escape($category['name']); ?>"
                                                            class="tw-text-neutral-500 hover:tw-text-neutral-700 focus:tw-text-neutral-700">
                                                            <i class="fa-regular fa-pen-to-square fa-lg"></i>
                                                        </a>
                                                        <a href="#"
                                                            onclick="delete_business_category(<?= e($category['id']); ?>); return false;"
                                                            class="tw-text-neutral-500 hover:tw-text-neutral-700 focus:tw-text-neutral-700 _delete">
                                                            <i class="fa-regular fa-trash-can fa-lg"></i>
                                                        </a>
                                                    </div>
                                                </td>
                                            </tr>
                                        <?php } ?>
                                    </tbody>
                                </table>
                            <?php } else { ?>
                                <p class="no-margin">
                                    <?= _l('business_categories_not_found'); ?>
                                </p>
                            <?php } ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<div class="modal fade" id="business_category_modal" tabindex="-1" role="dialog">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span
                        aria-hidden="true">&times;</span></button>
                <h4 class="modal-title">
                    <span class="edit-title"><?= _l('edit_business_category'); ?></span>
                    <span class="add-title"><?= _l('deal_new_business_category'); ?></span>
                </h4>
            </div>
            <div class="modal-body">
                <div class="row">
                    <div class="col-md-12">
                        <div id="additional"></div>
                        <div class="form-group">
                            <label for="business_category_name" class="control-label"><?= _l('business_category_name'); ?></label>
                            <input type="text" id="business_category_name" name="name" class="form-control">
                        </div>
                    </div>
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-default" data-dismiss="modal"><?= _l('close'); ?></button>
                <button type="submit" class="btn btn-primary" onclick="manage_business_categories()"><?= _l('submit'); ?></button>
            </div>
        </div>
    </div>
</div>

<script>
    var CSRF = { name: '<?= $csrf_name; ?>', value: '<?= $csrf_hash; ?>' };

    function getBusinessCategoryApiUrl() {
        return (typeof admin_url !== 'undefined' ? admin_url : '<?= admin_url(); ?>') + 'deals/business_categories';
    }

    function requestBusinessCategory(action, payload, callback) {
        var form = new FormData();
        form.append('action', action);
        Object.keys(payload || {}).forEach(function (k) {
            if (Array.isArray(payload[k])) {
                payload[k].forEach(function(item, idx) {
                    form.append(k + '[]', item);
                });
            } else {
                form.append(k, payload[k]);
            }
        });
        form.append(CSRF.name, CSRF.value);
        fetch(getBusinessCategoryApiUrl(), {
            method: 'POST',
            body: form,
            credentials: 'same-origin'
        })
        .then(function(r) {
            return r.json().catch(function() { return {}; });
        })
        .then(function(data) {
            if (typeof callback === 'function') {
                callback(data.success, data);
            } else {
                if (data.success) {
                    $('#business_category_modal').modal('hide');
                    location.reload();
                } else if (data.referenced) {
                    alert('<?= _l('is_referenced', _l('deal_business_category_lowercase')); ?>');
                } else {
                    alert('Operation failed');
                }
            }
        });
    }

    function manage_business_categories() {
        var nameInput = document.getElementById('business_category_name');
        var idInput = document.querySelector('#additional input[name="id"]');
        var payload = {};

        if (!nameInput || !nameInput.value.trim()) {
            alert('<?= _l('business_category_name'); ?> is required.');
            return false;
        }

        payload.name = nameInput.value.trim();
        if (idInput && idInput.value) {
            payload.id = idInput.value;
            payload.action = 'update';
        } else {
            payload.action = 'create';
        }

        requestBusinessCategory(payload.action, payload, function(success, data) {
            if (success) {
                $('#business_category_modal').modal('hide');
                setTimeout(function() {
                    window.location.href = window.location.href;
                }, 100);
            } else if (data && data.referenced) {
                alert('<?= _l('is_referenced', _l('deal_business_category_lowercase')); ?>');
            } else {
                alert('Operation failed');
            }
        });
        return false;
    }

    function new_business_category() {
        $('#business_category_modal').modal('show');
        $('.edit-title').addClass('hide');
        $('.add-title').removeClass('hide');
        $('#additional').html('');
        $('#business_category_name').val('');
    }

    function edit_business_category(invoker, id) {
        $('#additional').html('<input type="hidden" name="id" value="' + id + '">');
        $('#business_category_name').val($(invoker).data('name'));
        $('#business_category_modal').modal('show');
        $('.add-title').addClass('hide');
        $('.edit-title').removeClass('hide');
    }

    function delete_business_category(id) {
        if (confirm('<?= _l('confirm_action_prompt'); ?>')) {
            requestBusinessCategory('delete', { id: id });
        }
    }

    $(function () {
        $('#business_category_modal').on('hidden.bs.modal', function () {
            $('#additional').html('');
            $('#business_category_name').val('');
            $('.add-title').removeClass('hide');
            $('.edit-title').removeClass('hide');
        });

        $('#business_category_name').on('input', function() {
            if ($(this).val().trim() === '') {
                $(this).addClass('is-invalid');
            } else {
                $(this).removeClass('is-invalid');
            }
        });
    });
</script>