<?php defined('BASEPATH') or exit('No direct script access allowed'); ?>
<?php init_head(); ?>
<div id="wrapper">
    <div class="content">
        <div class="row">
            <div class="col-md-12">
                <div class="panel_s">
                    <div class="panel-body">
                        <div class="tw-flex tw-justify-between tw-items-center tw-mb-3">
                            <h4 class="tw-m-0"><?php echo _l('email_templates'); ?> - Deals (<?php echo htmlentities($active_language); ?>)</h4>
                            <a href="<?php echo admin_url('deals/email_template'); ?>" class="btn btn-primary">
                                <i class="fa fa-plus"></i> <?php echo _l('add_new'); ?>
                            </a>
                        </div>
                        <div class="table-responsive">
                            <table class="table table-striped">
                                <thead>
                                    <tr>
                                        <th><?php echo _l('id'); ?></th>
                                        <th><?php echo _l('name'); ?></th>
                                        <th><?php echo _l('type'); ?></th>
                                        <th><?php echo _l('subject'); ?></th>
                                        <th><?php echo _l('description'); ?></th>
                                        <th><?php echo _l('active'); ?></th>
                                        <th><?php echo _l('options'); ?></th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php if (!empty($templates)) { foreach ($templates as $t) { ?>
                                        <tr>
                                            <td><?php echo (int) $t['id']; ?></td>
                                            <td><?php echo html_entity_decode($t['template_name']); ?></td>
                                            <td><?php echo html_entity_decode($t['template_type']); ?></td>
                                            <td><?php echo html_entity_decode($t['subject'] ?? ''); ?></td>
                                            <td><?php echo html_entity_decode($t['description'] ?? ''); ?></td>
                                            <td>
                                                <span class="label label-<?php echo !empty($t['is_active']) ? 'success' : 'default'; ?>">
                                                    <?php echo !empty($t['is_active']) ? _l('yes') : _l('no'); ?>
                                                </span>
                                            </td>
                                            <td>
                                                <a href="<?php echo admin_url('deals/email_template/' . (int) $t['id']); ?>" class="btn btn-xs btn-default"><i class="fa fa-edit"></i></a>
                                                <a href="<?php echo admin_url('deals/delete_email_template/' . (int) $t['id']); ?>" class="btn btn-xs btn-danger _delete"><i class="fa fa-trash"></i></a>
                                            </td>
                                        </tr>
                                    <?php } } else { ?>
                                        <tr><td colspan="7" class="text-center text-muted"><?php echo _l('no_results_found'); ?></td></tr>
                                    <?php } ?>
                                </tbody>
                            </table>
                        </div>
                        <div class="tw-mt-2 text-muted">
                            <strong>Hints:</strong>
                            <div>
                                Available merge fields: {deal_name}, {company}, {deal_value}, {assigned_name}
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<?php init_tail(); ?>

