<?php
defined('BASEPATH') or exit('No direct script access allowed');

class Deals_settings extends AdminController
{
    public function __construct()
    {
        parent::__construct();
        $this->load->model('deals/deals_model');
    }

    public function index()
    {
        // This controller is used only for AJAX actions from the settings view
        show_404();
    }

    public function business_categories()
    {
        if (!is_admin()) {
            access_denied('Deals Business Categories');
        }

        if ($this->input->post()) {
            $id = $this->input->post('id');
            $name = trim($this->input->post('name'));
            if ($name === '') {
                redirect(admin_url('settings?group=deals&tab=deals/manage_business_categories'));
            }
            if ($id) {
                $this->db->where('id', (int)$id)->update(db_prefix() . 'deals_business_categories', ['name' => $name]);
            } else {
                $this->db->insert(db_prefix() . 'deals_business_categories', ['name' => $name]);
            }
            redirect(admin_url('settings?group=deals&tab=deals/manage_business_categories'));
        }

        if ($this->input->get('action') === 'delete') {
            $id = (int)$this->input->get('id');
            $this->db->where('id', $id)->delete(db_prefix() . 'deals_business_categories');
            redirect(admin_url('settings?group=deals&tab=deals/manage_business_categories'));
        }

        $data['business_categories'] = $this->db->order_by('name', 'asc')->get(db_prefix() . 'deals_business_categories')->result_array();
        // dd(123);
        $this->load->view('manage_business_categories', $data);
    }

    public function ratings()
    {
        if (!is_admin()) {
            access_denied('Deals Ratings');
        }

        if ($this->input->post()) {
            $id = $this->input->post('id');
            $name = trim($this->input->post('name'));
            $score = (int) $this->input->post('score');
            if ($name === '') {
                redirect(admin_url('settings?group=deals&tab=deals/ratings'));
            }
            $payload = ['name' => $name, 'score' => $score];
            if ($id) {
                $this->db->where('id', (int)$id)->update(db_prefix() . 'deals_ratings', $payload);
            } else {
                $this->db->insert(db_prefix() . 'deals_ratings', $payload);
            }
            redirect(admin_url('settings?group=deals&tab=deals/ratings'));
        }

        if ($this->input->get('action') === 'delete') {
            $id = (int)$this->input->get('id');
            $this->db->where('id', $id)->delete(db_prefix() . 'deals_ratings');
            redirect(admin_url('settings?group=deals&tab=deals/ratings'));
        }

        $data['ratings'] = $this->db->order_by('score', 'desc')->get(db_prefix() . 'deals_ratings')->result_array();
        $this->load->view('ratings', $data);
    }

    public function pipelines()
    {
        // Re-order via drag & drop
        if ($this->input->post('action') === 'reorder_stages') {
            $ok = $this->deals_model->reorder_stages((int) $this->input->post('pipeline_id'), $this->input->post('order') ?? []);
            return $this->json(['success' => $ok]);
        }
        if ($this->input->post('action') === 'create') {
            $id = $this->deals_model->create_pipeline($this->input->post('name'));
            return $this->json(['success' => (bool) $id, 'id' => $id]);
        }
        if ($this->input->post('action') === 'update') {
            $ok = $this->deals_model->update_pipeline((int) $this->input->post('id'), ['name' => $this->input->post('name')]);
            return $this->json(['success' => $ok]);
        }
        if ($this->input->post('action') === 'delete') {
            $ok = $this->deals_model->delete_pipeline((int) $this->input->post('id'));
            return $this->json(['success' => $ok]);
        }

        // Manage stages order and CRUD
        if ($this->input->post('action') === 'create_stage') {
            $id = $this->deals_model->create_stage((int) $this->input->post('pipeline_id'), [
                'name' => $this->input->post('name'),
                'position' => (int) $this->input->post('position') ?? 0,
                'is_won' => (int) $this->input->post('is_won') ?? 0,
                'is_lost' => (int) $this->input->post('is_lost') ?? 0,
            ]);
            return $this->json(['success' => (bool) $id, 'id' => $id]);
        }
        if ($this->input->post('action') === 'update_stage') {
            $id = (int) $this->input->post('id');
            $data = [];
            if ($this->input->post('name') !== null) {
                $data['name'] = $this->input->post('name');
            }
            if ($this->input->post('position') !== null) {
                $data['position'] = (int) $this->input->post('position');
            }
            if ($this->input->post('win_probability') !== null) {
                $data['win_probability'] = (int) $this->input->post('win_probability');
            }
            if ($this->input->post('is_won') !== null) {
                $data['is_won'] = (int) $this->input->post('is_won');
            }
            if ($this->input->post('is_lost') !== null) {
                $data['is_lost'] = (int) $this->input->post('is_lost');
            }
            $ok = !empty($data) ? $this->deals_model->update_stage($id, $data) : true;
            return $this->json(['success' => $ok]);
        }
        if ($this->input->post('action') === 'delete_stage') {
            $ok = $this->deals_model->delete_stage((int) $this->input->post('id'));
            return $this->json(['success' => $ok]);
        }

        // Fetch pipelines + stages
        $pipelines = $this->deals_model->get_pipelines();
        foreach ($pipelines as &$p) {
            $p['stages'] = $this->deals_model->get_stages($p['id']);
        }

        $data['pipelines'] = $pipelines;
        $this->load->view('settings', $data);
    }

    public function lost_reasons()
    {
        if ($this->input->post('action') === 'create') {
            $id = $this->deals_model->create_lost_reason($this->input->post('name'));
            return $this->json(['success' => (bool) $id, 'id' => $id]);
        }
        if ($this->input->post('action') === 'update') {
            $ok = $this->deals_model->update_lost_reason((int) $this->input->post('id'), $this->input->post('name'));
            return $this->json(['success' => $ok]);
        }
        if ($this->input->post('action') === 'delete') {
            $ok = $this->deals_model->delete_lost_reason((int) $this->input->post('id'));
            return $this->json(['success' => $ok]);
        }

        $data['reasons'] = $this->deals_model->get_lost_reasons();
        $this->load->view('lost_reasons', $data);
    }

    private function json($payload)
    {
        $this->output->set_content_type('application/json')->set_output(json_encode($payload));
    }
}