<?php defined('BASEPATH') or exit('No direct script access allowed'); ?>

<h4 class="tw-mt-0 tw-mb-3 tw-font-semibold tw-text-lg tw-text-neutral-700 section-heading section-heading-projects" style="
    display: flex;
    justify-content: space-between;
">
    <?php echo $title; ?>
	<?php if(isset($campaigns) && !empty($campaigns)){ ?>
	<a href="/clients/campaigns">
	<button class="btn btn-default"> <i class="fa fa-arrow-left" aria-hidden="true"></i> Back</button>
	</a>
	<?php } ?>
</h4>

<div class="panel_s">
    <div class="panel-body">
		<?php if(isset($campaigns) && !empty($campaigns)){ ?>
        <table class="table dt-table table-campaigns" data-order-col="2" data-order-type="desc">
            <thead>
                <tr>
					<th class="th-campaign-no"><?= _l('#'); ?></th>
                    <th class="th-campaign-name"><?= _l('campaign_name'); ?></th>
                    <th class="th-campaign-company"><?= _l('campaign_company'); ?></th>
                    <th class="th-campaign-email"><?= _l('email'); ?></th>
                    <th class="th-campaign-phone"><?= _l('phone'); ?></th>
					<th class="th-campaign-value"><?= _l('value'); ?></th>					
					<th class="th-campaign-source"><?= _l('source'); ?></th>
					<th class="th-campaign-last-contact"><?= _l('last_contact'); ?></th>
					<th class="th-campaign-created"><?= _l('created'); ?></th>
					<th><?= _l('campaign_status'); ?></th>
                    <?php
                     $custom_fields = get_custom_fields('campaigns', ['show_on_client_portal' => 1]);
					foreach ($custom_fields as $field) { ?>
						<th><?= e($field['name']); ?>
						</th>
                    <?php } ?>                    
                </tr>
            </thead>
            <tbody>
                <?php
				
				foreach ($campaigns as $key => $campaign) { ?>
                <tr>
					<td><?= e($key+1); ?></td>
                    <td><?= e($campaign['name']); ?></td>
                    <td data-order="<?= e($campaign['company']); ?>"><?= e(_d($campaign['company'])); ?></td>
                    <td data-order="<?= e($campaign['email']); ?>"><?= e(_d($campaign['email'])); ?></td>
                    <td data-order="<?= e($campaign['phonenumber']); ?>"><?= e($campaign['phonenumber']); ?></td>	
					<td data-order="<?= e($campaign['campaign_value']); ?>"><?= e($campaign['campaign_value']); ?></td>
					<td data-order="<?= e($campaign['source']); ?>"><?= e(_d($this->campaigns_model->get_source($campaign['source'])->name));
					?></td>
					<td data-order="<?= e($campaign['lastcontact']); ?>"><?= e(_d($campaign['lastcontact'])); ?></td>
					<td data-order="<?= e($campaign['dateadded']); ?>"><?= e(_d($campaign['dateadded'])); ?></td>
					<td>
                        <?php foreach($statuses as $status): ?>
							<?php if($status['id'] == $campaign['status']): ?>
								<span class="campaign-status-<?php echo $campaign['status']; ?> label<?php echo empty($status['color']) ? ' label-default' : ''; ?>"
									  style="color: <?php echo $status['color']; ?>;
											 border: 1px solid <?php echo adjust_hex_brightness($status['color'], 0.4); ?>;
											 background: <?php echo adjust_hex_brightness($status['color'], 0.04); ?>;">
									<?php echo $status['name']; ?>
								</span>
							<?php endif; ?>
						<?php endforeach; ?>
                    </td>
                    <?php foreach ($custom_fields as $field) { ?>
                    <td><?= get_custom_field_value($project['id'], $field['id'], 'projects'); ?>
                    </td>
                    <?php } ?>
                </tr>
                <?php } ?>
            </tbody>
        </table>
		<?php } else { ?>
		<table class="table dt-table table-campaigns" data-order-col="2" data-order-type="desc">
            <thead>
                <tr>
					<th class="th-campaign-no"><?= _l('#'); ?></th>
                    <th class="th-campaign-name"><?= _l('Form Name'); ?></th>
                    <th class="th-campaign-company"><?= _l('Total Submissions'); ?></th>
                    <th class="th-campaign-email"><?= _l('Last Submission Time'); ?></th>
                    <th class="th-campaign-phone"><?= _l('Created'); ?></th>					
					<th class="th-campaign-created"><?= _l('Action'); ?></th>					                   
                </tr>
            </thead>
            <tbody>
                <?php
				
				foreach ($campaign_forms as $key => $campaign) { ?>
                <tr>
					<td><?= e($key+1); ?></td>                    
                    <td data-order="<?= e($campaign['tblweb_to_campaign.name']); ?>"><?= e($campaign['tblweb_to_campaign.name']); ?></td>
                    <td data-order="<?= e($campaign['total_submissions']); ?>"><?= e(_d($campaign['total_submissions'])); ?></td>
                    <td data-order="<?= e($campaign['last_submission_time']); ?>"><?= e($campaign['last_submission_time']); ?></td>	
					<td data-order="<?= e($campaign['tblweb_to_campaign.dateadded']); ?>"><?= e($campaign['tblweb_to_campaign.dateadded']); ?></td>
					<th class="th-campaign-created">
						<a href="<?php echo '/clients/campaigns/'. $campaign['tblweb_to_campaign.id']; ?>">View</a>
					</th>
                </tr>
                <?php } ?>
            </tbody>
        </table>
		<?php } ?>
    </div>
</div>