<?php

defined('BASEPATH') or exit('No direct script access allowed');

// Build deals filters and server-side output similar to leads
$CI = &get_instance();
$CI->load->model('deals/deals_model');
$CI->load->model('staff_model');

$rules = [
    App_table_filter::new('name', 'TextRule')->label(_l('deals_dt_name')),
    App_table_filter::new('company', 'TextRule')->label(_l('company')),
    App_table_filter::new('deal_value', 'NumberRule')->label(_l('deal_value')),
    App_table_filter::new('dateadded', 'DateRule')->label(_l('date_created')),
    App_table_filter::new('status_final', 'MultiSelectRule')->label(_l('status'))->options([
        ['value' => 'open', 'label' => _l('open')],
        ['value' => 'won', 'label' => _l('won')],
        ['value' => 'lost', 'label' => _l('lost')],
    ]),
    App_table_filter::new('pipeline_id', 'SelectRule')->label(_l('pipeline'))->options(function () use ($CI) {
        $pipelines = $CI->db->get(db_prefix() . 'deals_pipelines')->result_array();
        return collect($pipelines)->map(fn($p) => ['value' => $p['id'], 'label' => $p['name']])->all();
    }),
    App_table_filter::new('stage_id', 'SelectRule')->label(_l('stage'))->options(function () use ($CI) {
        $stages = $CI->db->get(db_prefix() . 'deals_stages')->result_array();
        return collect($stages)->map(fn($s) => ['value' => $s['id'], 'label' => $s['name']])->all();
    }),
    App_table_filter::new('status', 'SelectRule')->label(_l('leads_dt_status'))->options(function () use ($CI) {
        $statuses = $CI->deals_model->get_status();
        return collect($statuses)->map(fn($s) => ['value' => $s['id'], 'label' => $s['name']])->all();
    }),
    App_table_filter::new('source', 'SelectRule')->label(_l('leads_source'))->options(function () use ($CI) {
        $sources = $CI->deals_model->get_source();
        return collect($sources)->map(fn($s) => ['value' => $s['id'], 'label' => $s['name']])->all();
    }),
];

$rules[] = App_table_filter::new('assigned', 'SelectRule')->label(_l('assigned_to'))
    ->withEmptyOperators()->emptyOperatorValue(0)
    ->isVisible(fn () => staff_can('view', 'deals'))
    ->options(function () use ($CI) {
        $staff = $CI->staff_model->get('', ['active' => 1]);
        return collect($staff)->map(fn ($m) => ['value' => $m['staffid'], 'label' => $m['firstname'] . ' ' . $m['lastname']])->all();
    });

return App_table::find('deals')
    ->setRules($rules)
    ->outputUsing(function ($params) {
        extract($params);
        $aColumns = [
            '1',
            db_prefix() . 'deals.id as id',
            db_prefix() . 'deals.name as name',
            'company',
            db_prefix() . 'deals.deal_value as deal_value',
            'status_final',
            'dp.name as pipeline_name',
            'ds.name as stage_name',
            '(SELECT GROUP_CONCAT(name SEPARATOR ",") FROM ' . db_prefix() . 'taggables JOIN ' . db_prefix() . 'tags ON ' . db_prefix() . 'taggables.tag_id = ' . db_prefix() . 'tags.id WHERE rel_id = ' . db_prefix() . 'deals.id and rel_type="deal" ORDER by tag_order ASC LIMIT 1) as tags',
            'dateadded',
        ];

        $sIndexColumn = 'id';
        $sTable       = db_prefix() . 'deals';
        $join = [
            'LEFT JOIN ' . db_prefix() . 'deals_pipelines dp ON dp.id = ' . db_prefix() . 'deals.pipeline_id',
            'LEFT JOIN ' . db_prefix() . 'deals_stages ds ON ds.id = ' . db_prefix() . 'deals.stage_id',
        ];

        $where = [];
        if ($filtersWhere = $this->getWhereFromRules()) {
            $where[] = $filtersWhere;
        }

        if (staff_cant('view', 'deals')) {
            $where[] = 'AND (' . db_prefix() . 'deals.assigned = ' . get_staff_user_id() . ' OR ' . db_prefix() . 'deals.addedfrom=' . get_staff_user_id() . ' OR ' . db_prefix() . 'deals.is_public=1)';
        }

        $additionalColumns = [
            db_prefix() . 'deals.addedfrom as addedfrom',
        ];

        $result = data_tables_init($aColumns, $sIndexColumn, $sTable, $join, $where, $additionalColumns);
        $output  = $result['output'];
        $rResult = $result['rResult'];

        foreach ($rResult as $aRow) {
            $row = [];
            $row[] = '<div class="checkbox"><input type="checkbox" value="' . $aRow['id'] . '"><label></label></div>';
            $hrefAttr = 'href="' . admin_url('deals/view/' . $aRow['id']) . '"';
            $row[] = '<a ' . $hrefAttr . ' class="tw-font-medium">' . $aRow['id'] . '</a>';
            $nameRow = '<a ' . $hrefAttr . ' class="tw-font-medium">' . e($aRow['name']) . '</a>';
            $nameRow .= '<div class="row-options">';
            $nameRow .= '<a ' . $hrefAttr . '>' . _l('view') . '</a>';
            $nameRow .= ' | <a href="' . admin_url('deals/edit/' . $aRow['id']) . '">' . _l('edit') . '</a>';
            $nameRow .= ' | <a href="' . admin_url('deals/delete/' . $aRow['id']) . '" class="_delete text-danger">' . _l('delete') . '</a>';
            $nameRow .= '</div>';
            $row[] = $nameRow;
            $row[] = e($aRow['company']);
            $row[] = '<span class="tw-font-medium">' . app_format_money((float)$aRow['deal_value'], get_base_currency()->id) . '</span>';
            $row[] = ucfirst($aRow['status_final']);
            $row[] = e($aRow['pipeline_name']);
            $row[] = e($aRow['stage_name']);
            $row[] = render_tags($aRow['tags']);
            $row[] = '<span data-toggle="tooltip" data-title="' . e(_dt($aRow['dateadded'])) . '" class="text-has-action is-date">' . e(time_ago($aRow['dateadded'])) . '</span>';
            $row['DT_RowId'] = 'deal_' . $aRow['id'];
            $output['aaData'][] = $row;
        }

        return $output;
    });


