<?php
defined('BASEPATH') or exit('No direct script access allowed');

$this->ci->load->model('gdpr_model');
$this->ci->load->model('campaigns_model');
$this->ci->load->model('staff_model');
$statuses = $this->ci->campaigns_model->get_status();

if (is_gdpr() && get_option('gdpr_enable_consent_for_campaigns') == '1') {
    $consent_purposes = $this->ci->gdpr_model->get_consent_purposes();
}

$rules = [
    App_table_filter::new('name', 'TextRule')->label(_l('campaigns_dt_name')),
    App_table_filter::new('phonenumber', 'TextRule')->label(_l('campaigns_dt_phonenumber')),
    App_table_filter::new('country', 'SelectRule')->label(_l('campaign_country'))->options(function ($ci) {
        return collect(get_all_countries())->map(fn ($country) => [
            'value' => $country['country_id'],
            'label' => $country['short_name'],
        ]);
    }),
    App_table_filter::new('city', 'TextRule')->label(_l('campaign_city')),
    App_table_filter::new('state', 'TextRule')->label(_l('campaign_state')),
    App_table_filter::new('zip', 'TextRule')->label(_l('campaign_zip')),
    App_table_filter::new('is_public', 'BooleanRule')->label(_l('campaign_public')),
    App_table_filter::new('lost', 'BooleanRule')->label(_l('campaign_lost')),
    App_table_filter::new('junk', 'BooleanRule')->label(_l('campaign_junk')),
    App_table_filter::new('lastcontact', 'DateRule')->label(_l('campaigns_dt_last_contact')),
    App_table_filter::new('dateadded', 'DateRule')->label(_l('date_created')),
    App_table_filter::new('dateassigned', 'DateRule')->label(_l('customer_admin_date_assigned')),
    App_table_filter::new('campaign_value', 'NumberRule')->label(_l('campaign_add_edit_campaign_value')),
    App_table_filter::new('status', 'MultiSelectRule')->label(_l('campaign_status'))->options(function () use ($statuses) {
        return collect($statuses)->map(fn ($status) => [
            'value' => $status['id'],
            'label' => $status['name'],
            'subtext' => $status['isdefault'] == 1 ? _l('campaigns_converted_to_client') : null,
        ]);
    }),
    App_table_filter::new('source', 'MultiSelectRule')->label(_l('campaign_source'))->options(function ($ci) {
        return collect($ci->campaigns_model->get_source())->map(fn ($source) => [
            'value' => $source['id'],
            'label' => $source['name'],
        ]);
    }),
];

$rules[] = App_table_filter::new('assigned', 'SelectRule')->label(_l('campaigns_dt_assigned'))
    ->withEmptyOperators()
    ->emptyOperatorValue(0)
    ->isVisible(fn () => staff_can('view', 'campaigns'))
    ->options(function ($ci) {
        $staff = $ci->staff_model->get('', ['active' => 1]);
        return collect($staff)->map(function ($staff) {
            return [
                'value' => $staff['staffid'],
                'label' => $staff['firstname'] . ' ' . $staff['lastname']
            ];
        })->all();
    });

$rules[] = App_table_filter::new('from_form_id', 'SelectRule')
    ->label(_l('form'))
    ->options(function ($ci) {
        $forms = $ci->db->get(db_prefix() . 'web_to_campaign')->result_array();
        return collect($forms)->map(function ($form) {
            return [
                'value' => $form['id'],
                'label' => $form['name']
            ];
        })->all();
    });

if (isset($consent_purposes)) {
    $rules[] = App_table_filter::new('gdpr_content', 'SelectRule')
        ->label(_l('gdpr_consent'))
        ->options(function () use ($consent_purposes) {
            return collect($consent_purposes)->map(fn ($purpose) => [
                'value' => $purpose['id'],
                'label' => $purpose['name']
            ]);
        })->raw(function ($value, $operator, $sql_operator) {
            return db_prefix() . 'campaigns.id ' . $sql_operator . ' (SELECT campaign_id FROM ' . db_prefix() . 'consents WHERE purpose_id=' . $value . ' and action="opt-in" AND date IN (SELECT MAX(date) FROM ' . db_prefix() . 'consents WHERE purpose_id=' . $value . ' AND campaign_id=' . db_prefix() . 'campaigns.id))';
        });
}

// Configure campaigns table
App_table::find('campaigns')
    ->outputUsing(function ($params) use ($statuses) {
        // [Existing campaigns output logic]
        extract($params);

        $lockAfterConvert = get_option('campaign_lock_after_convert_to_customer');
        $has_permission_delete = staff_can('delete', 'campaigns');
        $custom_fields = get_table_custom_fields('campaigns');
        $consentCampaigns = get_option('gdpr_enable_consent_for_campaigns');

        $aColumns = [
            '1',
            db_prefix() . 'campaigns.id as id',
            db_prefix() . 'campaigns.name as name',
        ];
        if (is_gdpr() && $consentCampaigns == '1') {
            $aColumns[] = '1';
        }
        $aColumns = array_merge($aColumns, [
            'company',
            db_prefix() . 'campaigns.email as email',
            db_prefix() . 'campaigns.phonenumber as phonenumber',
            'campaign_value',
            '(SELECT GROUP_CONCAT(name SEPARATOR ",") FROM ' . db_prefix() . 'taggables JOIN ' . db_prefix() . 'tags ON ' . db_prefix() . 'taggables.tag_id = ' . db_prefix() . 'tags.id WHERE rel_id = ' . db_prefix() . 'campaigns.id and rel_type="campaign" ORDER by tag_order ASC LIMIT 1) as tags',
            'firstname as assigned_firstname',
            db_prefix() . 'campaigns_status.name as status_name',
            db_prefix() . 'campaigns_sources.name as source_name',
            'lastcontact',
            'dateadded',
        ]);

        $sIndexColumn = 'id';
        $sTable = db_prefix() . 'campaigns';

        $join = [
            'LEFT JOIN ' . db_prefix() . 'staff ON ' . db_prefix() . 'staff.staffid = ' . db_prefix() . 'campaigns.assigned',
            'LEFT JOIN ' . db_prefix() . 'campaigns_status ON ' . db_prefix() . 'campaigns_status.id = ' . db_prefix() . 'campaigns.status',
            'JOIN ' . db_prefix() . 'campaigns_sources ON ' . db_prefix() . 'campaigns_sources.id = ' . db_prefix() . 'campaigns.source',
        ];

        foreach ($custom_fields as $key => $field) {
            $selectAs = (is_cf_date($field) ? 'date_picker_cvalue_' . $key : 'cvalue_' . $key);
            array_push($customFieldsColumns, $selectAs);
            array_push($aColumns, 'ctable_' . $key . '.value as ' . $selectAs);
            array_push($join, 'LEFT JOIN ' . db_prefix() . 'customfieldsvalues as ctable_' . $key . ' ON ' . db_prefix() . 'campaigns.id = ctable_' . $key . '.relid AND ctable_' . $key . '.fieldto="' . $field['fieldto'] . '" AND ctable_' . $key . '.fieldid=' . $field['id']);
        }

        $where = [];

        if ($filtersWhere = $this->getWhereFromRules()) {
            $where[] = $filtersWhere;
        }

        if (staff_cant('view', 'campaigns')) {
            array_push($where, 'AND (assigned =' . get_staff_user_id() . ' OR addedfrom = ' . get_staff_user_id() . ' OR is_public = 1)');
        }

        $aColumns = hooks()->apply_filters('campaigns_table_sql_columns', $aColumns);

        if (count($custom_fields) > 4) {
            @$this->ci->db->query('SET SQL_BIG_SELECTS=1');
        }

        $additionalColumns = hooks()->apply_filters('campaigns_table_additional_columns_sql', [
            'junk',
            'lost',
            'color',
            'status',
            'assigned',
            'lastname as assigned_lastname',
            db_prefix() . 'campaigns.addedfrom as addedfrom',
            '(SELECT count(campaignid) FROM ' . db_prefix() . 'clients WHERE ' . db_prefix() . 'clients.campaignid=' . db_prefix() . 'campaigns.id) as is_converted',
            'zip',
        ]);

        $result = data_tables_init($aColumns, $sIndexColumn, $sTable, $join, $where, $additionalColumns);

        $output = $result['output'];
        $rResult = $result['rResult'];

        foreach ($rResult as $aRow) {
            $row = [];

            $row[] = '<div class="checkbox"><input type="checkbox" value="' . $aRow['id'] . '"><label></label></div>';

            $hrefAttr = 'href="' . admin_url('campaigns/index/' . $aRow['id']) . '" onclick="init_campaign(' . $aRow['id'] . ');return false;"';
            $row[] = '<a ' . $hrefAttr . '>' . $aRow['id'] . '</a>';

            $nameRow = '<a ' . $hrefAttr . '>' . e($aRow['name']) . '</a>';

            $nameRow .= '<div class="row-options">';
            $nameRow .= '<a ' . $hrefAttr . '>' . _l('view') . '</a>';

            $locked = false;

            if ($aRow['is_converted'] > 0) {
                $locked = ((!is_admin() && $lockAfterConvert == 1) ? true : false);
            }

            if (!$locked) {
                $nameRow .= ' | <a href="' . admin_url('campaigns/index/' . $aRow['id'] . '?edit=true') . '" onclick="init_campaign(' . $aRow['id'] . ', true);return false;">' . _l('edit') . '</a>';
            }

            if ($aRow['addedfrom'] == get_staff_user_id() || $has_permission_delete) {
                $nameRow .= ' | <a href="' . admin_url('campaigns/delete/' . $aRow['id']) . '" class="_delete text-danger">' . _l('delete') . '</a>';
            }
            $nameRow .= '</div>';

            $row[] = $nameRow;

            if (is_gdpr() && $consentCampaigns == '1') {
                $consentHTML = '<p class="bold"><a href="#" onclick="view_campaign_consent(' . $aRow['id'] . '); return false;">' . _l('view_consent') . '</a></p>';
                $consents = $this->ci->gdpr_model->get_consent_purposes($aRow['id'], 'campaign');

                foreach ($consents as $consent) {
                    $consentHTML .= '<p style="margin-bottom:0px;">' . e($consent['name']) . (!empty($consent['consent_given']) ? '<i class="fa fa-check text-success pull-right"></i>' : '<i class="fa fa-remove text-danger pull-right"></i>') . '</p>';
                }
                $row[] = $consentHTML;
            }
            $row[] = e($aRow['company']);

            $row[] = ($aRow['email'] != '' ? '<a href="mailto:' . e($aRow['email']) . '">' . e($aRow['email']) . '</a>' : '');

            $row[] = ($aRow['phonenumber'] != '' ? '<a href="tel:' . e($aRow['phonenumber']) . '">' . e($aRow['phonenumber']) . '</a>' : '');

            $base_currency = get_base_currency();
            $row[] = e(($aRow['campaign_value'] != 0 ? app_format_money($aRow['campaign_value'], $base_currency->id) : ''));

            $row[] = render_tags($aRow['tags']);

            $assignedOutput = '';
            if ($aRow['assigned'] != 0) {
                $full_name = e($aRow['assigned_firstname'] . ' ' . $aRow['assigned_lastname']);

                $assignedOutput = '<a data-toggle="tooltip" data-title="' . $full_name . '" href="' . admin_url('profile/' . $aRow['assigned']) . '">' . staff_profile_image($aRow['assigned'], [
                    'staff-profile-image-small',
                ]) . '</a>';

                $assignedOutput .= '<span class="hide">' . $full_name . '</span>';
            }

            $row[] = $assignedOutput;

            if ($aRow['status_name'] == null) {
                if ($aRow['lost'] == 1) {
                    $outputStatus = '<span class="label label-danger">' . _l('campaign_lost') . '</span>';
                } elseif ($aRow['junk'] == 1) {
                    $outputStatus = '<span class="label label-warning">' . _l('campaign_junk') . '</span>';
                }
            } else {
                $outputStatus = '<span class="campaign-status-' . $aRow['status'] . ' label' . (empty($aRow['color']) ? ' label-default' : '') . '" style="color:' . $aRow['color'] . ';border:1px solid ' . adjust_hex_brightness($aRow['color'], 0.4) . ';background: ' . adjust_hex_brightness($aRow['color'], 0.04) . ';">' . e($aRow['status_name']);

                if (!$locked) {
                    $outputStatus .= '<div class="dropdown inline-block mleft5 table-export-exclude">';
                    $outputStatus .= '<a href="#" style="font-size:14px;vertical-align:middle;" class="dropdown-toggle text-dark" id="tableCampaignsStatus-' . $aRow['id'] . '" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">';
                    $outputStatus .= '<span data-toggle="tooltip" title="' . _l('ticket_single_change_status') . '"><i class="fa-solid fa-chevron-down tw-opacity-70"></i></span>';
                    $outputStatus .= '</a>';

                    $outputStatus .= '<ul class="dropdown-menu dropdown-menu-right" aria-labelledby="tableCampaignsStatus-' . $aRow['id'] . '">';
                    foreach ($statuses as $campaignChangeStatus) {
                        if ($aRow['status'] != $campaignChangeStatus['id']) {
                            $outputStatus .= '<li>
                          <a href="#" onclick="campaign_mark_as(' . $campaignChangeStatus['id'] . ',' . $aRow['id'] . '); return false;">
                             ' . e($campaignChangeStatus['name']) . '
                          </a>
                       </li>';
                        }
                    }
                    $outputStatus .= '</ul>';
                    $outputStatus .= '</div>';
                }
                $outputStatus .= '</span>';
            }

            $row[] = $outputStatus;

            $row[] = e($aRow['source_name']);

            $row[] = ($aRow['lastcontact'] == '0000-00-00 00:00:00' || !is_date($aRow['lastcontact']) ? '' : '<span data-toggle="tooltip" data-title="' . e(_dt($aRow['lastcontact'])) . '" class="text-has-action is-date">' . e(time_ago($aRow['lastcontact'])) . '</span>');

            $row[] = '<span data-toggle="tooltip" data-title="' . e(_dt($aRow['dateadded'])) . '" class="text-has-action is-date">' . e(time_ago($aRow['dateadded'])) . '</span>';

            foreach ($customFieldsColumns as $customFieldColumn) {
                $row[] = (strpos($customFieldColumn, 'date_picker_') !== false ? _d($aRow[$customFieldColumn]) : $aRow[$customFieldColumn]);
            }

            $row['DT_RowId'] = 'campaign_' . $aRow['id'];

            if ($aRow['assigned'] == get_staff_user_id()) {
                $row['DT_RowClass'] = 'info';
            }

            if (isset($row['DT_RowClass'])) {
                $row['DT_RowClass'] .= ' has-row-options';
            } else {
                $row['DT_RowClass'] = 'has-row-options';
            }

            $row = hooks()->apply_filters('campaigns_table_row_data', $row, $aRow);

            $output['aaData'][] = $row;
        }
        return $output;
    })->setRules($rules);

// Configure campaigns_form table
return App_table::find('campaigns_form')
    ->outputUsing(function ($params) use ($statuses) {
        extract($params);

        $form_id = $this->ci->input->post('form_id') ?: $params['form_id'] ?? null;
        if (!$form_id) {
            return ['aaData' => [], 'recordsTotal' => 0, 'recordsFiltered' => 0];
        }

        $lockAfterConvert = get_option('campaign_lock_after_convert_to_customer');
        $has_permission_delete = staff_can('delete', 'campaigns');
        $custom_fields = get_table_custom_fields('campaigns');
        $consentCampaigns = get_option('gdpr_enable_consent_for_campaigns');

        $aColumns = [
            db_prefix() . 'campaigns.id as id',
            db_prefix() . 'campaigns.name as name',
            db_prefix() . 'campaigns.email as email',
            db_prefix() . 'campaigns.phonenumber as phonenumber',
            'company',
            'campaign_value',
            'firstname as assigned_firstname',
            db_prefix() . 'campaigns_status.name as status_name',
            db_prefix() . 'campaigns_sources.name as source_name',
            'dateadded',
            '1',
        ];

        $sIndexColumn = 'id';
        $sTable = db_prefix() . 'campaigns';

        $join = [
            'LEFT JOIN ' . db_prefix() . 'staff ON ' . db_prefix() . 'staff.staffid = ' . db_prefix() . 'campaigns.assigned',
            'LEFT JOIN ' . db_prefix() . 'campaigns_status ON ' . db_prefix() . 'campaigns_status.id = ' . db_prefix() . 'campaigns.status',
            'JOIN ' . db_prefix() . 'campaigns_sources ON ' . db_prefix() . 'campaigns_sources.id = ' . db_prefix() . 'campaigns.source',
        ];

        $customFieldsColumns = [];
        foreach ($custom_fields as $key => $field) {
            $selectAs = (is_cf_date($field) ? 'date_picker_cvalue_' . $key : 'cvalue_' . $key);
            array_push($customFieldsColumns, $selectAs);
            array_push($aColumns, 'ctable_' . $key . '.value as ' . $selectAs);
            array_push($join, 'LEFT JOIN ' . db_prefix() . 'customfieldsvalues as ctable_' . $key . ' ON ' . db_prefix() . 'campaigns.id = ctable_' . $key . '.relid AND ctable_' . $key . '.fieldto="' . $field['fieldto'] . '" AND ctable_' . $key . '.fieldid=' . $field['id']);
        }

        $where = ['AND ' . db_prefix() . 'campaigns.from_form_id = ' . $this->ci->db->escape($form_id)];

        if ($filtersWhere = $this->getWhereFromRules()) {
            $where[] = $filtersWhere;
        }

        if (staff_cant('view', 'campaigns')) {
            array_push($where, 'AND (assigned =' . get_staff_user_id() . ' OR addedfrom = ' . get_staff_user_id() . ' OR is_public = 1)');
        }

        $additionalColumns = [
            'junk',
            'lost',
            'color',
            'status',
            'assigned',
            'lastname as assigned_lastname',
            db_prefix() . 'campaigns.addedfrom as addedfrom',
            '(SELECT count(campaignid) FROM ' . db_prefix() . 'clients WHERE ' . db_prefix() . 'clients.campaignid=' . db_prefix() . 'campaigns.id) as is_converted',
            'zip',
        ];

        $result = data_tables_init($aColumns, $sIndexColumn, $sTable, $join, $where, $additionalColumns);

        $output = $result['output'];
        $rResult = $result['rResult'];

        foreach ($rResult as $aRow) {
            $row = [];

            $row[] = $aRow['id'];
            $row[] = '<a href="' . admin_url('campaigns/index/' . $aRow['id']) . '" onclick="init_campaign(' . $aRow['id'] . ');return false;">' . e($aRow['name']) . '</a>';
            $row[] = ($aRow['email'] != '' ? '<a href="mailto:' . e($aRow['email']) . '">' . e($aRow['email']) . '</a>' : '');
            $row[] = ($aRow['phonenumber'] != '' ? '<a href="tel:' . e($aRow['phonenumber']) . '">' . e($aRow['phonenumber']) . '</a>' : '');
            $row[] = e($aRow['company']);
            $base_currency = get_base_currency();
            $row[] = e(($aRow['campaign_value'] != 0 ? app_format_money($aRow['campaign_value'], $base_currency->id) : ''));

            $assignedOutput = '';
            if ($aRow['assigned'] != 0) {
                $full_name = e($aRow['assigned_firstname'] . ' ' . $aRow['assigned_lastname']);
                $assignedOutput = '<a data-toggle="tooltip" data-title="' . $full_name . '" href="' . admin_url('profile/' . $aRow['assigned']) . '">' . staff_profile_image($aRow['assigned'], ['staff-profile-image-small']) . '</a>';
                $assignedOutput .= '<span class="hide">' . $full_name . '</span>';
            }
            $row[] = $assignedOutput;

            $locked = $aRow['is_converted'] > 0 && !is_admin() && $lockAfterConvert == 1;
            $outputStatus = '';
            if ($aRow['status_name'] == null) {
                if ($aRow['lost'] == 1) {
                    $outputStatus = '<span class="label label-danger">' . _l('campaign_lost') . '</span>';
                } elseif ($aRow['junk'] == 1) {
                    $outputStatus = '<span class="label label-warning">' . _l('campaign_junk') . '</span>';
                }
            } else {
                $outputStatus = '<span class="campaign-status-' . $aRow['status'] . ' label" style="color:' . $aRow['color'] . ';border:1px solid ' . adjust_hex_brightness($aRow['color'], 0.4) . ';background: ' . adjust_hex_brightness($aRow['color'], 0.04) . ';">' . e($aRow['status_name']);
                if (!$locked) {
                    $outputStatus .= '<div class="dropdown inline-block mleft5 table-export-exclude">';
                    $outputStatus .= '<a href="#" style="font-size:14px;vertical-align:middle;" class="dropdown-toggle text-dark" id="tableCampaignsStatus-' . $aRow['id'] . '" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">';
                    $outputStatus .= '<span data-toggle="tooltip" title="' . _l('ticket_single_change_status') . '"><i class="fa fa-chevron-down"></i></span>';
                    $outputStatus .= '</a>';
                    $outputStatus .= '<ul class="dropdown-menu dropdown-menu-right" aria-labelledby="tableCampaignsStatus-' . $aRow['id'] . '">';
                    foreach ($statuses as $s) {
                        if ($s['id'] != $aRow['status']) {
                            $outputStatus .= '<li><a href="#" onclick="campaign_mark_as(' . $s['id'] . ', ' . $aRow['id'] . '); return false;">' . e($s['name']) . '</a></li>';
                        }
                    }
                    $outputStatus .= '</ul></div>';
                }
                $outputStatus .= '</span>';
            }
            $row[] = $outputStatus;

            $row[] = e($aRow['source_name']);
            $row[] = '<span data-toggle="tooltip" data-title="' . e(_dt($aRow['dateadded'])) . '" class="text-has-action is-date">' . e(time_ago($aRow['dateadded'])) . '</span>';

            $actions = '<div class="row-options">';
            $actions .= '<a href="#" onclick="init_campaign(' . $aRow['id'] . '); return false;">' . _l('view') . '</a>';
            if (!$locked) {
                $actions .= ' | <a href="#" onclick="init_campaign(' . $aRow['id'] . ', true); return false;">' . _l('edit') . '</a>';
            }
            if ($aRow['addedfrom'] == get_staff_user_id() || $has_permission_delete) {
                $actions .= ' | <a href="' . admin_url('campaigns/delete/' . $aRow['id']) . '" class="text-danger _delete">' . _l('delete') . '</a>';
            }
            $actions .= '</div>';
            $row[] = $actions;

            $row['DT_RowId'] = 'campaign_' . $aRow['id'];
            $row = hooks()->apply_filters('campaigns_table_row_data', $row, $aRow);

            $output['aaData'][] = $row;
        }
        return $output;
    })->setRules($rules);