<?php
defined('BASEPATH') or exit('No direct script access allowed');
// Define table columns for restoration projects
$table_data = [
    _l('the_number_sign'), // ID
    _l('project_name'), // Name
    _l('imo_number'), // IMO Number
    [
        'name'     => _l('project_customer'),
        'th_attrs' => ['class' => isset($client_id) ? 'not_visible' : ''], // Hide client column if client_id is set
    ],
    _l('project_start_date'), // Start Date
    _l('project_deadline'), // Deadline
    _l('project_created'), // Project Created
    _l('project_status'), // Status
];

// Add custom fields for restoration projects
$custom_fields = get_custom_fields('restoration_projects', ['show_on_table' => 1]);
foreach ($custom_fields as $field) {
    array_push($table_data, [
        'name'     => $field['name'],
        'th_attrs' => ['data-type' => $field['type'], 'data-custom-field' => 1],
    ]);
}

// Apply hooks to allow column customization
$table_data = hooks()->apply_filters('restoration_projects_table_columns', $table_data);

// Render the DataTable
render_datatable($table_data, isset($class) ? $class : 'restoration_projects', ['number-index-1'], [
    'data-last-order-identifier' => 'restoration_projects',
    'data-default-order'         => get_table_last_order('restoration_projects'),
    'id'                         => $table_id ?? 'restoration_projects',
    'data-ajax-params'           => json_encode(['client_id' => isset($client_id) ? $client_id : 0, '_where' => isset($_where) ? $_where : '']),
]);
?>