<?php defined('BASEPATH') or exit('No direct script access allowed'); ?>
<div class="widget<?php if (count($projects_activity) == 0) {
    echo ' hide';
} ?>" id="widget-<?php echo create_widget_id(); ?>" data-name="<?php echo _l('home_restoration_project_activity'); ?>">
    <div class="panel_s projects-activity">
        <div class="panel-body padding-10">
            <div class="widget-dragger"></div>
            <p class="tw-font-semibold tw-flex tw-items-center tw-mb-0 tw-space-x-1.5 rtl:tw-space-x-reverse tw-p-1.5">
                <svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke-width="1.5"
                    stroke="currentColor" class="tw-w-6 tw-h-6 tw-text-neutral-500">
                    <path stroke-linecap="round" stroke-linejoin="round"
                        d="M8.25 6.75h12M8.25 12h12m-12 5.25h12M3.75 6.75h.007v.008H3.75V6.75zm.375 0a.375.375 0 11-.75 0 .375.375 0 01.75 0zM3.75 12h.007v.008H3.75V12zm.375 0a.375.375 0 11-.75 0 .375.375 0 01.75 0zm-.375 5.25h.007v.008H3.75v-.008zm.375 0a.375.375 0 11-.75 0 .375.375 0 01.75 0z" />
                </svg>
                <span class="tw-text-neutral-700">
                    <?php echo _l('home_restoration_project_activity'); ?>
                </span>
            </p>

            <hr class="-tw-mx-3 tw-mt-3 tw-mb-6">

            <div class="activity-feed">
                <?php
                    // Debugging: Log the $projects_activity array to inspect its structure
                    // Remove this after debugging
                    // echo '<pre>'; var_dump($projects_activity); echo '</pre>';

                    $filtered_activities = 0; // Counter to check if any activities are displayed
                    foreach ($projects_activity as $activity) {
                        // Check if rel_type is 'restoration'
                        if (!isset($activity['rel_type']) || $activity['rel_type'] !== 'restoration') {
                            continue; 
                        }
                        $filtered_activities++; // Increment counter for valid activities
                        $name = e($activity['fullname']);
                        if ($activity['staff_id'] != 0) {
                            $href = admin_url('profile/' . $activity['staff_id']);
                        } elseif ($activity['contact_id'] != 0) {
                            $name = '<span class="label label-info inline-block mright5">' . _l('is_customer_indicator') . '</span> - ' . $name;
                            $href = admin_url('clients/client/' . get_user_id_by_contact_id($activity['contact_id']) . '?contactid=' . $activity['contact_id']);
                        } else {
                            $href = '';
                            $name = '[CRON]';
                        }

                        // Fetch project_name from tblprojects using project_id
                        $project_name = 'Unknown Project';
                        if (isset($activity['project_id'])) {
                            $this->db->select('name'); // Replace 'name' with actual column name if different
                            $this->db->from('tblrestoration_projects'); // Replace 'tblprojects' with actual table name if different
                            $this->db->where('id', $activity['project_id']); // Replace 'id' with actual column name if different
                            $query = $this->db->get();
                            
                            // Debugging: Log the query to check if it’s working
                            // Remove this after debugging
                            // echo '<pre>Query: ' . $this->db->last_query() . '</pre>';
                            // if ($query->num_rows() == 0) {
                            //     echo '<pre>No project found for project_id: ' . $activity['project_id'] . '</pre>';
                            // }

                            if ($query->num_rows() > 0) {
                                $project_name = e($query->row()->name);
                            }
                        }
                        ?>
                <div class="feed-item">
                    <div class="date"><span class="text-has-action" data-toggle="tooltip"
                            data-title="<?php echo e(_dt($activity['dateadded'])); ?>">
                            <?php echo e(time_ago($activity['dateadded'])); ?>
                        </span>
                    </div>
                    <div class="text">
                        <p class="bold no-mbot">
                            <?php if ($href != '') { ?>
                            <a href="<?php echo e($href); ?>"><?php echo $name; ?></a> -
                            <?php } else {
                                echo $name;
                            } ?>
                            <?php //echo _l($activity['description_key']); ?>
							<?php echo _l(trim($activity['description_key'] ?? '')); ?>
                        </p>
                        <?php echo _l('project_name'); ?>: <a
                            href="<?php echo admin_url('restoration/projects/project/' . $activity['project_id']); ?>">
                            <?php echo $project_name; ?>
                        </a>
                    </div>
                    <?php if (!empty($activity['additional_data'])) { ?>
                        <p class="text-muted mtop5"><?php echo $activity['additional_data']; ?></p>
                    <?php } ?>
                </div>
                <?php } ?>
                <?php if ($filtered_activities == 0) { ?>
                    <p>No restoration activities found.</p>
                <?php } ?>
            </div>
        </div>
    </div>
</div>