<?php defined('BASEPATH') or exit('No direct script access allowed'); ?>
<div class="widget" id="widget-<?php echo create_widget_id(); ?>" data-name="<?php echo _l('home_campaign_activity') ?: 'Campaign Activity'; ?>">
    <div class="panel_s campaigns-activity">
        <div class="panel-body padding-10">
            <div class="widget-dragger"></div>
            <p class="tw-font-semibold tw-flex tw-items-center tw-mb-0 tw-space-x-1.5 rtl:tw-space-x-reverse tw-p-1.5">
                <svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke-width="1.5"
                    stroke="currentColor" class="tw-w-6 tw-h-6 tw-text-neutral-500">
                    <path stroke-linecap="round" stroke-linejoin="round"
                        d="M8.25 6.75h12M8.25 12h12m-12 5.25h12M3.75 6.75h.007v.008H3.75V6.75zm.375 0a.375.375 0 11-.75 0 .375.375 0 01.75 0zM3.75 12h.007v.008H3.75V12zm.375 0a.375.375 0 11-.75 0 .375.375 0 01.75 0zm-.375 5.25h.007v.008H3.75v-.008zm.375 0a.375.375 0 11-.75 0 .375.375 0 01.75 0z" />
                </svg>
                <span class="tw-text-neutral-700">
                    <?php echo _l('home_campaign_activity') ?: 'Campaign Activity'; ?>
                </span>
            </p>
            <hr class="-tw-mx-3 tw-mt-3 tw-mb-6">
            <div class="activity-feed" style="max-height:842px; overflow-y:auto;">
                <?php
                    if (!$this->db) {
                        echo '<p style="color: red;">Error: Database connection failed.</p>';
                    } else {
                        $campaign_activity_log = [];
                        $query = $this->db->select('description, date, full_name, campaignid')
                                          ->from('tblcampaign_activity_log')
                                          ->order_by('date', 'DESC')
                                          ->get();
                        if ($query && $query->num_rows() > 0) {
                            $campaign_activity_log = $query->result_array();

                            // Filter duplicates in PHP
                            $unique_activities = [];
                            $seen = [];
                            foreach ($campaign_activity_log as $activity) {
                                $key = $activity['date'] . '|' . $activity['campaignid'] . '|' . $activity['description'];
                                if (!isset($seen[$key])) {
                                    $seen[$key] = true;
                                    $unique_activities[] = $activity;
                                }
                            }
                            $campaign_activity_log = $unique_activities;

                            // Fetch campaign names
                            foreach ($campaign_activity_log as &$activity) {
                                $activity['campaign_name'] = 'Unknown Campaign';
                                if (!empty($activity['campaignid'])) {
                                    $this->db->select('name');
                                    $this->db->from('tblcampaigns');
                                    $this->db->where('id', $activity['campaignid']);
                                    $campaign_query = $this->db->get();
                                    if ($campaign_query && $campaign_query->num_rows() > 0 && isset($campaign_query->row()->name)) {
                                        $activity['campaign_name'] = html_escape($campaign_query->row()->name);
                                    } else {
                                        log_message('error', 'No campaign name found for campaignid: ' . $activity['campaignid']);
                                    }
                                }
                            }
                        } else {
                            echo '<p style="color: red;">No activities found in tblcampaign_activity_log or query failed.</p>';
                        }

                        $filtered_activities = 0;
                        foreach ($campaign_activity_log as $activity) {
                            $filtered_activities++;
                            $name = html_escape($activity['full_name'] ?? '[SYSTEM]');
                            $campaign_name = html_escape($activity['campaign_name'] ?? 'Unknown Campaign');
                            $description = $activity['description'] ?? 'No description';

                            switch ($description) {
                                case 'not_campaign_activity_created':
                                    $description = 'Created campaign';
                                    break;
                                case 'not_campaign_activity_added':
                                    $description = 'Added campaign';
                                    break;
                                case 'not_campaign_activity_updated':
                                    $description = 'Updated campaign';
                                    break;
                                case 'not_campaign_activity_deleted':
                                    $description = 'Deleted campaign';
                                    break;
                                case 'not_campaign_activity_submitted':
                                    $description = 'Submitted campaign';
                                    break;
                                case 'not_campaign_activity_status_updated':
                                    $description = 'Updated campaign status';
                                    break;
                                case 'not_campaign_activity_marked_lost':
                                    $description = 'Marked campaign as lost';
                                    break;
                                case 'not_campaign_activity_unmarked_lost':
                                    $description = 'Unmarked campaign as lost';
                                    break;
                                case 'not_campaign_activity_marked_junk':
                                    $description = 'Marked campaign as junk';
                                    break;
                                case 'not_campaign_activity_unmarked_junk':
                                    $description = 'Unmarked campaign as junk';
                                    break;
                                case 'not_campaign_activity_added_attachment':
                                    $description = 'Added campaign attachment';
                                    break;
                                case 'not_campaign_activity_log_attachment':
                                    $description = 'Logged campaign attachment';
                                    break;
                                case 'not_campaign_activity_assigned_to':
                                    $description = 'Assigned campaign to staff';
                                    break;
                                case 'not_campaign_activity_assigned_from_form':
                                    $description = 'Assigned campaign from form';
                                    break;
                                default:
                                    $description = html_escape($description);
                            }
                ?>
                <div class="feed-item">
                    <div class="date"><span class="text-has-action" data-toggle="tooltip"
                            data-title="<?php echo html_escape(_dt($activity['date'])); ?>">
                            <?php echo html_escape(time_ago($activity['date'])); ?>
                        </span>
                    </div>
                    <div class="text">
                        <p class="bold no-mbot">
                            <?php echo $name; ?> - <?php echo html_escape($description); ?> (name: <?php echo $campaign_name; ?>)
                        </p>
                    </div>
                </div>
                <?php } ?>
                <?php if ($filtered_activities == 0) { ?>
                    <p>No campaign activities found.</p>
                <?php } ?>
                <?php } ?>
            </div>
        </div>
    </div>
</div>
