<?php defined('BASEPATH') or exit('No direct script access allowed'); ?>
<div class="widget" id="widget-<?php echo create_widget_id(); ?>" data-name="<?php echo _l('web_campaign_forms'); ?>">
    <?php if (is_admin()) { ?>
    <div class="row" id="web_campaign_forms">
        <div class="col-md-12">
            <div class="panel_s">
                <div class="panel-body padding-10">
                    <div class="widget-dragger"></div>
                    <div class="tw-flex tw-justify-between tw-items-center tw-p-1.5">
                        <p class="tw-font-semibold tw-flex tw-items-center tw-mb-0 tw-space-x-1.5 rtl:tw-space-x-reverse">
                            <i class="fa-solid fa-crosshairs tw-text-neutral-500"></i>
                            <span class="tw-text-neutral-700">
                                <?php echo _l('web_campaign_forms'); ?>
                            </span>
                        </p>
                    </div>
                    <hr class="-tw-mx-3 tw-mt-2 tw-mb-4">
                    <a href="<?php echo admin_url('campaigns'); ?>"
                       class="mbot20 inline-block full-width"><?php echo _l('home_widget_view_all'); ?></a>
                    <div id="web-campaigns-table" class="tw-p-2">
                        <div class="table-responsive">
                            <table class="table dt-table table-campaigns" data-order-col="4" data-order-type="desc">
                                <thead>
                                    <tr>
                                        <th class="th-campaign-no"><?php echo _l('#'); ?></th>
                                        <th class="th-campaign-name"><?php echo _l('Form Name'); ?></th>
                                        <th class="th-campaign-company"><?php echo _l('Total Submissions'); ?></th>
                                        <th class="th-campaign-email"><?php echo _l('Last Submission Time'); ?></th>
                                        <th class="th-campaign-phone"><?php echo _l('Created'); ?></th>
                                        <th class="th-campaign-created"><?php echo _l('Action'); ?></th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php
                                    $CI = &get_instance();
                                    $CI->load->database();
                                    $query = $CI->db->query("
                                        SELECT
                                            id AS 'tblweb_to_campaign.id',
                                            name AS 'tblweb_to_campaign.name',
                                            dateadded AS 'tblweb_to_campaign.dateadded',
                                            (SELECT COUNT(id) FROM " . db_prefix() . "campaigns WHERE " . db_prefix() . "campaigns.from_form_id = " . db_prefix() . "web_to_campaign.id) AS total_submissions,
                                            (SELECT MAX(dateadded) FROM " . db_prefix() . "campaigns WHERE " . db_prefix() . "campaigns.from_form_id = " . db_prefix() . "web_to_campaign.id) AS last_submission_time
                                        FROM " . db_prefix() . "web_to_campaign
                                        ORDER BY dateadded DESC
                                    ");
                                    $rows = $query->result_array();
                                    echo '<!-- Query: ' . $CI->db->last_query() . ' -->';
                                    echo '<!-- Query returned ' . count($rows) . ' rows -->';
                                    if (empty($rows)) {
                                        echo '<tr><td colspan="6">No forms found.</td></tr>';
                                    } else {
                                        foreach ($rows as $key => $form) {
                                            echo '<tr>';
                                           echo '<td>' . e($form['tblweb_to_campaign.id'] ?? '') . '</td>';
                                            echo '<td>' . e($form['tblweb_to_campaign.name'] ?? '') . '</td>';
                                            echo '<td>' . e($form['total_submissions'] ?? 0) . '</td>';
                                            echo '<td>' . (!empty($form['last_submission_time']) ? date('Y-m-d H:i:s', strtotime($form['last_submission_time'])) : '-') . '</td>';
                                            echo '<td>' . (!empty($form['tblweb_to_campaign.dateadded']) ? date('Y-m-d H:i:s', strtotime($form['tblweb_to_campaign.dateadded'])) : '-') . '</td>';
                                            echo '<td>';
                                            echo '<a class="btn btn-sm btn-primary" href="' . admin_url('campaigns?from_form_id=' . ($form['tblweb_to_campaign.id'] ?? '')) . '">';
                                            echo '<i class="fa fa-eye"></i> ' . _l('view');
                                            echo '</a>';
                                            echo '</td>';
                                            echo '</tr>';
                                        }
                                    }
                                    ?>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <?php } else { ?>
        <p>User is not an admin.</p>
    <?php } ?>
</div>
<script>
function update_campaigns_table(element) {
    var type = $(element).data('type');
    console.log('Updating table with type:', type);
    $('#web-campaigns-table-name').text($(element).text());
    $('input[name="display_mode"]').val(type);
    $.post(admin_url + 'campaigns/update_campaigns_table', {
        display_mode: type
    }).done(function(response) {
        console.log('Response:', response);
        $('#web-campaigns-table').html(response);
        if ($.fn.DataTable.isDataTable('.table-campaigns')) {
            $('.table-campaigns').DataTable().destroy();
        }
        $('.table-campaigns').DataTable({
            "order": [[4, 'desc']],
            "pageLength": -1
        });
    }).fail(function(xhr, status, error) {
        console.error('AJAX error:', error, xhr.responseText);
    });
}
</script>