<?php defined('BASEPATH') or exit('No direct script access allowed'); ?>
<div class="widget" id="widget-<?php echo create_widget_id(); ?>" data-name="<?php echo _l('team_group_forms'); ?>">
    <?php if (is_admin()) { ?>
    <div class="row" id="team_group_forms">
        <div class="col-md-12">
            <div class="panel_s">
                <div class="panel-body padding-10">
                    <div class="widget-dragger"></div>
                    <div class="tw-flex tw-justify-between tw-items-center tw-p-1.5">
                        <p class="tw-font-semibold tw-flex tw-items-center tw-mb-0 tw-space-x-1.5 rtl:tw-space-x-reverse">
                            <i class="fa fa-bar-chart fa-lg tw-text-neutral-500"></i>
                            <span class="tw-text-neutral-700">
                                <?php echo _l('home_kpi_form'); ?>
                            </span>
                        </p>
                        <div>
                            <!-- You can add filters or buttons here if needed -->
                        </div>
                    </div>
                    <hr class="-tw-mx-3 tw-mt-2 tw-mb-4">
                    <a href="<?php echo admin_url('team_group/report'); ?>"
                       class="mbot20 inline-block full-width"><?php echo _l('home_widget_view_all'); ?></a>
                    <div id="forms-report-table-wrapper" class="tw-p-2">
                        <table class="table dt-table table-web-to-team-group" data-order-col="0" data-order-type="desc">
                            <thead>
                                <tr>
                                    <th><?php echo _l('id'); ?></th>
                                    <th><?php echo _l('form_name'); ?></th>
                                    <th><?php echo _l('total_submissions'); ?></th>
                                    <th><?php echo _l('created_forms'); ?></th>
                                    <th><?php echo _l('Action'); ?></th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php
                                $CI = &get_instance();
                                $CI->load->database();
                                $query = $CI->db->query("
                                    SELECT
                                        id,
                                        name,
                                        (SELECT COUNT(id) FROM " . db_prefix() . "kpi_form_list
                                         WHERE " . db_prefix() . "kpi_form_list.form_id = " . db_prefix() . "kpi_team_report.id) AS total_submissions,
                                        (SELECT MAX(dateadded) FROM " . db_prefix() . "kpi_form_list
                                         WHERE " . db_prefix() . "kpi_form_list.form_id = " . db_prefix() . "kpi_team_report.id) AS last_submission_time,
                                        form_key
                                    FROM " . db_prefix() . "kpi_team_report
                                    ORDER BY id DESC
                                    LIMIT 10
                                ");
                                foreach ($query->result() as $row) {
                                    echo '<tr>';
                                    echo '<td>' . $row->id . '</td>';
                                    echo '<td>';
                                    echo '<a href="' . admin_url('team_group/form/' . $row->id) . '" class="tw-font-medium">' . e($row->name) . '</a>';
                                    echo '<div class="row-options">';
                                    echo '<a href="' . site_url('team_group/wtl/' . $row->form_key) . '" target="_blank">' . _l('view') . '</a>';
                                    echo ' | <a href="' . admin_url('team_group/form/' . $row->id) . '">' . _l('edit') . '</a>';
                                    echo ' | <a href="' . admin_url('team_group/delete_form/' . $row->id) . '" class="_delete">' . _l('delete') . '</a>';
                                    echo '</div>';
                                    echo '</td>';
                                    echo '<td>' . $row->total_submissions . '</td>';
                                    echo '<td><span class="text-has-action is-date" data-toggle="tooltip" data-title="' .
                                         ($row->last_submission_time ? e(_dt($row->last_submission_time)) : '-') . '">' .
                                         ($row->last_submission_time ? e(time_ago($row->last_submission_time)) : '-') . '</span></td>';
                                    echo '<td><a href="' . admin_url('team_group/view_form_data/' . $row->id) . '" class="btn btn-sm btn-default">' . _l('view_form_data') . '</a></td>';
                                    echo '</tr>';
                                }
                                ?>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <?php } ?>
</div>
<script>
function update_forms_report_table(element) {
    var type = $(element).data('type');
    $('#forms-report-mode-name').text($(element).text());
    $('input[name="display_mode"]').val(type);
    // Add AJAX call here to refresh table data based on the selected time period
    $.post(admin_url + 'team_group/update_forms_report', {
        display_mode: type
    }).done(function(response) {
        $('#forms-report-table-wrapper').html(response);
        initDataTable('.table-web-to-team-group', window.location.href, undefined, undefined, 'undefined', [0, 'desc']);
    });
}
</script>