<?php
defined('BASEPATH') or exit('No direct script access allowed');

// Define table columns to match campaigns.php
$table_data = [
    ['name' => _l('the_number_sign')], // Checkbox
    ['name' => _l('campaign_id')], // Campaign ID
    ['name' => _l('campaign_name')], // Campaign Name
];

// Add GDPR consent column if enabled
if (is_gdpr() && get_option('gdpr_enable_consent_for_campaigns') == '1') {
    $table_data[] = ['name' => _l('gdpr_consent')];
}

// Add remaining columns
$table_data = array_merge($table_data, [
    ['name' => _l('campaign_client'), 'th_attrs' => ['class' => isset($client_id) ? 'not_visible' : '']], // Company
    ['name' => _l('campaign_email')], // Email
    ['name' => _l('campaign_phonenumber')], // Phone Number
    ['name' => _l('campaign_add_edit_campaign_value')], // Campaign Value
    ['name' => _l('tags')], // Tags
    ['name' => _l('campaigns_dt_assigned')], // Assigned
    ['name' => _l('campaign_status')], // Status
    ['name' => _l('campaign_source')], // Source
    ['name' => _l('campaign_lastcontact')], // Last Contact
    ['name' => _l('campaign_dateadded')], // Date Added
]);

// Add custom fields for campaigns
$custom_fields = get_custom_fields('campaigns', ['show_on_table' => 1]);
foreach ($custom_fields as $field) {
    $table_data[] = [
        'name' => $field['name'],
        'th_attrs' => ['data-type' => $field['type'], 'data-custom-field' => 1],
    ];
}

// Apply hooks to allow column customization
$table_data = hooks()->apply_filters('campaigns_table_columns', $table_data);

// Render the DataTable
render_datatable(
    $table_data,
    isset($class) ? $class : 'campaigns',
    ['number-index-1'],
    [
        'data-last-order-identifier' => 'campaigns',
        'data-default-order' => get_table_last_order('campaigns'),
        'id' => $table_id ?? 'campaigns',
        'data-ajax-params' => json_encode(['client_id' => isset($client_id) ? $client_id : 0, '_where' => isset($_where) ? $_where : '']),
    ]
);
?>