<?php defined('BASEPATH') or exit('No direct script access allowed'); ?>
<div class="campaign-wrapper<?= $openEdit == true ? ' open-edit' : ''; ?>"
    <?= isset($campaign) && ($campaign->junk == 1 || $campaign->lost == 1) ? 'campaign-is-just-or-lost' : ''; ?>>

    <?php if (isset($campaign)) { ?>
    <div class="tw-flex tw-items-center tw-justify-end tw-space-x-1.5">

        <?php
                       $client                  = false;
        $convert_to_client_tooltip_email_exists = '';
        if (total_rows(db_prefix() . 'contacts', ['email' => $campaign->email]) > 0 && total_rows(db_prefix() . 'clients', ['campaignid' => $campaign->id]) == 0) {
            $convert_to_client_tooltip_email_exists = _l('campaign_email_already_exists');
            $text                                   = _l('campaign_convert_to_client');
        } elseif (total_rows(db_prefix() . 'clients', ['campaignid' => $campaign->id])) {
            $client = true;
        } else {
            $text = _l('campaign_convert_to_client');
        }
        ?>

        <?php if ($campaign_locked == false) { ?>
        <div
            class="campaign-edit<?= isset($campaign) ? ' hide' : ''; ?>">
            <button type="button" class="btn btn-primary campaign-top-btn campaign-save-btn"
                onclick="document.getElementById('campaign-form-submit').click();">
                <?= _l('submit'); ?>
            </button>
        </div>
        <?php } ?>
        <?php if ($client && (staff_can('view', 'customers') || is_customer_admin(get_client_id_by_campaign_id($campaign->id)))) { ?>
        <a data-toggle="tooltip" class="btn btn-primary campaign-top-btn campaign-view" data-placement="top"
            title="<?= _l('campaign_converted_edit_client_profile'); ?>"
            href="<?= admin_url('clients/client/' . get_client_id_by_campaign_id($campaign->id)); ?>">
            <i class="fa-regular fa-user"></i>
        </a>
        <?php } ?>
        <?php if (total_rows(db_prefix() . 'clients', ['campaignid' => $campaign->id]) == 0) { ?>
        <a href="#" data-toggle="tooltip"
            data-title="<?= e($convert_to_client_tooltip_email_exists); ?>"
            class="btn btn-primary campaign-convert-to-customer campaign-top-btn campaign-view"
            onclick="convert_campaign_to_customer(<?= e($campaign->id); ?>); return false;">
            <i class="fa-regular fa-user"></i>
            <?= e($text); ?>
        </a>
        <?php } ?>

        <div
            class="<?= $campaign_locked == true ? ' hide' : ''; ?>">
            <a href="#" campaign-edit data-toggle="tooltip"
                data-title="<?= _l('edit'); ?>"
                class="btn btn-default campaign-top-btn !tw-px-3">

                <i class="fa-regular fa-pen-to-square"></i>
            </a>
        </div>

        <div class="btn-group" id="campaign-more-btn">
            <a href="#" class="btn btn-default dropdown-toggle campaign-top-btn" data-toggle="dropdown" aria-haspopup="true"
                aria-expanded="false">
                <?= _l('more'); ?>
                <span class="caret"></span>
            </a>
            <ul class="dropdown-menu dropdown-menu-right" id="campaign-more-dropdown">
                <?php if ($campaign->junk == 0) {
                    if ($campaign->lost == 0 && (total_rows(db_prefix() . 'clients', ['campaignid' => $campaign->id]) == 0)) { ?>
                <li>
                    <a href="#"
                        onclick="campaign_mark_as_lost(<?= e($campaign->id); ?>); return false;">
                        <i class="fa fa-mars"></i>
                        <?= _l('campaign_mark_as_lost'); ?>
                    </a>
                </li>
                <?php } elseif ($campaign->lost == 1) { ?>
                <li>
                    <a href="#"
                        onclick="campaign_unmark_as_lost(<?= e($campaign->id); ?>); return false;">
                        <i class="fa fa-smile-o"></i>
                        <?= _l('campaign_unmark_as_lost'); ?>
                    </a>
                </li>
                <?php } ?>
                <?php
                } ?>
                <!-- mark as junk -->
                <?php if ($campaign->lost == 0) {
                    if ($campaign->junk == 0 && (total_rows(db_prefix() . 'clients', ['campaignid' => $campaign->id]) == 0)) { ?>
                <li>
                    <a href="#"
                        onclick="campaign_mark_as_junk(<?= e($campaign->id); ?>); return false;">
                        <i class="fa fa fa-times"></i>
                        <?= _l('campaign_mark_as_junk'); ?>
                    </a>
                </li>
                <?php } elseif ($campaign->junk == 1) { ?>
                <li>
                    <a href="#"
                        onclick="campaign_unmark_as_junk(<?= e($campaign->id); ?>); return false;">
                        <i class="fa fa-smile-o"></i>
                        <?= _l('campaign_unmark_as_junk'); ?>
                    </a>
                </li>
                <?php } ?>
                <?php } ?>
                <?php if ((staff_can('delete', 'campaigns') && $campaign_locked == false) || is_admin()) { ?>
                <li>
                    <a href="<?= admin_url('campaigns/delete/' . $campaign->id); ?>"
                        class="text-danger delete-text _delete" data-toggle="tooltip" title="">
                        <i class="fa-regular fa-trash-can"></i>
                        <?= _l('campaign_edit_delete_tooltip'); ?>
                    </a>
                </li>
                <?php } ?>
            </ul>
        </div>
    </div>
    <?php } ?>

    <div class="clearfix no-margin"></div>

    <?php if (isset($campaign)) { ?>

    <div class="row mbot15" style="margin-top:12px;">
        <hr class="no-margin" />
    </div>

    <div class="alert alert-warning hide mtop20" role="alert" id="campaign_proposal_warning">
        <?= _l('proposal_warning_email_change', [_l('campaign_lowercase'), _l('campaign_lowercase'), _l('campaign_lowercase')]); ?>
        <hr />
        <a href="#"
            onclick="update_all_proposal_emails_linked_to_campaign(<?= e($campaign->id); ?>); return false;"
            class="alert-link">
            <?= _l('update_proposal_email_yes'); ?>
        </a>
        <br />
        <a href="#"
            onclick="init_campaign_modal_data(<?= e($campaign->id); ?>); return false;"
            class="alert-link">
            <?= _l('update_proposal_email_no'); ?>
        </a>
    </div>
    <?php } ?>
    <?= form_open((isset($campaign) ? admin_url('campaigns/campaign/' . $campaign->id) : admin_url('campaigns/campaign')), ['id' => 'campaign_form']); ?>
    <div class="row">
        <div class="campaign-view<?= ! isset($campaign) ? ' hide' : ''; ?>"
            id="campaignViewWrapper">
            <div class="col-md-4 col-xs-12 campaign-information-col">
                <div class="campaign-info-heading">
                    <h4>
                        <?= _l('campaign_info'); ?>
                    </h4>
                </div>
                <dl>
                    <dt class="campaign-field-heading tw-font-normal tw-text-neutral-500">
                        <?= _l('campaign_add_edit_name'); ?>
                    </dt>
                    <dd class="tw-text-neutral-900 tw-mt-1 campaign-name">
                        <?= isset($campaign) && $campaign->name != '' ? e($campaign->name) : '-' ?>
                    </dd>
                    <dt class="campaign-field-heading tw-font-normal tw-text-neutral-500">
                        <?= _l('campaign_title'); ?>
                    </dt>
                    <dd class="tw-text-neutral-900 tw-mt-1">
                        <?= isset($campaign) && $campaign->title != '' ? e($campaign->title) : '-' ?>
                    </dd>
                    <dt class="campaign-field-heading tw-font-normal tw-text-neutral-500">
                        <?= _l('campaign_add_edit_email'); ?>
                    </dt>
                    <dd class="tw-text-neutral-900 tw-mt-1">
                        <?= isset($campaign) && $campaign->email != '' ? '<a href="mailto:' . e($campaign->email) . '">' . e($campaign->email) . '</a>' : '-' ?>
                    </dd>
                    <dt class="campaign-field-heading tw-font-normal tw-text-neutral-500">
                        <?= _l('campaign_website'); ?>
                    </dt>
                    <dd class="tw-text-neutral-900 tw-mt-1">
                        <?= isset($campaign) && $campaign->website != '' ? '<a href="' . e(maybe_add_http($campaign->website)) . '" target="_blank">' . e($campaign->website) . '</a>' : '-' ?>
                    </dd>
                    <dt class="campaign-field-heading tw-font-normal tw-text-neutral-500">
                        <?= _l('campaign_add_edit_phonenumber'); ?>
                    </dt>
                    <dd class="tw-text-neutral-900 tw-mt-1">
                        <?= isset($campaign) && $campaign->phonenumber != '' ? '<a href="tel:' . e($campaign->phonenumber) . '">' . e($campaign->phonenumber) . '</a>' : '-' ?>
                    </dd>
                    <dt class="campaign-field-heading tw-font-normal tw-text-neutral-500">
                        <?= _l('campaign_value'); ?>
                    </dt>
                    <dd class="tw-text-neutral-900 tw-mt-1">
                        <?= isset($campaign) && $campaign->campaign_value != 0 ? e(app_format_money($campaign->campaign_value, $base_currency->id)) : '-' ?>
                    </dd>
                    <dt class="campaign-field-heading tw-font-normal tw-text-neutral-500">
                        <?= _l('campaign_company'); ?>
                    </dt>
                    <dd class="tw-text-neutral-900 tw-mt-1">
                        <?= isset($campaign) && $campaign->company != '' ? e($campaign->company) : '-' ?>
                    </dd>
                    <dt class="campaign-field-heading tw-font-normal tw-text-neutral-500">
                        <?= _l('campaign_address'); ?>
                    </dt>
                    <dd class="tw-text-neutral-900 tw-mt-1">
                        <?= isset($campaign) && $campaign->address != '' ? process_text_content_for_display($campaign->address) : '-' ?>
                    </dd>
                    <dt class="campaign-field-heading tw-font-normal tw-text-neutral-500">
                        <?= _l('campaign_city'); ?>
                    </dt>
                    <dd class="tw-text-neutral-900 tw-mt-1">
                        <?= isset($campaign) && $campaign->city != '' ? e($campaign->city) : '-' ?>
                    </dd>
                    <dt class="campaign-field-heading tw-font-normal tw-text-neutral-500">
                        <?= _l('campaign_state'); ?>
                    </dt>
                    <dd class="tw-text-neutral-900 tw-mt-1">
                        <?= isset($campaign) && $campaign->state != '' ? e($campaign->state) : '-' ?>
                    </dd>
                    <dt class="campaign-field-heading tw-font-normal tw-text-neutral-500">
                        <?= _l('campaign_country'); ?>
                    </dt>
                    <dd class="tw-text-neutral-900 tw-mt-1">
                        <?= isset($campaign) && $campaign->country != 0 ? e(get_country($campaign->country)->short_name) : '-' ?>
                    </dd>
                    <dt class="campaign-field-heading tw-font-normal tw-text-neutral-500">
                        <?= _l('campaign_zip'); ?>
                    </dt>
                    <dd class="tw-text-neutral-900 tw-mt-1">
                        <?= isset($campaign) && $campaign->zip != '' ? e($campaign->zip) : '-' ?>
                    </dd>
                </dl>
            </div>
            <div class="col-md-4 col-xs-12 campaign-information-col">
                <div class="campaign-info-heading">
                    <h4>
                        <?= _l('campaign_general_info'); ?>
                    </h4>
                </div>
                <dl>
                    <dt class="campaign-field-heading tw-font-normal tw-text-neutral-500 no-mtop">
                        <?= _l('campaign_add_edit_status'); ?>
                    </dt>
                    <dd class="tw-text-neutral-900 tw-mt-2 mbot15">
                        <?php if (isset($campaign)) {
                            echo $campaign->status_name != '' ? ('<span class="campaign-status-' . e($campaign->status) . ' label' . (empty($campaign->color) ? ' label-default' : '') . '" style="color:' . e($campaign->color) . ';border:1px solid ' . adjust_hex_brightness($campaign->color, 0.4) . ';background: ' . adjust_hex_brightness($campaign->color, 0.04) . ';">' . e($campaign->status_name) . '</span>') : '-';
                        } else {
                            echo '-';
                        } ?>
                    </dd>
                    <dt class="campaign-field-heading tw-font-normal tw-text-neutral-500">
                        <?= _l('campaign_add_edit_source'); ?>
                    </dt>
                    <dd class="tw-text-neutral-900 tw-mt-1 mbot15">
                        <?= isset($campaign) && $campaign->source_name != '' ? e($campaign->source_name) : '-' ?>
                    </dd>
                    <?php if (! is_language_disabled()) { ?>
                    <dt class="campaign-field-heading tw-font-normal tw-text-neutral-500">
                        <?= _l('localization_default_language'); ?>
                    </dt>
                    <dd class="tw-text-neutral-900 tw-mt-1 mbot15">
                        <?= isset($campaign) && $campaign->default_language != '' ? e(ucfirst($campaign->default_language)) : _l('system_default_string') ?>
                    </dd>
                    <?php } ?>
                    <dt class="campaign-field-heading tw-font-normal tw-text-neutral-500">
                        <?= _l('campaign_add_edit_assigned'); ?>
                    </dt>
                    <dd class="tw-text-neutral-900 tw-mt-1 mbot15">
                        <?= isset($campaign) && $campaign->assigned != 0 ? e(get_staff_full_name($campaign->assigned)) : '-' ?>
                    </dd>
                    <dt class="campaign-field-heading tw-font-normal tw-text-neutral-500">
                        <?= _l('tags'); ?>
                    </dt>
                    <dd class="tw-text-neutral-900 tw-mt-1 mbot10">
                        <?php if (isset($campaign)) {
                            $tags = get_tags_in($campaign->id, 'campaign');
                            if (count($tags) > 0) {
                                echo render_tags($tags);
                                echo '<div class="clearfix"></div>';
                            } else {
                                echo '-';
                            }
                        } ?>
                    </dd>
                    <dt class="campaign-field-heading tw-font-normal tw-text-neutral-500">
                        <?= _l('campaigns_dt_datecreated'); ?>
                    </dt>
                    <dd class="tw-text-neutral-900 tw-mt-1">
                        <?= isset($campaign) && $campaign->dateadded != '' ? '<span class="text-has-action" data-toggle="tooltip" data-title="' . e(_dt($campaign->dateadded)) . '">' . e(time_ago($campaign->dateadded)) . '</span>' : '-' ?>
                    </dd>
                    <dt class="campaign-field-heading tw-font-normal tw-text-neutral-500">
                        <?= _l('campaigns_dt_last_contact'); ?>
                    </dt>
                    <dd class="tw-text-neutral-900 tw-mt-1">
                        <?= isset($campaign) && $campaign->lastcontact != '' ? '<span class="text-has-action" data-toggle="tooltip" data-title="' . e(_dt($campaign->lastcontact)) . '">' . e(time_ago($campaign->lastcontact)) . '</span>' : '-' ?>
                    </dd>
                    <dt class="campaign-field-heading tw-font-normal tw-text-neutral-500">
                        <?= _l('campaign_public'); ?>
                    </dt>
                    <dd class="tw-text-neutral-900 tw-mt-1 mbot15">
                        <?php if (isset($campaign)) {
                            if ($campaign->is_public == 1) {
                                echo _l('campaign_is_public_yes');
                            } else {
                                echo _l('campaign_is_public_no');
                            }
                        } else {
                            echo '-';
                        } ?>
                    </dd>
                    <?php if (isset($campaign) && $campaign->from_form_id != 0) { ?>
                    <dt class="campaign-field-heading tw-font-normal tw-text-neutral-500">
                        <?= _l('web_to_campaign_form'); ?>
                    </dt>
                    <dd class="tw-text-neutral-900 tw-mt-1 mbot15">
                        <?= e($campaign->form_data->name); ?>
                    </dd>
                    <?php } ?>
                </dl>
            </div>
            <div class="col-md-4 col-xs-12 campaign-information-col">
                <?php if (total_rows(db_prefix() . 'customfields', ['fieldto' => 'campaigns', 'active' => 1]) > 0 && isset($campaign)) { ?>
                <div class="campaign-info-heading">
                    <h4>
                        <?= _l('custom_fields'); ?>
                    </h4>
                </div>
                <dl>
                    <?php foreach (get_custom_fields('campaigns') as $field) { ?>
                    <?php $value = get_custom_field_value($campaign->id, $field['id'], 'campaigns'); ?>
                    <dt class="campaign-field-heading tw-font-normal tw-text-neutral-500 no-mtop">
                        <?= e($field['name']); ?>
                    </dt>
                    <dd class="tw-text-neutral-900 tw-mt-1 tw-break-words">
                        <?= $value != '' ? $value : '-' ?>
                    </dd>
                    <?php } ?>
                    <?php } ?>
                </dl>
            </div>
            <div class="clearfix"></div>
            <div class="col-md-12">
                <dl>
                    <dt class="campaign-field-heading tw-font-normal tw-text-neutral-500">
                        <?= _l('campaign_description'); ?>
                    </dt>
                    <dd class="tw-text-neutral-900 tw-mt-1">
                        <?= process_text_content_for_display((isset($campaign) && $campaign->description != '' ? $campaign->description : '-')); ?>
                    </dd>
                </dl>
            </div>
        </div>
        <div class="clearfix"></div>
        <div
            class="campaign-edit<?= isset($campaign) ? ' hide' : ''; ?>">
            <div class="col-md-4">
                <?php
        $selected = '';
if (isset($campaign)) {
    $selected = $campaign->status;
} elseif (isset($status_id)) {
    $selected = $status_id;
}
echo render_campaigns_status_select($statuses, $selected, 'campaign_add_edit_status');
?>
            </div>
            <div class="col-md-4">
                <?= render_campaigns_source_select($sources, (isset($campaign) ? $campaign->source : get_option('campaigns_default_source')), 'campaign_add_edit_source'); ?>
            </div>
            <div class="col-md-4">
                <?php
               $assigned_attrs = [];
$selected                      = (isset($campaign) ? $campaign->assigned : get_staff_user_id());
if (isset($campaign)
   && $campaign->assigned == get_staff_user_id()
   && $campaign->addedfrom != get_staff_user_id()
   && ! is_admin($campaign->assigned)
   && staff_cant('view', 'campaigns')
) {
    $assigned_attrs['disabled'] = true;
}
echo render_select('assigned', $members, ['staffid', ['firstname', 'lastname']], 'campaign_add_edit_assigned', $selected, $assigned_attrs); ?>
            </div>
            <div class="clearfix"></div>
            <hr class="mtop5 mbot10" />
            <div class="col-md-12">
                <div class="form-group no-mbot" id="inputTagsWrapper">
                    <label for="tags" class="control-label"><i class="fa fa-tag" aria-hidden="true"></i>
                        <?= _l('tags'); ?></label>
                    <input type="text" class="tagsinput" id="tags" name="tags"
                        value="<?= isset($campaign) ? prep_tags_input(get_tags_in($campaign->id, 'campaign')) : ''; ?>"
                        data-role="tagsinput">
                </div>
            </div>
            <div class="clearfix"></div>
            <hr class="no-mtop mbot15" />
            <div class="col-md-6">
                <?php $value = (isset($campaign) ? $campaign->name : ''); ?>
                <?= render_input('name', 'campaign_add_edit_name', $value); ?>
                <?php $value = (isset($campaign) ? $campaign->title : ''); ?>
                <?= render_input('title', 'campaign_title', $value); ?>
                <?php $value = (isset($campaign) ? $campaign->email : ''); ?>
                <?= render_input('email', 'campaign_add_edit_email', $value); ?>
                <?php if ((isset($campaign) && empty($campaign->website)) || ! isset($campaign)) {
                    $value = (isset($campaign) ? $campaign->website : '');
                    echo render_input('website', 'campaign_website', $value);
                } else { ?>
                <div class="form-group">
                    <label
                        for="website"><?= _l('campaign_website'); ?></label>
                    <div class="input-group">
                        <input type="text" name="website" id="website"
                            value="<?= e($campaign->website); ?>"
                            class="form-control">
                        <div class="input-group-addon">
                            <span>
                                <a href="<?= e(maybe_add_http($campaign->website)); ?>"
                                    target="_blank" tabindex="-1">
                                    <i class="fa fa-globe"></i>
                                </a>
                            </span>
                        </div>
                    </div>
                </div>
                <?php }
                $value = (isset($campaign) ? $campaign->phonenumber : ''); ?>
                <?= render_input('phonenumber', 'campaign_add_edit_phonenumber', $value); ?>
                <div class="form-group">
                    <label
                        for="campaign_value"><?= _l('campaign_value'); ?></label>
                    <div class="input-group" data-toggle="tooltip"
                        title="<?= _l('campaign_value_tooltip'); ?>">
                        <input type="number" class="form-control" name="campaign_value" value="<?php if (isset($campaign)) {
                            echo $campaign->campaign_value;
                        }?>">
                        <div class="input-group-addon">
                            <?= e($base_currency->symbol); ?>
                        </div>
                    </div>
                    </label>
                </div>
                <?php $value = (isset($campaign) ? $campaign->company : ''); ?>
                <?= render_input('company', 'campaign_company', $value); ?>
            </div>
            <div class="col-md-6">
                <?php $value = (isset($campaign) ? $campaign->address : ''); ?>
                <?= render_textarea('address', 'campaign_address', $value, ['rows' => 1, 'style' => 'height:36px;font-size:100%;']); ?>
                <?php $value = (isset($campaign) ? $campaign->city : ''); ?>
                <?= render_input('city', 'campaign_city', $value); ?>
                <?php $value = (isset($campaign) ? $campaign->state : ''); ?>
                <?= render_input('state', 'campaign_state', $value); ?>
                <?php
                           $countries = get_all_countries();
$customer_default_country             = get_option('customer_default_country');
$selected                             = (isset($campaign) ? $campaign->country : $customer_default_country);
echo render_select('country', $countries, ['country_id', ['short_name']], 'campaign_country', $selected, ['data-none-selected-text' => _l('dropdown_non_selected_tex')]);
?>
                <?php $value = (isset($campaign) ? $campaign->zip : ''); ?>
                <?= render_input('zip', 'campaign_zip', $value); ?>
                <?php if (! is_language_disabled()) { ?>
                <div class="form-group">
                    <label for="default_language"
                        class="control-label"><?= _l('localization_default_language'); ?></label>
                    <select name="default_language" data-live-search="true" id="default_language"
                        class="form-control selectpicker"
                        data-none-selected-text="<?= _l('dropdown_non_selected_tex'); ?>">
                        <option value="">
                            <?= _l('system_default_string'); ?>
                        </option>
                        <?php foreach ($this->app->get_available_languages() as $availableLanguage) {
                            $selected = '';
                            if (isset($campaign)) {
                                if ($campaign->default_language == $availableLanguage) {
                                    $selected = 'selected';
                                }
                            } ?>
                        <option value="<?= e($availableLanguage); ?>"
                            <?= e($selected); ?>>
                            <?= e(ucfirst($availableLanguage)); ?>
                        </option>
                        <?php
                        } ?>
                    </select>
                </div>
                <?php } ?>
            </div>
            <div class="col-md-12">
                <?php $value = (isset($campaign) ? $campaign->description : ''); ?>
                <?= render_textarea('description', 'campaign_description', $value); ?>
                <div class="row">
                    <div class="col-md-12">
                        <?php if (! isset($campaign)) { ?>
                        <div class="campaign-select-date-contacted hide">
                            <?= render_datetime_input('custom_contact_date', 'campaign_add_edit_datecontacted', '', ['data-date-end-date' => date('Y-m-d')]); ?>
                        </div>
                        <?php } else { ?>
                        <?= render_datetime_input('lastcontact', 'campaigns_dt_last_contact', _dt($campaign->lastcontact), ['data-date-end-date' => date('Y-m-d')]); ?>
                        <?php } ?>
                        <div
                            class="checkbox-inline checkbox<?= isset($campaign) ? ' hide' : ''; ?><?= isset($campaign) && (is_campaign_creator($campaign->id) || staff_can('edit', 'campaigns')) ? ' campaign-edit' : ''; ?>">
                            <input type="checkbox" name="is_public"
                                <?= isset($campaign) ? 'checked' : ''; ?>
                            id="campaign_public">
                            <label for="campaign_public">
                                <?= _l('campaign_public'); ?>
                            </label>
                        </div>
                        <?php if (! isset($campaign)) { ?>
                        <div class="checkbox-inline checkbox checkbox-primary">
                            <input type="checkbox" name="contacted_today" id="contacted_today" checked>
                            <label for="contacted_today">
                                <?= _l('campaign_add_edit_contacted_today'); ?>
                            </label>
                        </div>
                        <?php } ?>
                    </div>
                </div>
            </div>
            <div class="col-md-12 mtop15">
                <?php $rel_id = (isset($campaign) ? $campaign->id : false); ?>
                <?= render_custom_fields('campaigns', $rel_id); ?>
            </div>
            <div class="clearfix"></div>
        </div>
    </div>
    <?php if (isset($campaign)) { ?>
    <div class="campaign-latest-activity tw-mb-3 campaign-view">
        <div class="campaign-info-heading">
            <h4><?= _l('campaign_latest_activity'); ?>
            </h4>
        </div>
        <div id="campaign-latest-activity" class="pleft5"></div>
    </div>
    <?php } ?>
    <?php if ($campaign_locked == false) { ?>
    <div
        class="campaign-edit<?= isset($campaign) ? ' hide' : ''; ?>">
        <hr class="-tw-mx-5 tw-border-neutral-200" />
        <button type="submit" class="btn btn-primary pull-right campaign-save-btn" id="campaign-form-submit">
            <?= _l('submit'); ?>
        </button>
        <button type=" button" class="btn btn-default pull-right mright5" data-dismiss="modal">
            <?= _l('close'); ?>
        </button>
    </div>
    <?php } ?>
    <div class="clearfix"></div>
    <?= form_close(); ?>
</div>
<?php if (isset($campaign) && $campaign_locked == true) { ?>
<script>
    $(function() {
        // Set all fields to disabled if campaign is locked
        $.each($('.campaign-wrapper').find('input, select, textarea'), function() {
            $(this).attr('disabled', true);
            if ($(this).is('select')) {
                $(this).selectpicker('refresh');
            }
        });
    });
</script>
<?php } ?>