<?php defined('BASEPATH') or exit('No direct script access allowed'); ?>
<?php init_head(); ?>
<div id="wrapper">
    <div class="content">
        <div class="row">
            <div class="col-md-12">
                <div class="_buttons tw-mb-2 sm:tw-mb-4">
                    <a href="#" onclick="init_campaign(); return false;"
                        class="btn btn-primary mright5 pull-left display-block">
                        <i class="fa-regular fa-plus tw-mr-1"></i>
                        <?php echo _l('new_campaign'); ?>
                    </a>
                    <?php if (is_admin() || get_option('allow_non_admin_members_to_import_campaigns') == '1') { ?>
                    <a href="<?php echo admin_url('campaigns/import'); ?>"
                        class="btn btn-primary pull-left display-block hidden-xs">
                        <i class="fa-solid fa-upload tw-mr-1"></i>
                        <?php echo _l('import_campaigns'); ?>
                    </a>
                    <?php } ?>
                    <div class="row">
                        <div class="col-sm-5 ">
                            <a href="#" class="btn btn-default btn-with-tooltip" data-toggle="tooltip"
                                data-title="<?php echo _l('campaigns_summary'); ?>" data-placement="top"
                                onclick="slideToggle('.campaigns-overview'); return false;"><i
                                    class="fa fa-bar-chart"></i></a>
                            <a href="<?php echo admin_url('campaigns/switch_kanban/' . $switch_kanban); ?>"
                                class="btn btn-default mleft5 hidden-xs" data-toggle="tooltip" data-placement="top"
                                data-title="<?php echo $switch_kanban == 1 ? _l('campaigns_switch_to_kanban') : _l('switch_to_list_view'); ?>">
                                <?php if ($switch_kanban == 1) { ?>
                                <i class="fa-solid fa-grip-vertical"></i>
                                <?php } else { ?>
                                <i class="fa-solid fa-table-list"></i>
                                <?php }; ?>
                            </a>
                        </div>
                        <div class="col-sm-4 col-xs-12 pull-right campaigns-search">
                            <?php if ($this->session->userdata('campaigns_kanban_view') == 'true') { ?>
                            <div data-toggle="tooltip" data-placement="top"
                                data-title="<?php echo _l('search_by_tags'); ?>">
                                <?php echo render_input('search', '', '', 'search', ['data-name' => 'search', 'onkeyup' => 'campaigns_kanban();', 'placeholder' => _l('campaigns_search')], [], 'no-margin') ?>
                            </div>
                            <?php } else { ?>
							
                            <div id="vueApp" class="tw-inline pull-right">
								<div class="tw-flex tw-items-center tw-space-x-1 tw-mr-2">
									<a href="#" class="btn btn-default campaigns-table-order-btn" data-toggle="modal" data-target="#campaigns-table-order-modal" title="<?php echo _l('campaigns_table_order_configure'); ?>">
										<i class="fa fa-columns tw-mr-1"></i> <?php echo _l('campaigns_table_order_configure'); ?>
									</a>
								</div>
                                <app-filters
                                    id="<?php echo $table->id(); ?>"
                                    view="<?php echo $table->viewName(); ?>"
                                    :rules="<?php echo app\services\utilities\Js::from($this->input->get('status') ? $table->findRule('status')->setValue([$this->input->get('status')]) : []); ?>"
                                    :saved-filters="<?php echo $table->filtersJs(); ?>"
                                    :available-rules="<?php echo $table->rulesJs(); ?>">
                                </app-filters>
								
					  <!-- Toggle Button -->
    <button class="btn btn-secondary mb-3" id="toggle-table-btn" onclick="toggleCampaignTables()">
    <?php echo _l('Switch to Campaign Forms'); ?>
</button>
                            </div>
                            <?php } ?>
                            <?php echo form_hidden('sort_type'); ?>
                            <?php echo form_hidden('sort', (get_option('default_campaigns_kanban_sort') != '' ? get_option('default_campaigns_kanban_sort_type') : '')); ?>
                        </div>
                    </div>
                    <div class="clearfix"></div>
                    <div class="hide campaigns-overview tw-mt-2 sm:tw-mt-4 tw-mb-4 sm:tw-mb-0">
                        <h4 class="tw-mt-0 tw-font-semibold tw-text-lg">
                            <?php echo _l('campaigns_summary'); ?>
                        </h4>
                        <div class="tw-flex tw-flex-wrap tw-flex-col lg:tw-flex-row tw-w-full tw-gap-3 lg:tw-gap-6">
                            <?php
                           foreach ($summary as $status) { ?>
                            <div
                                class="lg:tw-border-r lg:tw-border-solid lg:tw-border-neutral-300 tw-flex-1 tw-flex tw-items-center last:tw-border-r-0">
                                <span class="tw-font-semibold tw-mr-3 rtl:tw-ml-3 tw-text-lg">
                                    <?php
                                          if (isset($status['percent'])) {
                                              echo '<span data-toggle="tooltip" data-title="' . $status['total'] . '">' . $status['percent'] . '%</span>';
                                          } else {
                                              // Is regular status
                                              echo $status['total'];
                                          }
                                       ?>
                                </span>
                                <span style="color:<?php echo e($status['color']); ?>"
                                    class="<?php echo isset($status['junk']) || isset($status['lost']) ? 'text-danger' : ''; ?>">
                                    <?php echo e($status['name']); ?>
                                </span>
                            </div>
                            <?php } ?>
                        </div>

                    </div>
                </div>
                <div class="<?php echo $isKanBan ? '' : 'panel_s' ; ?>">
                    <div class="<?php echo $isKanBan ? '' : 'panel-body' ; ?>">
                        <div class="tab-content">
                            <?php
                        if ($isKanBan) { ?>
                            <div class="active kan-ban-tab" id="kan-ban-tab" style="overflow:auto;">
                                <div class="kanban-campaigns-sort">
                                    <span class="bold"><?php echo _l('campaigns_sort_by'); ?>: </span>
                                    <a href="#" onclick="campaigns_kanban_sort('dateadded'); return false"
                                        class="dateadded">
                                        <?php if (get_option('default_campaigns_kanban_sort') == 'dateadded') {
                            echo '<i class="kanban-sort-icon fa fa-sort-amount-' . strtolower(get_option('default_campaigns_kanban_sort_type')) . '"></i> ';
                        } ?><?php echo _l('campaigns_sort_by_datecreated'); ?>
                                    </a>
                                    |
                                    <a href="#" onclick="campaigns_kanban_sort('campaignorder');return false;"
                                        class="campaignorder">
                                        <?php if (get_option('default_campaigns_kanban_sort') == 'campaignorder') {
                            echo '<i class="kanban-sort-icon fa fa-sort-amount-' . strtolower(get_option('default_campaigns_kanban_sort_type')) . '"></i> ';
                        } ?><?php echo _l('campaigns_sort_by_kanban_order'); ?>
                                    </a>
                                    |
                                    <a href="#" onclick="campaigns_kanban_sort('lastcontact');return false;"
                                        class="lastcontact">
                                        <?php if (get_option('default_campaigns_kanban_sort') == 'lastcontact') {
                            echo '<i class="kanban-sort-icon fa fa-sort-amount-' . strtolower(get_option('default_campaigns_kanban_sort_type')) . '"></i> ';
                        } ?><?php echo _l('campaigns_sort_by_lastcontact'); ?>
                                    </a>
                                </div>
                                <div class="row">
                                    <div class="container-fluid campaigns-kan-ban">
                                        <div id="kan-ban"></div>
                                    </div>
                                </div>
                            </div>
                            <?php } else { ?>
                            <div class="row" id="campaigns-table">
                                <div class="col-md-12">
                                    <a href="#" data-toggle="modal" data-table=".table-campaigns"
                                        data-target="#campaigns_bulk_actions"
                                        class="hide bulk-actions-btn table-btn"><?php echo _l('bulk_actions'); ?></a>
                                    <div class="modal fade bulk_actions" id="campaigns_bulk_actions" tabindex="-1"
                                        role="dialog">
                                        <div class="modal-dialog" role="document">
                                            <div class="modal-content">
                                                <div class="modal-header">
                                                    <button type="button" class="close" data-dismiss="modal"
                                                        aria-label="Close"><span
                                                            aria-hidden="true">&times;</span></button>
                                                    <h4 class="modal-title"><?php echo _l('bulk_actions'); ?></h4>
                                                </div>
                                                <div class="modal-body">
                                                    <?php if (staff_can('delete',  'campaigns')) { ?>
                                                    <div class="checkbox checkbox-danger">
                                                        <input type="checkbox" name="mass_delete" id="mass_delete">
                                                        <label
                                                            for="mass_delete"><?php echo _l('mass_delete'); ?></label>
                                                    </div>
                                                    <hr class="mass_delete_separator" />
                                                    <?php } ?>
                                                    <div id="bulk_change">
                                                        <div class="form-group">
                                                            <div class="checkbox checkbox-primary checkbox-inline">
                                                                <input type="checkbox" name="campaigns_bulk_mark_lost"
                                                                    id="campaigns_bulk_mark_lost" value="1">
                                                                <label for="campaigns_bulk_mark_lost">
                                                                    <?php echo _l('campaign_mark_as_lost'); ?>
                                                                </label>
                                                            </div>
                                                        </div>
                                                        <?php echo render_select('move_to_status_campaigns_bulk', $statuses, ['id', 'name'], 'ticket_single_change_status'); ?>
                                                        <?php
                                             echo render_select('move_to_source_campaigns_bulk', $sources, ['id', 'name'], 'campaign_source');
                                             echo render_datetime_input('campaigns_bulk_last_contact', 'campaigns_dt_last_contact');
                                             echo render_select('assign_to_campaigns_bulk', $staff, ['staffid', ['firstname', 'lastname']], 'campaigns_dt_assigned');
                                             ?>
                                                        <div class="form-group">
                                                            <?php echo '<p><b><i class="fa fa-tag" aria-hidden="true"></i> ' . _l('tags') . ':</b></p>'; ?>
                                                            <input type="text" class="tagsinput" id="tags_bulk"
                                                                name="tags_bulk" value="" data-role="tagsinput">
                                                        </div>
                                                        <hr />
                                                        <div class="form-group no-mbot">
                                                            <div class="radio radio-primary radio-inline">
                                                                <input type="radio" name="campaigns_bulk_visibility"
                                                                    id="campaigns_bulk_public" value="public">
                                                                <label for="campaigns_bulk_public">
                                                                    <?php echo _l('campaign_public'); ?>
                                                                </label>
                                                            </div>
                                                            <div class="radio radio-primary radio-inline">
                                                                <input type="radio" name="campaigns_bulk_visibility"
                                                                    id="campaigns_bulk_private" value="private">
                                                                <label for="campaigns_bulk_private">
                                                                    <?php echo _l('private'); ?>
                                                                </label>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="modal-footer">
                                                    <button type="button" class="btn btn-default"
                                                        data-dismiss="modal"><?php echo _l('close'); ?></button>
                                                    <a href="#" class="btn btn-primary"
                                                        onclick="campaigns_bulk_action(this); return false;"><?php echo _l('confirm'); ?></a>
                                                </div>
                                            </div>
                                            <!-- /.modal-content -->
                                        </div>
                                        <!-- /.modal-dialog -->
                                    </div>
                                    <!-- /.modal -->
                                    <?php

                              $table_data  = [];
                              $_table_data = [
                                '<span class="hide"> - </span><div class="checkbox mass_select_all_wrap"><input type="checkbox" id="mass_select_all" data-to-table="campaigns"><label></label></div>',
                                [
                                 'name'     => _l('the_number_sign'),
                                 'th_attrs' => ['class' => 'toggleable', 'id' => 'th-number'],
                               ],
                               [
                                 'name'     => _l('campaigns_dt_name'),
                                 'th_attrs' => ['class' => 'toggleable', 'id' => 'th-name'],
                               ],
                              ];
                              if (is_gdpr() && get_option('gdpr_enable_consent_for_campaigns') == '1') {
                                  $_table_data[] = [
                                    'name'     => _l('gdpr_consent') . ' (' . _l('gdpr_short') . ')',
                                    'th_attrs' => ['id' => 'th-consent', 'class' => 'not-export'],
                                 ];
                              }
                              $_table_data[] = [
                               'name'     => _l('campaign_company'),
                               'th_attrs' => ['class' => 'toggleable', 'id' => 'th-company'],
                              ];
                              $_table_data[] = [
                               'name'     => _l('campaigns_dt_email'),
                               'th_attrs' => ['class' => 'toggleable', 'id' => 'th-email'],
                              ];
                              $_table_data[] = [
                               'name'     => _l('campaigns_dt_phonenumber'),
                               'th_attrs' => ['class' => 'toggleable', 'id' => 'th-phone'],
                              ];
                              $_table_data[] = [
                                 'name'     => _l('campaigns_dt_campaign_value'),
                                 'th_attrs' => ['class' => 'toggleable', 'id' => 'th-campaign-value'],
                                ];
                              $_table_data[] = [
                               'name'     => _l('tags'),
                               'th_attrs' => ['class' => 'toggleable', 'id' => 'th-tags'],
                              ];
                              $_table_data[] = [
                               'name'     => _l('campaigns_dt_assigned'),
                               'th_attrs' => ['class' => 'toggleable', 'id' => 'th-assigned'],
                              ];
                              $_table_data[] = [
                               'name'     => _l('campaigns_dt_status'),
                               'th_attrs' => ['class' => 'toggleable', 'id' => 'th-status'],
                              ];
                              $_table_data[] = [
                               'name'     => _l('campaigns_source'),
                               'th_attrs' => ['class' => 'toggleable', 'id' => 'th-source'],
                              ];
                              $_table_data[] = [
                               'name'     => _l('campaigns_dt_last_contact'),
                               'th_attrs' => ['class' => 'toggleable', 'id' => 'th-last-contact'],
                              ];
                              $_table_data[] = [
                                'name'     => _l('campaigns_dt_datecreated'),
                                'th_attrs' => ['class' => 'date-created toggleable', 'id' => 'th-date-created'],
                              ];
                              foreach ($_table_data as $_t) {
                                  array_push($table_data, $_t);
                              }
                              $custom_fields = get_custom_fields('campaigns', ['show_on_table' => 1]);
                              foreach ($custom_fields as $field) {
                                  array_push($table_data, [
                                   'name'     => $field['name'],
                                   'th_attrs' => ['data-type' => $field['type'], 'data-custom-field' => 1],
                                ]);
                              }
                              $table_data = hooks()->apply_filters('campaigns_table_columns', $table_data);
                               ?>
                                    <div class="panel-table-full">
                                        <?php
                                 render_datatable(
                                   $table_data,
                                   'campaigns',
                                   ['customizable-table number-index-2'],
                                   [
                                    'id'                         => 'campaigns',
                                    'data-last-order-identifier' => 'campaigns',
                                    'data-default-order'         => get_table_last_order('campaigns'),
                                 ]
                               );
                                ?>
                                    </div>
                                </div>
                            </div>
							
							 <!-- Web Campaign Forms Table -->
    <!-- Web Campaign Forms Table -->
<div id="web-campaigns-table" style="display:none;" class="panel-body">
    <h4 class="tw-font-semibold"><?php echo _l('web_campaign_forms'); ?></h4>
    <div class="table-responsive">
        <table class="table dt-table table-campaigns" data-order-col="2" data-order-type="desc">
            <thead>
                <tr>
                    <th class="th-campaign-no"><?= _l('#'); ?></th>
                    <th class="th-campaign-name"><?= _l('Form Name'); ?></th>
                    <th class="th-campaign-company"><?= _l('Total Submissions'); ?></th>
                    <th class="th-campaign-email"><?= _l('Last Submission Time'); ?></th>
                    <th class="th-campaign-phone"><?= _l('Created'); ?></th>
                    <th class="th-campaign-created"><?= _l('Action'); ?></th>
                </tr>
            </thead>
            <tbody>
                <?php foreach ($web_campaign_forms as $key => $form) { ?>
                    <tr>
                        <td><?= e($key + 1); ?></td>
                        <td><?= e($form['tblweb_to_campaign.name'] ?? ''); ?></td>
                        <td><?= e($form['total_submissions'] ?? 0); ?></td>
                        <td><?= !empty($form['last_submission_time']) ? _dt($form['last_submission_time']) : '-'; ?></td>
                        <td><?= !empty($form['tblweb_to_campaign.dateadded']) ? _dt($form['tblweb_to_campaign.dateadded']) : '-'; ?></td>
                        <td>
                            <a class="btn btn-sm btn-primary" href="<?= admin_url('campaigns?from_form_id=' . ($form['tblweb_to_campaign.id'] ?? $form['id'])); ?>">
                                <i class="fa fa-eye"></i> View
                            </a>
                        </td>
                    </tr>
                <?php } ?>
            </tbody>
        </table>
    </div>
</div>


                            <?php } ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<script id="hidden-columns-table-campaigns" type="text/json">
<?php echo get_staff_meta(get_staff_user_id(), 'hidden-columns-table-campaigns'); ?>
</script>
<?php include_once(APPPATH . 'views/admin/campaigns/status.php'); ?>
<?php init_tail(); ?>
<script>
var openCampaignID = '<?php echo e($campaignid); ?>';
$(function() {
    campaigns_kanban();
    $('#campaigns_bulk_mark_lost').on('change', function() {
        $('#move_to_status_campaigns_bulk').prop('disabled', $(this).prop('checked') == true);
        $('#move_to_status_campaigns_bulk').selectpicker('refresh')
    });
    $('#move_to_status_campaigns_bulk').on('change', function() {
        if ($(this).selectpicker('val') != '') {
            $('#campaigns_bulk_mark_lost').prop('disabled', true);
            $('#campaigns_bulk_mark_lost').prop('checked', false);
        } else {
            $('#campaigns_bulk_mark_lost').prop('disabled', false);
        }
    });
});
</script>
<script src="<?= base_url('assets/js/campaigns_table_order.js'); ?>"></script>
<script>
function toggleCampaignTables() {
    const camp = document.getElementById('campaigns-table');
    const web = document.getElementById('web-campaigns-table');
    const btn = document.getElementById('toggle-table-btn');
    
    const toFormsText = '<?php echo _l('Switch to Campaign Forms'); ?>';
    const toCampaignsText = '<?php echo _l('Switch to Campaigns Table'); ?>';

    if (camp.style.display === 'none') {
        camp.style.display = '';
        web.style.display = 'none';
        btn.innerText = toFormsText;
    } else {
        camp.style.display = 'none';
        web.style.display = '';
        btn.innerText = toCampaignsText;
    }
}
</script>
</body>

</html>