<?php defined('BASEPATH') or exit('No direct script access allowed'); ?>
<?php init_head(); ?>
<?php if (isset($form)) {
    echo form_hidden('form_id', $form->id);
} ?>
<div id="wrapper">
    <div class="content">
        <div
            class="<?= ! isset($form) ? 'tw-max-w-4xl tw-mx-auto' : 'tw-w-full'; ?>">
            <?php if (! isset($form)) { ?>
            <div class="alert alert-info">
                <?= _l('form_builder_create_form_first'); ?>
            </div>
            <?php } ?>
            <?php if (isset($form)) { ?>
            <div class="horizontal-scrollable-tabs">
                <div class="scroller arrow-left"><i class="fa fa-angle-left"></i></div>
                <div class="scroller arrow-right"><i class="fa fa-angle-right"></i></div>
                <div class="horizontal-tabs">
                    <ul class="nav nav-tabs nav-tabs-segmented nav-tabs-horizontal tw-mb-3" role="tablist">
                        <li role="presentation" class="active">
                            <a href="#tab_form_build" aria-controls="tab_form_build" role="tab" data-toggle="tab">
                                <i class="fa-solid fa-wrench menu-icon"></i>
                                <?= _l('form_builder'); ?>
                            </a>
                        </li>
                        <li role="presentation">
                            <a href="#tab_form_information" aria-controls="tab_form_information" role="tab"
                                data-toggle="tab">
                                <i class="fa-regular fa-file-lines menu-icon"></i>
                                <?= _l('form_information'); ?>
                            </a>
                        </li>
                        <li role="presentation">
                            <a href="#tab_form_integration" aria-controls="tab_form_integration" role="tab"
                                data-toggle="tab">
                                <i class="fa-solid fa-code menu-icon"></i>
                                <?= _l('form_integration_code'); ?>
                            </a>
                        </li>
                    </ul>
                </div>
            </div>
            <?php } ?>
            <?php if (! isset($form)) { ?>
            <h4 class="tw-mt-0 tw-font-bold tw-text-lg tw-text-neutral-700">
                <?= _l('new_form'); ?>
            </h4>
            <?php } ?>
            <div class="panel_s">
                <div class="panel-body">
                    <div class="tab-content">
                        <?php if (isset($form)) { ?>
                        <div role="tabpanel" class="tab-pane active" id="tab_form_build">
                            <div id="build-wrap"></div>
                        </div>
                        <div role="tabpanel" class="tab-pane" id="tab_form_integration">
                            <p><?= _l('form_integration_code_help'); ?>
                            </p>
                            <textarea class="form-control"
                                rows="2"><iframe width="600" height="850" src="<?= site_url('forms/wtc/' . $form->form_key); ?>" frameborder="0" sandbox="allow-top-navigation allow-forms allow-scripts allow-same-origin allow-popups" allowfullscreen></iframe></textarea>
                            <h4 class="tw-my-5 bold">Share direct link</h4>
                            <p>
                                <span class="label label-default">
                                    <a href="<?= site_url('forms/wtc/' . $form->form_key) . '?styled=1'; ?>"
                                        target="_blank">
                                        <?= site_url('forms/wtc/' . $form->form_key) . '?styled=1'; ?>
                                    </a>
                                </span>
                                <br />
                                <br />
                                <span class="label label-default">
                                    <a href="<?= site_url('forms/wtc/' . $form->form_key) . '?styled=1&with_logo=1'; ?>"
                                        target="_blank">
                                        <?= site_url('forms/wtc/' . $form->form_key) . '?styled=1&with_logo=1'; ?>
                                    </a>
                                </span>
                            </p>
                            <hr />
                            <p class="bold mtop15">When placing the iframe snippet code consider the following:</p>
                            <p
                                class="<?= strpos(site_url(), 'http://') !== false ? 'bold text-success' : ''; ?>">
                                1. If the protocol of your installation is http use a http page inside the iframe.
                            </p>
                            <p
                                class="<?= strpos(site_url(), 'https://') !== false ? 'bold text-success' : ''; ?>">
                                2. If the protocol of your installation is https use a https page inside the
                                iframe.
                            </p>
                            <p>
                                None SSL installation will need to place the link in non ssl eq. landing page and
                                backwards.
                            </p>
                        </div>
                        <?php } ?>
                        <div role="tabpanel"
                            class="tab-pane<?= ! isset($form) ? ' active' : ''; ?>"
                            id="tab_form_information">
                            <div
                                class="<?= isset($form) ? 'tw-mx-auto tw-max-w-3xl' : ''; ?>">

                                <div class="horizontal-scrollable-tabs">
                                    <div class="scroller arrow-left"><i class="fa fa-angle-left"></i></div>
                                    <div class="scroller arrow-right"><i class="fa fa-angle-right"></i></div>
                                    <div class="horizontal-tabs">
                                        <ul class="nav nav-tabs nav-tabs-segmented nav-tabs-horizontal" role="tablist">
                                            <li role="presentation" class="active">
                                                <a href="#tab_config_general" aria-controls="tab_config_general"
                                                    role="tab" data-toggle="tab">
                                                    General
                                                </a>
                                            </li>
                                            <li role="presentation">
                                                <a href="#tab_config_branding" aria-controls="tab_config_branding"
                                                    role="tab" data-toggle="tab">
                                                    Branding
                                                </a>
                                            </li>
                                            <li role="presentation">
                                                <a href="#tab_config_submission" aria-controls="tab_config_submission"
                                                    role="tab" data-toggle="tab">
                                                    Submission
                                                </a>
                                            </li>
                                            <li role="presentation">
                                                <a href="#tab_config_notifications"
                                                    aria-controls="tab_config_notifications" role="tab"
                                                    data-toggle="tab">
                                                    Notifications
                                                </a>
                                            </li>
                                        </ul>
                                    </div>
                                </div>
                                <?= form_open($this->uri->uri_string(), ['id' => 'form_info']); ?>
                                <div class="tab-content">
                                    <div role="tabpanel" class="tab-pane active" id="tab_config_general">
                                        <?php $value = (isset($form) ? $form->name : ''); ?>
                                        <?= render_input('name', 'form_name', $value); ?>
                                        <?php if (get_option('recaptcha_secret_key') != '' && get_option('recaptcha_site_key') != '') { ?>
                                        <div class="form-group">
                                            <label
                                                for=""><?= _l('form_recaptcha'); ?></label><br />
                                            <div class="radio radio-inline radio-danger">
                                                <input type="radio" name="recaptcha" id="racaptcha_0" value="0"
                                                    <?= isset($form) && $form->recaptcha == 0 || ! isset($form) ? 'checked' : ''; ?>>
                                                <label
                                                    for="recaptcha_0"><?= _l('settings_no'); ?></label>
                                            </div>
                                            <div class="radio radio-inline radio-success">
                                                <input type="radio" name="recaptcha" id="recaptcha_1" value="1"
                                                    <?= isset($form) && $form->recaptcha == 1 ? 'checked' : ''; ?>>
                                                <label
                                                    for="recaptcha_1"><?= _l('settings_yes'); ?></label>
                                            </div>
                                        </div>
                                        <?php } ?>
                                        <div class="form-group select-placeholder">
                                            <div class="tw-mb-1.5">
                                                <label for="language" class="control-label">
                                                    <?= _l('form_lang_validation'); ?>
                                                </label>
                                                <select name="language" id="language" class="form-control selectpicker"
                                                    data-none-selected-text="<?= _l('dropdown_non_selected_tex'); ?>">
                                                    <option value=""></option>
                                                    <?php foreach ($languages as $availableLanguage) { ?>
                                                    <option
                                                        value="<?= e($availableLanguage); ?>"
                                                        <?= (isset($form) && $form->language == $availableLanguage) || (! isset($form) && get_option('active_language') == $availableLanguage) ? 'selected' : ''; ?>>
                                                        <?= e(ucfirst($availableLanguage)); ?>
                                                    </option>
                                                    <?php } ?>
                                                </select>
                                                <span>
                                                    <?= _l('form_lang_validation_help'); ?>
                                                </span>
                                            </div>
                                        </div>

                                        <div class="form-group">
                                            <?php $value = (isset($form) ? $form->campaign_name_prefix : ''); ?>
                                            <?= render_input('campaign_name_prefix', 'campaign_name_prefix', $value, 'text', [], [], 'mbot5'); ?>
                                            <span><?= _l('campaign_name_prefix_help') ?></span>
                                        </div>
                                        <?= render_campaigns_source_select($sources, (isset($form) ? $form->campaign_source : get_option('campaigns_default_source')), 'campaign_import_source', 'campaign_source');

echo render_campaigns_status_select($statuses, (isset($form) ? $form->campaign_status : get_option('campaigns_default_status')), 'campaign_import_status', 'campaign_status', [], true);

$selected_staff = [];
if (isset($form)) {
    $selected_staff = is_array($form->responsible)
        ? $form->responsible
        : json_decode($form->responsible, true);

    if (!is_array($selected_staff)) {
        $selected_staff = [];
    }
}
												
?>
                                      <?= render_select('responsible[]', $members, ['staffid', ['firstname', 'lastname']], 'campaigns_import_assignee', $selected_staff, ['multiple' => true]); ?>

										

										<?php
// Customer selection
$selected_client = '';
if (isset($form)) {
    $selected_client = is_array($form->responsible_client) ? $form->responsible_client : json_decode($form->responsible_client, true);
    if (!is_array($selected_client)) {
        $selected_client = [];
    }
}
?>
<?= render_select('responsible_client[]', $clients, ['userid', ['company']], 'campaigns_import_customer', is_array($selected_client) ? $selected_client : [$selected_client], ['multiple' => true]); ?>

                                    </div>
                                    <div role="tabpanel" class="tab-pane" id="tab_config_branding">
                                        <?php $value = (isset($form) ? $form->submit_btn_name : 'Submit'); ?>
                                        <?= render_input('submit_btn_name', 'form_btn_submit_text', $value); ?>
                                        <div class="md:tw-grid md:tw-grid-cols-2 md:tw-gap-4">
                                            <div class="[&_.input-group]:!tw-mb-0">
                                                <?php $value = (isset($form) ? $form->submit_btn_bg_color : '#84c529'); ?>
                                                <?= render_color_picker('submit_btn_bg_color', _l('submit_button_bg_color'), $value); ?>
                                            </div>
                                            <div class="[&_.input-group]:!tw-mb-0">
                                                <?php $value = (isset($form) ? $form->submit_btn_text_color : '#ffffff'); ?>
                                                <?= render_color_picker('submit_btn_text_color', _l('submit_button_text_color'), $value); ?>
                                            </div>
                                        </div>
                                    </div>
                                    <div role="tabpanel" class="tab-pane" id="tab_config_submission">
                                        <label for="" class="control-label bold">
                                            <?= _l('form_submit_success_action'); ?>?
                                        </label>
                                        <div class="radio radio-primary">
                                            <input type="radio" name="submit_action" value="0" id="success_message"
                                                <?= isset($form) && $form->submit_action == '0' || ! isset($form) ? 'checked' : ''; ?>>
                                            <label for="success_message">
                                                <?= _l('form_submit_success_display_thank_you'); ?>
                                            </label>
                                        </div>
                                        <div class="radio radio-primary">
                                            <input type="radio" name="submit_action" value="1" id="website_redirect"
                                                <?= isset($form) && $form->submit_action == '1' ? 'checked' : ''; ?>>
                                            <label for="website_redirect">
                                                <?= _l('form_submit_success_redirect_to_website'); ?>
                                            </label>
                                        </div>
                                        <?php $value = (isset($form) ? $form->success_submit_msg : ''); ?>
                                        <?= render_textarea('success_submit_msg', 'form_success_submit_msg', $value); ?>
                                        <?php $value = (isset($form) ? $form->submit_redirect_url : ''); ?>
                                        <?= render_input('submit_redirect_url', 'form_submit_website_url', $value, 'url'); ?>
                                        <div class="checkbox checkbox-primary">
                                            <input type="checkbox" name="mark_public" id="mark_public"
                                                <?= isset($form) && $form->mark_public == 1 ? 'checked' : ''; ?>>
                                            <label for="mark_public">
                                                <?= _l('auto_mark_as_public'); ?>
                                            </label>
                                        </div>
                                        <div class="checkbox checkbox-primary">
                                            <input type="checkbox" name="allow_duplicate" id="allow_duplicate"
                                                <?= isset($form) && $form->allow_duplicate == 1 || ! isset($form) ? 'checked' : ''; ?>>
                                            <label for="allow_duplicate">
                                                <?= e(_l('form_allow_duplicate', _l('campaign_lowercase'))); ?>
                                            </label>
                                        </div>
                                        <div
                                            class="duplicate-settings-wrapper row<?= isset($form) && $form->allow_duplicate == 1 || ! isset($form) ? ' hide' : ''; ?>">

                                            <div class="col-md-6">
                                                <div class="form-group">
                                                    <label for="track_duplicate_field">
                                                        <?= _l('track_duplicate_by_field'); ?>
                                                    </label><br />
                                                    <select class="selectpicker track_duplicate_field" data-width="100%"
                                                        name="track_duplicate_field" id="track_duplicate_field"
                                                        data-none-selected-text="<?= _l('dropdown_non_selected_tex'); ?>">
                                                        <option value=""></option>
                                                        <?php foreach ($db_fields as $field) { ?>
                                                        <option
                                                            value="<?= e($field->name); ?>"
                                                            <?= isset($form) && $form->track_duplicate_field == $field->name ? 'selected' : ''; ?>
                                                            <?= isset($form) && $form->track_duplicate_field_and == $field->name ? 'disabled' : ''; ?>>
                                                            <?= e($field->label); ?>
                                                        </option>
                                                        <?php } ?>
                                                    </select>
                                                </div>
                                            </div>
                                            <div class="col-md-6">
                                                <div class="form-group">
                                                    <label for="track_duplicate_field_and">
                                                        <?= _l('and_track_duplicate_by_field'); ?>
                                                    </label><br />
                                                    <select class="selectpicker track_duplicate_field_and"
                                                        data-width="100%" name="track_duplicate_field_and"
                                                        id="track_duplicate_field_and"
                                                        data-none-selected-text="<?= _l('dropdown_non_selected_tex'); ?>">
                                                        <option value=""></option>
                                                        <?php foreach ($db_fields as $field) { ?>
                                                        <option
                                                            value="<?= e($field->name); ?>"
                                                            <?= isset($form) && $form->track_duplicate_field_and == $field->name ? ' selected' : ''; ?>
                                                            <?= isset($form) && $form->track_duplicate_field == $field->name ? 'disabled' : ''; ?>>
                                                            <?= e($field->label); ?>
                                                        </option>
                                                        <?php } ?>
                                                    </select>
                                                </div>
                                            </div>
                                            <div class="col-md-12">
                                                <div class="checkbox checkbox-primary">
                                                    <input type="checkbox" name="create_task_on_duplicate"
                                                        id="create_task_on_duplicate"
                                                        <?= (isset($form) && $form->create_task_on_duplicate == 1 || ! isset($form)) ? 'checked' : ''; ?>>
                                                    <label for="create_task_on_duplicate">
                                                        <i class="fa-regular fa-circle-question" data-toggle="tooltip"
                                                            data-title="<?= _l('create_the_duplicate_form_data_as_task_help'); ?>">
                                                        </i>
                                                        <?= e(_l('create_the_duplicate_form_data_as_task', _l('campaign_lowercase'))); ?>
                                                    </label>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <div role="tabpanel" class="tab-pane" id="tab_config_notifications">
                                        <p class="tw-font-semibold tw-mb-3">
                                            <?= _l('notification_settings'); ?>
                                        </p>
                                        <div class="checkbox">
                                            <input type="checkbox" name="notify_campaign_imported" id="notify_campaign_imported"
                                                <?= isset($form) && $form->notify_campaign_imported == 1 || ! isset($form) ? 'checked' : ''; ?>>
                                            <label for="notify_campaign_imported">
                                                <?= _l('campaigns_email_integration_notify_when_campaign_imported'); ?>
                                            </label>
                                        </div>
                                        <div
                                            class="select-notification-settings tw-mt-6<?= isset($form) && $form->notify_campaign_imported == '0' ? ' hide' : ''; ?>">
                                            <div class="radio radio-inline">
                                                <input type="radio" name="notify_type" value="specific_staff"
                                                    id="specific_staff"
                                                    <?= isset($form) && $form->notify_type == 'specific_staff' || ! isset($form) ? 'checked' : ''; ?>>
                                                <label
                                                    for="specific_staff"><?= _l('specific_staff_members'); ?></label>
                                            </div>
                                            <div class="radio radio-inline">
                                                <input type="radio" name="notify_type" id="roles" value="roles"
                                                    <?= isset($form) && $form->notify_type == 'roles' ? 'checked' : ''; ?>>
                                                <label
                                                    for="roles"><?= _l('staff_with_roles'); ?></label>
                                            </div>
                                            <div class="radio radio-inline">
                                                <input type="radio" name="notify_type" id="assigned" value="assigned"
                                                    <?= isset($form) && $form->notify_type == 'assigned' ? 'checked' : ''; ?>>
                                                <label
                                                    for="assigned"><?= _l('notify_assigned_user'); ?></label>
                                            </div>
                                            <div class="clearfix mtop15"></div>
                                            <div id="specific_staff_notify"
                                                class="<?= isset($form) && $form->notify_type != 'specific_staff' ? 'hide' : ''; ?>">
                                                <?php
                       $selected = [];
if (isset($form) && $form->notify_type == 'specific_staff') {
    $selected = unserialize($form->notify_ids);
}
?>
                                                <?= render_select('notify_ids_staff[]', $members, ['staffid', ['firstname', 'lastname']], 'campaigns_email_integration_notify_staff', $selected, ['multiple' => true]); ?>
                                            </div>
                                            <div id="role_notify"
                                                class="<?= isset($form) && $form->notify_type != 'roles' || ! isset($form) ? 'hide' : ''; ?>">
                                                <?php
$selected = [];
if (isset($form) && $form->notify_type == 'roles') {
    $selected = unserialize($form->notify_ids);
}
?>
                                                <?= render_select('notify_ids_roles[]', $roles, ['roleid', ['name']], 'campaigns_email_integration_notify_roles', $selected, ['multiple' => true]); ?>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="text-right">
                                        <button type="submit" class="btn btn-primary">
                                            <?= _l('submit'); ?>
                                        </button>
                                    </div>
                                </div>
                                <?= form_close(); ?>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<?php init_tail(); ?>
<script
    src="<?= base_url('assets/plugins/form-builder/form-builder.min.js'); ?>">
</script>
<script>
    var buildWrap = document.getElementById('build-wrap');
    var formData = <?= json_encode($formData); ?> ;

    if (formData.length) {
        // If user paste with styling eq from some editor word and the Codeigniter XSS feature remove and apply xss=remove, may break the json.
        formData = formData.replace(/=\\/gm, "=''");
    }
</script>
<?php $this->load->view('admin/includes/_form_js_formatter'); ?>
<script>
    $(function() {

        $('body').on('blur', '.form-field.editing', function() {
            $.Shortcuts.start();
        });

        $('body').on('focus', '.form-field.editing', function() {
            $.Shortcuts.stop();
        });

        var formBuilder = $(buildWrap).formBuilder(fbOptions);
        var $create_task_on_duplicate = $('#create_task_on_duplicate');

        $('#allow_duplicate').on('change', function() {
            $('.duplicate-settings-wrapper').toggleClass('hide');
        });

        $('#notify_campaign_imported').on('change', function() {
            $('.select-notification-settings').toggleClass('hide');
        });

        $('#track_duplicate_field,#track_duplicate_field_and').on('change', function() {
            var selector = ($(this).hasClass('track_duplicate_field') ? 'track_duplicate_field_and' :
                'track_duplicate_field')
            $('#' + selector + ' option').removeAttr('disabled', true);
            var val = $(this).val();
            if (val !== '') {
                $('#' + selector + ' option[value="' + val + '"]').attr('disabled', true);
            }
            $('#' + selector + '').selectpicker('refresh');
        });

        setTimeout(function() {
            $(".form-builder-save").wrap("<div class='btn-bottom-toolbar text-right'></div>");
            $btnToolbar = $('body').find('#tab_form_build .btn-bottom-toolbar');
            $btnToolbar = $('#tab_form_build').append($btnToolbar);
            $btnToolbar.find('.btn').addClass('btn-primary');
        }, 100);

        $('body').on('click', '.save-template', function() {
            $.post(admin_url + 'campaigns/save_form_data', {
                formData: formBuilder.formData,
                id: $('input[name="form_id"]').val()
            }).done(function(response) {
                response = JSON.parse(response);
                if (response.success == true) {
                    alert_float('success', response.message);
                }
            });
        });

        appValidateForm('#form_info', {
            name: 'required',
            campaign_source: 'required',
            campaign_status: 'required',
            language: 'required',
            submit_btn_name: 'required',
            submit_btn_bg_color: 'required',
            submit_btn_text_color: 'required',
            responsible: {
                required: {
                    depends: function(element) {
                        var isRequiredByNotifyType = ($('input[name="notify_type"]:checked')
                            .val() ==
                            'assigned') ? true : false;
                        var isRequiredByAssignTask = ($create_task_on_duplicate.is(':checked')) ?
                            true :
                            false;
                        var isRequired = isRequiredByNotifyType || isRequiredByAssignTask;
                        if (isRequired) {
                            $('[for="responsible"]').find('.req').removeClass('hide');
                        } else {
                            $(element).next('p.text-danger').remove();
                            $('[for="responsible"]').find('.req').addClass('hide');
                        }
                        return isRequired;
                    }
                }
            },
			responsible_client: 'required',
            success_submit_msg: {
                required: {
                    depends: function(element) {
                        var isRequired = ($('input[name="submit_action"]:checked').val() === '0') ?
                            true : false;
                        if (isRequired) {
                            $('[for="success_submit_msg"]').find('.req').removeClass('hide');
                        } else {
                            $(element).next('p.text-danger').remove();
                            $('[for="success_submit_msg"]').find('.req').addClass('hide');
                        }
                        return isRequired;
                    }
                }
            },
            submit_redirect_url: {
                required: {
                    depends: function(element) {
                        var isRequired = ($('input[name="submit_action"]:checked').val() === '1') ?
                            true : false;
                        if (isRequired) {
                            $('[for="submit_redirect_url"]').find('.req').removeClass('hide');
                        } else {
                            $(element).next('p.text-danger').remove();
                            $('[for="submit_redirect_url"]').find('.req').addClass('hide');
                        }
                        return isRequired;
                    }
                }
            }
        });

        var $notifyTypeInput = $('input[name="notify_type"]');
        $notifyTypeInput.on('change', function() {
            $('#form_info').validate().checkForm()
        });
        $notifyTypeInput.trigger('change');

        $create_task_on_duplicate.on('change', function() {
            $('#form_info').validate().checkForm()
        });

        $create_task_on_duplicate.trigger('change');

        var $submitActionInput = $('input[name="submit_action"]');
        $submitActionInput.on('change', function() {
            $('#form_info').validate().checkForm();

            if ($('input[name="submit_action"]:checked').val() === '1') {
                $('[app-field-wrapper="submit_redirect_url"]').removeClass('hide');
                $('[app-field-wrapper="success_submit_msg"]').addClass('hide');
            } else {
                $('[app-field-wrapper="success_submit_msg"]').removeClass('hide');
                $('[app-field-wrapper="submit_redirect_url"]').addClass('hide');
            }
        });
        $submitActionInput.trigger('change');
    });
</script>
</body>

</html>