<?php defined('BASEPATH') or exit('No direct script access allowed'); ?>
<?php init_head(); ?>

<div id="wrapper">
    <div class="content">
        <div class="row">
            <div class="col-md-12">

                <h4>
                    <?php echo _l('Campaign Submissions'); ?> (<?php echo _l('Form ID'); ?>: <?php echo htmlspecialchars($form_id); ?>)
                </h4>

                <a href="<?php echo admin_url('campaigns'); ?>" class="btn btn-primary mb-3">
                    <?php echo _l('Back to All Forms'); ?>
                </a>

                <!-- ✅ Filters Component -->
				<div id="vueApp" class="tw-inline pull-right">
                <div id="campaigns-filters" class="mb-3">
                    <app-filters
                        id="<?php echo $table->id(); ?>"
                        view="<?php echo $table->viewName(); ?>"
                        :rules="<?php echo app\services\utilities\Js::from($this->input->get('status') ? $table->findRule('status')->setValue([$this->input->get('status')]) : []); ?>"
                        :saved-filters="<?php echo $table->filtersJs(); ?>"
                        :available-rules="<?php echo $table->rulesJs(); ?>">
                    </app-filters>
                </div>
</div>
                <div class="table-responsive">
                    <table id="campaigns_form" class="table table-striped table-bordered" style="width:100%">
                        <thead>
                            <tr>
                                <th><?php echo _l('ID'); ?></th>
                                <th><?php echo _l('Campaign Name'); ?></th>
                                <th><?php echo _l('Email'); ?></th>
                                <th><?php echo _l('Phone'); ?></th>
                                <th><?php echo _l('Company'); ?></th>
                                <th><?php echo _l('Value'); ?></th>
                                <th><?php echo _l('Assigned'); ?></th>
                                <th><?php echo _l('Status'); ?></th>
                                <th><?php echo _l('Source'); ?></th>
                                <th><?php echo _l('Date Added'); ?></th>
                                <th><?php echo _l('Actions'); ?></th>
                            </tr>
                        </thead>
                        <tbody></tbody>
                    </table>
                </div>

            </div>
        </div>
    </div>
</div>

<?php init_tail(); ?>

<!-- ✅ Include jQuery and DataTables -->
<link rel="stylesheet" href="https://cdn.datatables.net/1.13.5/css/jquery.dataTables.min.css" />
<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script src="https://cdn.datatables.net/1.13.5/js/jquery.dataTables.min.js"></script>

<script>
$(document).ready(function () {
    var table = $('#campaigns_form').DataTable({
        processing: true,
        serverSide: true,
        ajax: {
    url: '<?php echo admin_url('campaigns/data_form/' . $form_id); ?>',
    type: 'POST',
    data: function (d) {
        d.form_id = '<?php echo $form_id; ?>';
        <?php if (get_option('csrf_protection') == '1') { ?>
        d['<?php echo $this->security->get_csrf_token_name(); ?>'] = '<?php echo $this->security->get_csrf_hash(); ?>';
        <?php } ?>

        // Send filters here
        if (typeof window.getSelectedCampaignFilters === 'function') {
            const filters = window.getSelectedCampaignFilters();
            console.log('Sending filters:', filters); // Debug in browser console
            d.filters = filters;
        }
    }
},
        order: [[9, 'desc']],
        pageLength: 25,
        columns: [
            { data: 'id' },
            { data: 'name' },
            { data: 'email' },
            { data: 'phone' },
            { data: 'company' },
            { data: 'value' },
            { data: 'assigned' },
            { data: 'status' },
            { data: 'source' },
            { data: 'date_added' },
            { data: 'actions' }
        ],
        columnDefs: [
            { targets: [6, 7, 10], searchable: false },
            { targets: [10], orderable: false }
        ],
        language: app.lang.datatables,
        responsive: true,
        lengthChange: true,
        searching: true,
        paging: true,
        info: true,
        dom: 'lBfrtip',
        initComplete: function () {
            console.log('DataTable initialized successfully');
        }
    });

    // ✅ Optional: Reload table when filters change (listen for a Vue event)
    document.addEventListener('filters-changed', function () {
        table.ajax.reload();
    });
});
</script>

<!-- ✅ Optionally provide a JS method Vue can use to pass filters -->
<script>
window.getSelectedCampaignFilters = function () {
    // Return filters from Vue component
    if (window.app && app.$refs && app.$refs['campaignsFilters']) {
        return app.$refs['campaignsFilters'].getSelectedFilters?.() || {};
    }

    // Fallback: empty filter set
    return {};
};
</script>

</body>
</html>
