<?php defined('BASEPATH') or exit('No direct script access allowed');
$campaign_already_client_tooltip = '';
$campaign_is_client              = $campaign['is_campaign_client'] !== '0';
if ($campaign_is_client) {
    $campaign_already_client_tooltip = ' data-toggle="tooltip" title="' . _l('campaign_have_client_profile') . '"';
}
if ($campaign['status'] == $status['id']) { ?>
<li data-campaign-id="<?= e($campaign['id']); ?>" <?= e($campaign_already_client_tooltip); ?>
    class="campaign-kan-ban<?= $campaign['assigned'] == get_staff_user_id() ? ' current-user-campaign' : ''; ?><?= $campaign_is_client && get_option('campaign_lock_after_convert_to_customer') == 1 && ! is_admin() ? ' not-sortable' : ''; ?>">
    <div class="panel-body campaign-body">
        <div class="tw-flex campaign-name">
            <?php if ($campaign['assigned'] != 0) { ?>
            <a href="<?= admin_url('profile/' . $campaign['assigned']); ?>"
                data-placement="right" data-toggle="tooltip"
                title="<?= e(get_staff_full_name($campaign['assigned'])); ?>"
                class="mtop8 tw-mr-1.5">
                <?= staff_profile_image($campaign['assigned'], [
                    'staff-profile-image-xs',
                ]); ?></a>
            <?php } ?>
            <a href="<?= admin_url('campaigns/index/' . e($campaign['id'])); ?>"
                title="#<?= e($campaign['id']) . ' - ' . e($campaign['campaign_name']); ?>"
                onclick="init_campaign(<?= e($campaign['id']); ?>);return false;"
                class="tw-block tw-min-w-0 tw-font-medium">
                <span class="mtop10 mbot10 tw-truncate tw-block">
                    #<?= e($campaign['id']) . ' - ' . e($campaign['campaign_name']); ?>
                </span>
            </a>
        </div>
        <div class="row">
            <div class="col-md-12">
                <div class="tw-flex">
                    <div class="tw-grow tw-mr-2">
                        <p class="tw-text-sm tw-mb-0">
                            <?= _l('campaigns_canban_source', $campaign['source_name']); ?>
                        </p>
                        <?php $campaign_value = $campaign['campaign_value'] != 0 ? app_format_money($campaign['campaign_value'], $base_currency->symbol) : '--'; ?>
                        <p class="tw-text-sm tw-mb-0">
                            <?= e(_l('campaigns_canban_campaign_value', $campaign_value)); ?>
                        </p>
                    </div>
                    <div class="text-right">
                        <?php if (is_date($campaign['lastcontact']) && $campaign['lastcontact'] != '0000-00-00 00:00:00') { ?>
                        <small
                            class="text-dark tw-text-sm"><?= _l('campaigns_dt_last_contact'); ?>
                            <span class="bold">
                                <span class="text-has-action" data-toggle="tooltip"
                                    data-title="<?= e(_dt($campaign['lastcontact'])); ?>">
                                    <?= e(time_ago($campaign['lastcontact'])); ?>
                                </span>
                            </span>
                        </small><br />
                        <?php } ?>
                        <small
                            class="text-dark"><?= _l('campaign_created'); ?>:
                            <span class="bold">
                                <span class="text-has-action" data-toggle="tooltip"
                                    data-title="<?= e(_dt($campaign['dateadded'])); ?>">
                                    <?= e(time_ago($campaign['dateadded'])); ?>
                                </span>
                            </span>
                        </small><br />
                        <?php hooks()->do_action('before_campaigns_kanban_card_icons', $campaign); ?>
                        <span class="mright5 mtop5 inline-block text-muted" data-toggle="tooltip" data-placement="left"
                            data-title="<?= _l('campaigns_canban_notes', $campaign['total_notes']); ?>">
                            <i class="fa-regular fa-note-sticky"></i>
                            <?= e($campaign['total_notes']); ?>
                        </span>
                        <span class="mtop5 inline-block text-muted" data-placement="left" data-toggle="tooltip"
                            data-title="<?= _l('campaign_kan_ban_attachments', $campaign['total_files']); ?>">
                            <i class="fa fa-paperclip"></i>
                            <?= e($campaign['total_files']); ?>
                        </span>
                        <?php hooks()->do_action('after_campaigns_kanban_card_icons', $campaign); ?>
                    </div>
                </div>
            </div>

            <?php if ($campaign['tags']) { ?>
            <div class="col-md-12">
                <div class="kanban-tags tw-text-sm tw-inline-flex">
                    <?= render_tags($campaign['tags']); ?>
                </div>
            </div>
            <?php } ?>
            <a href="#" class="pull-right text-muted kan-ban-expand-top"
                onclick="slideToggle('#kan-ban-expand-<?= e($campaign['id']); ?>'); return false;">
                <i class="fa fa-expand" aria-hidden="true"></i>
            </a>
            <div class="clearfix no-margin"></div>
            <div id="kan-ban-expand-<?= e($campaign['id']); ?>"
                class="padding-10" style="display:none;">
                <div class="clearfix"></div>
                <hr class="hr-10" />
                <p class="text-muted campaign-field-heading">
                    <?= _l('campaign_title'); ?>
                </p>
                <p class="bold tw-text-sm">
                    <?= e($campaign['title'] != '' ? $campaign['title'] : '-') ?>
                </p>
                <p class="text-muted campaign-field-heading">
                    <?= _l('campaign_add_edit_email'); ?>
                </p>
                <p class="bold tw-text-sm">
                    <?= $campaign['email'] != '' ? '<a href="mailto:' . e($campaign['email']) . '">' . e($campaign['email']) . '</a>' : '-' ?>
                </p>
                <p class="text-muted campaign-field-heading">
                    <?= _l('campaign_website'); ?>
                </p>
                <p class="bold tw-text-sm">
                    <?= $campaign['website'] != '' ? '<a href="' . e(maybe_add_http($campaign['website'])) . '" target="_blank">' . e($campaign['website']) . '</a>' : '-' ?>
                </p>
                <p class="text-muted campaign-field-heading">
                    <?= _l('campaign_add_edit_phonenumber'); ?>
                </p>
                <p class="bold tw-text-sm">
                    <?= $campaign['phonenumber'] != '' ? '<a href="tel:' . e($campaign['phonenumber']) . '">' . e($campaign['phonenumber']) . '</a>' : '-' ?>
                </p>
                <p class="text-muted campaign-field-heading">
                    <?= _l('campaign_company'); ?>
                </p>
                <p class="bold tw-text-sm">
                    <?= e($campaign['company'] != '' ? $campaign['company'] : '-') ?>
                </p>
                <p class="text-muted campaign-field-heading">
                    <?= _l('campaign_address'); ?>
                </p>
                <p class="bold tw-text-sm">
                    <?= e($campaign['address'] != '' ? $campaign['address'] : '-') ?>
                </p>
                <p class="text-muted campaign-field-heading">
                    <?= _l('campaign_city'); ?>
                </p>
                <p class="bold tw-text-sm">
                    <?= e($campaign['city'] != '' ? $campaign['city'] : '-') ?>
                </p>
                <p class="text-muted campaign-field-heading">
                    <?= _l('campaign_state'); ?>
                </p>
                <p class="bold tw-text-sm">
                    <?= e($campaign['state'] != '' ? $campaign['state'] : '-') ?>
                </p>
                <p class="text-muted campaign-field-heading">
                    <?= _l('campaign_country'); ?>
                </p>
                <p class="bold tw-text-sm">
                    <?= e($campaign['country'] != 0 ? get_country($campaign['country'])->short_name : '-') ?>
                </p>
                <p class="text-muted campaign-field-heading">
                    <?= _l('campaign_zip'); ?>
                </p>
                <p class="bold tw-text-sm">
                    <?= e($campaign['zip'] != '' ? $campaign['zip'] : '-') ?>
                </p>
            </div>
        </div>
    </div>
</li>
<?php }
?>