<?php

defined('BASEPATH') or exit('No direct script access allowed');

class Campaigns_merge_fields extends App_merge_fields
{
    public function build()
    {
        return [
                [
                    'name'      => 'Campaign Name',
                    'key'       => '{campaign_name}',
                    'available' => [
                        'campaigns',
                    ],
                    'templates' => [
                        'gdpr-removal-request-campaign',
                    ],
                ],
                [
                    'name'      => 'Campaign Email',
                    'key'       => '{campaign_email}',
                    'available' => [
                        'campaigns',
                    ],
                     'templates' => [
                        'gdpr-removal-request-campaign',
                    ],
                ],
                [
                    'name'      => 'Campaign Position',
                    'key'       => '{campaign_position}',
                    'available' => [
                        'campaigns',
                    ],
                     'templates' => [
                        'gdpr-removal-request-campaign',
                    ],
                ],
                [
                    'name'      => 'Campaign Website',
                    'key'       => '{campaign_website}',
                    'available' => [
                        'campaigns',
                    ],
                     'templates' => [
                        'gdpr-removal-request-campaign',
                    ],
                ],
                [
                    'name'      => 'Campaign Description',
                    'key'       => '{campaign_description}',
                    'available' => [
                        'campaigns',
                    ],
                ],
                [
                    'name'      => 'Campaign Phone Number',
                    'key'       => '{campaign_phonenumber}',
                    'available' => [
                        'campaigns',
                    ],
                     'templates' => [
                        'gdpr-removal-request-campaign',
                    ],
                ],
                [
                    'name'      => 'Campaign Company',
                    'key'       => '{campaign_company}',
                    'available' => [
                        'campaigns',
                    ],
                     'templates' => [
                        'gdpr-removal-request-campaign',
                    ],
                ],
                [
                    'name'      => 'Campaign Country',
                    'key'       => '{campaign_country}',
                    'available' => [
                        'campaigns',
                    ],
                     'templates' => [
                        'gdpr-removal-request-campaign',
                    ],
                ],
                [
                    'name'      => 'Campaign Zip',
                    'key'       => '{campaign_zip}',
                    'available' => [
                        'campaigns',
                    ],
                ],
                [
                    'name'      => 'Campaign City',
                    'key'       => '{campaign_city}',
                    'available' => [
                        'campaigns',
                    ],
                ],
                [
                    'name'      => 'Campaign State',
                    'key'       => '{campaign_state}',
                    'available' => [
                        'campaigns',
                    ],
                ],
                [
                    'name'      => 'Campaign Address',
                    'key'       => '{campaign_address}',
                    'available' => [
                        'campaigns',
                    ],
                     'templates' => [
                        'gdpr-removal-request-campaign',
                    ],
                ],
                [
                    'name'      => 'Campaign Assigned',
                    'key'       => '{campaign_assigned}',
                    'available' => [
                        'campaigns',
                    ],
                ],
                [
                    'name'      => 'Campaign Status',
                    'key'       => '{campaign_status}',
                    'available' => [
                        'campaigns',
                    ],
                ],
                [
                    'name'      => 'Campaign Souce',
                    'key'       => '{campaign_source}',
                    'available' => [
                        'campaigns',
                    ],
                ],
                [
                    'name'      => 'Campaign Link',
                    'key'       => '{campaign_link}',
                    'available' => [
                        'campaigns',
                    ],
                     'templates' => [
                        'gdpr-removal-request-campaign',
                    ],
                ],
                [
                    'name'      => is_gdpr() && get_option('gdpr_enable_campaign_public_form') == '1' ? 'Campaign Public Form URL' : '',
                    'key'       => is_gdpr() && get_option('gdpr_enable_campaign_public_form') == '1' ? '{campaign_public_form_url}' : '',
                    'available' => [

                    ],
                    'templates' => [
                        'new-web-to-campaign-form-submitted',
                    ],
                ],
                [
                    'name'      => is_gdpr() && get_option('gdpr_enable_consent_for_campaigns') == '1' ? 'Campaign Consent Link' : '',
                    'key'       => is_gdpr() && get_option('gdpr_enable_consent_for_campaigns') == '1' ? '{campaign_public_consent_url}' : '',
                    'available' => [

                    ],
                    'templates' => [
                        'new-web-to-campaign-form-submitted',
                    ],
                ],
            ];
    }

    /**
     * Campaign merge fields
     * @param  mixed $id campaign id
     * @return array
     */
    public function format($id)
    {
        $fields = [];

        $fields['{campaign_name}']               = '';
        $fields['{campaign_email}']              = '';
        $fields['{campaign_position}']           = '';
        $fields['{campaign_company}']            = '';
        $fields['{campaign_country}']            = '';
        $fields['{campaign_zip}']                = '';
        $fields['{campaign_city}']               = '';
        $fields['{campaign_state}']              = '';
        $fields['{campaign_address}']            = '';
        $fields['{campaign_assigned}']           = '';
        $fields['{campaign_status}']             = '';
        $fields['{campaign_source}']             = '';
        $fields['{campaign_phonenumber}']        = '';
        $fields['{campaign_link}']               = '';
        $fields['{campaign_website}']            = '';
        $fields['{campaign_description}']        = '';
        $fields['{campaign_public_form_url}']    = '';
        $fields['{campaign_public_consent_url}'] = '';

        if (is_numeric($id)) {
            $this->ci->db->where('id', $id);
            $campaign = $this->ci->db->get(db_prefix().'campaigns')->row();
        } else {
            $campaign = $id;
        }

        if (!$campaign) {
            return $fields;
        }

        $fields['{campaign_public_form_url}']    = campaigns_public_url($campaign->id);
        $fields['{campaign_public_consent_url}'] = campaign_consent_url($campaign->id);
        $fields['{campaign_link}']               = admin_url('campaigns/index/' . $campaign->id);
        $fields['{campaign_name}']               = e($campaign->name);
        $fields['{campaign_email}']              = e($campaign->email);
        $fields['{campaign_position}']           = e($campaign->title);
        $fields['{campaign_phonenumber}']        = e($campaign->phonenumber);
        $fields['{campaign_company}']            = e($campaign->company);
        $fields['{campaign_zip}']                = e($campaign->zip);
        $fields['{campaign_city}']               = e($campaign->city);
        $fields['{campaign_state}']              = e($campaign->state);
        $fields['{campaign_address}']            = e($campaign->address);
        $fields['{campaign_website}']            = e($campaign->website);
        $fields['{campaign_description}']        = e($campaign->description);

        if ($campaign->assigned != 0) {
            $fields['{campaign_assigned}'] = e(get_staff_full_name($campaign->assigned));
        }

        if ($campaign->country != 0) {
            $country                  = get_country($campaign->country);
            $fields['{campaign_country}'] = e($country->short_name);
        }

        if ($campaign->junk == 1) {
            $fields['{campaign_status}'] = _l('campaign_junk');
        } elseif ($campaign->lost == 1) {
            $fields['{campaign_status}'] = _l('campaign_lost');
        } else {
            $this->ci->db->select('name');
            $this->ci->db->from(db_prefix().'campaigns_status');
            $this->ci->db->where('id', $campaign->status);
            $status = $this->ci->db->get()->row();
            if ($status) {
                $fields['{campaign_status}'] = e($status->name);
            }
        }

        $this->ci->db->select('name');
        $this->ci->db->from(db_prefix().'campaigns_sources');
        $this->ci->db->where('id', $campaign->source);
        $source = $this->ci->db->get()->row();
        if ($source) {
            $fields['{campaign_source}'] = e($source->name);
        }

        $custom_fields = get_custom_fields('campaigns');
        foreach ($custom_fields as $field) {
            $fields['{' . $field['slug'] . '}'] = get_custom_field_value($campaign->id, $field['id'], 'campaigns');
        }

        return hooks()->apply_filters('campaign_merge_fields', $fields, ['id' => $campaign->id, 'campaign' => $campaign]);
    }
}
