<?php defined('BASEPATH') or exit('No direct script access allowed'); ?>

<?php
// Ensure $data is always defined for modal views to prevent undefined variable warning
if (!isset($data)) {
  $data = [];
}
?>

<?php init_head(); ?>
<link rel="stylesheet" href="<?php echo base_url('modules/deals/views/deals.css'); ?>">
<div id="wrapper">
  <div class="content">
    <div class="row">
      <div class="col-md-12">
        <div class="panel_s">
          <div class="panel-body">
            <!-- Header Section -->
            <div class="row">
              <div class="col-md-8">
                <h4 class="tw-m-0"><?php echo html_entity_decode($deal['name']); ?></h4>
                <p class="text-muted tw-mt-1">
                  <?php echo _l('deal_value'); ?>:
                  <?php echo app_format_money((float) $deal['deal_value'], get_base_currency()); ?> |
                  <?php echo _l('expected_close_date'); ?>:
                  <?php echo isset($deal['expected_close_date']) ? _d($deal['expected_close_date']) : '-'; ?>
                </p>
                <p class="text-muted tw-mt-1">
                  <?php echo _l('created_at'); ?>: <?php echo _dt($deal['dateadded'] ?? ''); ?>
                </p>
              </div>
              <div class="col-md-4 text-right">
                <div class="tw-flex tw-gap-2 tw-justify-end">
                  <button type="button" class="btn btn-info btn-xs" onclick="testDatabase()">
                    <i class="fa fa-database"></i> Test DB
                  </button>
                  <?php if ($deal['status_final'] === 'won') { ?>
                    <span class="btn btn-success" style="cursor: default;"><?php echo _l('won'); ?></span>
                  <?php } elseif ($deal['status_final'] === 'lost') { ?>
                    <span class="btn btn-danger" style="cursor: default;"><?php echo _l('lost'); ?></span>
                    <?php if (isset($deal['lost_reason_name']) && $deal['lost_reason_name']) { ?>
                      <span class="btn btn-default"
                        style="cursor: default;"><?php echo html_entity_decode($deal['lost_reason_name']); ?></span>
                    <?php } ?>
                  <?php } else { ?>
                    <button type="button" class="btn btn-success"
                      onclick="markDealWon(<?php echo (int) $deal['id']; ?>)"><?php echo _l('mark_as_won'); ?></button>
                    <button type="button" class="btn btn-danger"
                      onclick="showLostReasonModal()"><?php echo _l('mark_as_lost'); ?></button>
                  <?php } ?>
                </div>
              </div>
            </div>

            <hr class="hr-panel-heading" />

            <!-- Pipeline Stages: Show all pipelines and their stages for this deal -->
            <?php if (!empty($deal_pipelines)) { ?>
              <div class="tw-flex tw-gap-4 tw-flex-wrap tw-mb-4 tw-justify-center">
                <?php foreach ($deal_pipelines as $rel) { 
                  // For each pipeline, show its name and its stages as a row
                  $pipeline = $rel['pipeline'];
                  $pipeline_id = $pipeline['id'];
                  $pipeline_label = $pipeline['label'];
                  $pipeline_stages = $rel['pipeline_stages']; // array of stages for this pipeline
                  $current_stage_id = isset($rel['stage']['id']) ? (int)$rel['stage']['id'] : null;
                  $final = isset($rel['status_final']) ? $rel['status_final'] : $deal['status_final'];
                  $deal_id = (int)$deal['id'];
                ?>
                  <div class="modern-card" style="padding:16px 20px; min-width:320px;">
                    <div class="tw-mb-2 tw-flex tw-items-center tw-gap-2">
                      <span class="label label-default"><?php echo e($pipeline_label); ?></span>
                      <span><?php echo _l('stage'); ?>: <strong><?php echo e($rel['stage']['label']); ?></strong></span>
                      <?php if ($rel['score'] !== null) { ?>
                        <span class="tw-ml-2"><?php echo _l('score'); ?>: <strong><?php echo (int)$rel['score']; ?></strong></span>
                      <?php } ?>
                    </div>
                    <div class="tw-flex tw-gap-2 tw-flex-wrap tw-justify-center">
                      <?php
                        $stageCount = count($pipeline_stages);
                        $currentIndex = -1;
                        foreach ($pipeline_stages as $idx => $s) {
                          if ((int)$s['id'] === $current_stage_id) {
                            $currentIndex = $idx;
                            break;
                          }
                        }
                        foreach ($pipeline_stages as $index => $stage) {
                          $stageId = (int)$stage['id'];
                          if ($final === 'won') {
                            $bg = '#84c529';
                          } elseif ($final === 'lost') {
                            $bg = '#fc2d42';
                          } else {
                            if ($index < $currentIndex) {
                              $bg = '#84c529';
                            } elseif ($index === $currentIndex) {
                              $bg = '#FFD600';
                            } else {
                              $bg = '#e3e3e3';
                            }
                          }
                          ?>
                          <div class="tw-flex tw-items-center">
                            <button type="button" class="btn"
                              style="background: <?php echo $bg; ?>; color:#fff; border-radius: 50%; width: 40px; height: 40px; padding: 0; font-size: 16px;"
                              onclick="setDealStagePipeline(<?php echo $deal_id; ?>, <?php echo $pipeline_id; ?>, <?php echo $stageId; ?>)" <?php echo ($final === 'won' || $final === 'lost') ? 'disabled' : ''; ?>>
                              <?php
                              if ($final === 'won' || $final === 'lost') {
                                echo '<i class="fa fa-check"></i>';
                              } else {
                                if ($index < $currentIndex) {
                                  echo '<i class="fa fa-check"></i>';
                                } elseif ($index === $currentIndex) {
                                  echo '<i class="fa fa-exclamation"></i>';
                                } else {
                                  echo ($index + 1);
                                }
                              }
                              ?>
                            </button>
                            <span class="tw-mx-2 tw-text-sm tw-font-medium"><?php echo html_entity_decode($stage['name']); ?></span>
                            <?php if ($index < $stageCount - 1) { ?>
                              <i class="fa fa-arrow-right tw-mx-2 tw-text-gray-400"></i>
                            <?php } ?>
                          </div>
                        <?php } ?>
                    </div>
                  </div>
                <?php } ?>
              </div>
            <?php } ?>

            <!-- Main Content: Left Sidebar (33%) and Right Content (66%) -->
            <div class="row">
              <!-- Left Sidebar - Details, Contacts, Companies, Attachments -->
              <div class="col-md-4">
                <!-- Details Card -->
                <div class="modern-card">
                  <div class="modern-card-header">
                    <h5 class="modern-card-title"><?php echo _l('details'); ?></h5>
                  </div>
                  <div class="modern-card-body">
                    <div class="form-group deal-value-group" style="position:relative;">
                      <label class="tw-font-medium"><?php echo _l('deal_value'); ?></label>
                      <p class="tw-text-lg tw-font-bold tw-text-green-600 deal-value-display"
                        style="margin-bottom:0; display:inline-block;">
                        <?php echo app_format_money((float) $deal['deal_value'], get_base_currency()); ?>
                        <button class="btn btn-xs btn-default tw-ml-2 edit-amount-btn"
                          style="display:none; position:relative; top:-2px;" onclick="editDealAmount()">
                          <i class="fa fa-edit"></i>
                        </button>
                      </p>
                      <form id="edit-amount-form" style="display:none; margin-top:8px;">
                        <div class="input-group input-group-sm" style="max-width:180px;">
                          <input type="number" step="0.01" min="0" class="form-control" id="edit-amount-input"
                            value="<?php echo (float) $deal['deal_value']; ?>">
                          <span class="input-group-btn">
                            <button class="btn btn-success" type="submit"><i class="fa fa-check"></i></button>
                            <button class="btn btn-default" type="button" onclick="cancelEditAmount()"><i
                                class="fa fa-times"></i></button>
                          </span>
                        </div>
                      </form>
                    </div>
                    <div class="form-group close-date-group" style="position:relative;">
                      <label class="tw-font-medium"><?php echo _l('expected_close_date'); ?></label>
                      <p class="tw-text-gray-700 close-date-display" style="margin-bottom:0; display:inline-block;">
                        <?php echo isset($deal['expected_close_date']) ? _d($deal['expected_close_date']) : '-'; ?>
                        <button class="btn btn-xs btn-default tw-ml-2 edit-close-date-btn"
                          style="display:none; position:relative; top:-2px;" onclick="editCloseDate()">
                          <i class="fa fa-edit"></i>
                        </button>
                      </p>
                      <form id="edit-close-date-form" style="display:none; margin-top:8px;">
                        <div class="input-group input-group-sm" style="max-width:180px;">
                          <input type="date" class="form-control" id="edit-close-date-input"
                            value="<?php echo isset($deal['expected_close_date']) ? date('Y-m-d', strtotime($deal['expected_close_date'])) : ''; ?>">
                          <span class="input-group-btn">
                            <button class="btn btn-success" type="submit"><i class="fa fa-check"></i></button>
                            <button class="btn btn-default" type="button" onclick="cancelEditCloseDate()"><i
                                class="fa fa-times"></i></button>
                          </span>
                        </div>
                      </form>
                    </div>
                  </div>
                </div>

                <!-- Contacts Card -->
                <div class="modern-card">
                  <div class="modern-card-header">
                    <h5 class="modern-card-title">
                      <?php echo _l('contacts'); ?>
                      <button class="btn btn-xs btn-primary pull-right" onclick="addContact()">
                        <i class="fa fa-plus"></i>
                      </button>
                    </h5>
                  </div>
                  <div class="modern-card-body">
                    <div id="contacts-list">
                      <div class="text-muted text-center tw-py-4">
                        <i class="fa fa-users fa-2x tw-mb-2"></i>
                        <p><?php echo _l('no_contacts_found'); ?></p>
                      </div>
                    </div>
                  </div>
                </div>

                <!-- Companies Card -->
                <div class="modern-card">
                  <div class="modern-card-header">
                    <h5 class="modern-card-title">
                      <?php echo _l('companies'); ?> <span id="companies-count">(0)</span>
                      <button class="btn btn-xs btn-primary pull-right" onclick="addCompany()">
                        <i class="fa fa-plus"></i>
                      </button>
                    </h5>
                  </div>
                  <div class="modern-card-body">
                    <div id="companies-list">
                      <div class="text-muted text-center tw-py-4">
                        <i class="fa fa-building fa-2x tw-mb-2"></i>
                        <p><?php echo _l('no_company_associated'); ?></p>
                      </div>
                    </div>
                  </div>
                </div>

                <!-- Attachments Card -->
                <div class="modern-card">
                  <div class="modern-card-header">
                    <h5 class="modern-card-title">
                      <?php echo _l('attachments'); ?>
                      <button class="btn btn-xs btn-primary pull-right" onclick="addAttachment()">
                        <i class="fa fa-plus"></i>
                      </button>
                    </h5>
                  </div>
                  <div class="modern-card-body">
                    <div id="attachments-list">
                      <div class="text-muted text-center tw-py-4">
                        <i class="fa fa-paperclip fa-2x tw-mb-2"></i>
                        <p><?php echo _l('no_attachments_uploaded'); ?></p>
                      </div>
                    </div>
                  </div>
                </div>
              </div>

              <!-- Right Side - Activities -->
              <div class="col-md-8">
                <div class="modern-card">
                  <div class="modern-card-header">
                    <h5 class="modern-card-title"><?php echo _l('activities'); ?></h5>
                  </div>
                  <div class="modern-card-body">
                    <!-- Activity Tabs -->
                    <div class="nav-tabs-scroll-wrapper">
                      <ul class="nav nav-tabs" role="tablist" style="width:auto;min-width:100%;">
                        <li role="presentation">
                          <a href="#tab_deal_proposals" aria-controls="tab_deal_proposals" role="tab" data-toggle="tab"
                            onclick="loadDealProposals(<?php echo $deal['id']; ?>)">
                            <i class="fa-regular fa-file-lines menu-icon"></i>
                            <?php echo _l('proposals'); ?>
                            <?php if ($total_proposals > 0) { ?>
                              <span class="badge"><?php echo $total_proposals; ?></span>
                            <?php } ?>
                          </a>
                        </li>
                        <li role="presentation">
                          <a href="#tab_deal_tasks" aria-controls="tab_deal_tasks" role="tab" data-toggle="tab"
                            onclick="loadDealTasks(<?php echo $deal['id']; ?>)">
                            <i class="fa-regular fa-circle-check menu-icon"></i>
                            <?php echo _l('tasks'); ?>
                            <?php if ($total_tasks > 0) { ?>
                              <span class="badge"><?php echo $total_tasks; ?></span>
                            <?php } ?>
                          </a>
                        </li>
                        <li role="presentation">
                          <a href="#tab_deal_attachments" aria-controls="tab_deal_attachments" role="tab"
                            data-toggle="tab" onclick="loadDealAttachments(<?php echo $deal['id']; ?>)">
                            <i class="fa-solid fa-paperclip menu-icon"></i>
                            <?php echo _l('attachments'); ?>
                            <?php if ($total_attachments > 0) { ?>
                              <span class="badge"><?php echo $total_attachments; ?></span>
                            <?php } ?>
                          </a>
                        </li>
                        <li role="presentation">
                          <a href="#tab_deal_reminders" aria-controls="tab_deal_reminders" role="tab" data-toggle="tab"
                            onclick="loadDealReminders(<?php echo $deal['id']; ?>)">
                            <i class="fa-regular fa-bell menu-icon"></i>
                            <?php echo _l('reminders'); ?>
                            <?php if ($total_reminders > 0) { ?>
                              <span class="badge"><?php echo $total_reminders; ?></span>
                            <?php } ?>
                          </a>
                        </li>
                        <li role="presentation">
                          <a href="#tab_deal_notes" aria-controls="tab_deal_notes" role="tab" data-toggle="tab"
                            onclick="loadDealNotes(<?php echo $deal['id']; ?>)">
                            <i class="fa-regular fa-note-sticky menu-icon"></i>
                            <?php echo _l('notes'); ?>
                            <?php if ($total_notes > 0) { ?>
                              <span class="badge"><?php echo $total_notes; ?></span>
                            <?php } ?>
                          </a>
                        </li>
                        <li role="presentation">
                          <a href="#tab_deal_activity" aria-controls="tab_deal_activity" role="tab" data-toggle="tab"
                            onclick="loadDealActivities(<?php echo $deal['id']; ?>)">
                            <i class="fa-solid fa-grip-lines-vertical menu-icon"></i>
                            <?php echo _l('activity_log'); ?>
                            <?php if ($total_activities > 0) { ?>
                              <span class="badge"><?php echo $total_activities; ?></span>
                            <?php } ?>
                          </a>
                        </li>
                        <li role="presentation">
                          <a href="#tab_deal_emails" aria-controls="tab_deal_emails" role="tab" data-toggle="tab"
                            onclick="loadDealEmails(<?php echo $deal['id']; ?>)">
                            <i class="fa-regular fa-envelope menu-icon"></i>
                            <?php echo _l('emails'); ?>
                            <?php if ($total_emails > 0) { ?>
                              <span class="badge"><?php echo $total_emails; ?></span>
                            <?php } ?>
                          </a>
                        </li>
                        <li role="presentation">
                          <a href="#tab_deal_calls" aria-controls="tab_deal_calls" role="tab" data-toggle="tab"
                            onclick="loadDealCalls(<?php echo $deal['id']; ?>)">
                            <i class="fa-solid fa-phone menu-icon"></i>
                            <?php echo _l('calls'); ?>
                            <?php if ($total_calls > 0) { ?>
                              <span class="badge"><?php echo $total_calls; ?></span>
                            <?php } ?>
                          </a>
                        </li>
                      </ul>
                    </div>

                    <!-- Tab Content -->
                    <div class="tab-content tw-mt-3">
                      <!-- Proposals Tab -->
                      <div role="tabpanel" class="tab-pane" id="tab_deal_proposals">
                        <div class="tw-flex tw-justify-between tw-mb-3">
                          <h6><?php echo _l('proposals'); ?></h6>
                          <button class="btn btn-primary btn-sm"
                            onclick="openNewProposalModal(<?php echo $deal['id']; ?>)">
                            <i class="fa fa-plus"></i> <?php echo _l('new_proposal'); ?>
                          </button>
                        </div>
                        <div id="proposals-content">
                          <div class="text-center tw-py-4">
                            <i class="fa fa-spinner fa-spin"></i> <?php echo _l('loading'); ?>...
                          </div>
                        </div>
                      </div>

                      <!-- Tasks Tab -->
                      <div role="tabpanel" class="tab-pane" id="tab_deal_tasks">
                        <div class="tw-flex tw-justify-between tw-mb-3">
                          <h6><?php echo _l('tasks'); ?></h6>
                          <button class="btn btn-primary btn-sm" onclick="openNewTaskModal(<?php echo $deal['id']; ?>)">
                            <i class="fa fa-plus"></i> <?php echo _l('new_task'); ?>
                          </button>
                        </div>
                        <div id="tasks-content">
                          <div class="text-center tw-py-4">
                            <i class="fa fa-spinner fa-spin"></i> <?php echo _l('loading'); ?>...
                          </div>
                        </div>
                      </div>

                      <!-- Attachments Tab -->
                      <div role="tabpanel" class="tab-pane" id="tab_deal_attachments">
                        <div class="tw-flex tw-justify-between tw-mb-3">
                          <h6><?php echo _l('attachments'); ?></h6>
                          <button class="btn btn-primary btn-sm"
                            onclick="openAddAttachmentModal(<?php echo $deal['id']; ?>)">
                            <i class="fa fa-plus"></i> <?php echo _l('add_attachment'); ?>
                          </button>
                        </div>
                        <div id="attachments-content">
                          <div class="text-center tw-py-4">
                            <i class="fa fa-spinner fa-spin"></i> <?php echo _l('loading'); ?>...
                          </div>
                        </div>
                      </div>

                      <!-- Reminders Tab -->
                      <div role="tabpanel" class="tab-pane" id="tab_deal_reminders">
                        <div class="tw-flex tw-justify-between tw-mb-3">
                          <h6><?php echo _l('reminders'); ?></h6>
                          <button class="btn btn-primary btn-sm"
                            onclick="openNewReminderModal(<?php echo $deal['id']; ?>)">
                            <i class="fa fa-plus"></i> <?php echo _l('new_reminder'); ?>
                          </button>
                        </div>
                        <div id="reminders-content">
                          <div class="text-center tw-py-4">
                            <i class="fa fa-spinner fa-spin"></i> <?php echo _l('loading'); ?>...
                          </div>
                        </div>
                      </div>

                      <!-- Notes Tab -->
                      <div role="tabpanel" class="tab-pane" id="tab_deal_notes">
                        <div class="tw-flex tw-justify-between tw-mb-3">
                          <h6><?php echo _l('notes'); ?></h6>
                          <button class="btn btn-primary btn-sm" onclick="openNewNoteModal(<?php echo $deal['id']; ?>)">
                            <i class="fa fa-plus"></i> <?php echo _l('new_note'); ?>
                          </button>
                        </div>
                        <div id="notes-content">
                          <div class="text-center tw-py-4">
                            <i class="fa fa-spinner fa-spin"></i> <?php echo _l('loading'); ?>...
                          </div>
                        </div>
                      </div>

                      <!-- Activity Log Tab -->
                      <div role="tabpanel" class="tab-pane" id="tab_deal_activity">
                        <div class="tw-flex tw-justify-between tw-mb-3">
                          <h6><?php echo _l('activity_log'); ?></h6>
                          <button class="btn btn-primary btn-sm"
                            onclick="openNewActivityModal(<?php echo $deal['id']; ?>)">
                            <i class="fa fa-plus"></i> <?php echo _l('add_activity'); ?>
                          </button>
                        </div>
                        <div id="activity-content">
                          <div class="text-center tw-py-4">
                            <i class="fa fa-spinner fa-spin"></i> <?php echo _l('loading'); ?>...
                          </div>
                        </div>
                      </div>

                      <!-- Emails Tab -->
                      <div role="tabpanel" class="tab-pane" id="tab_deal_emails">
                        <div class="tw-flex tw-justify-between tw-mb-3">
                          <h6><?php echo _l('emails'); ?></h6>
                          <button class="btn btn-primary btn-sm"
                            onclick="openNewEmailModal(<?php echo $deal['id']; ?>)">
                            <i class="fa fa-plus"></i> <?php echo _l('new_email'); ?>
                          </button>
                        </div>
                        <div id="emails-content">
                          <div class="text-center tw-py-4">
                            <i class="fa fa-spinner fa-spin"></i> <?php echo _l('loading'); ?>...
                          </div>
                        </div>
                      </div>

                      <!-- Calls Tab -->
                      <div role="tabpanel" class="tab-pane" id="tab_deal_calls">
                        <div class="tw-flex tw-justify-between tw-mb-3">
                          <h6><?php echo _l('calls'); ?></h6>
                          <button class="btn btn-primary btn-sm" onclick="openNewCallModal(<?php echo $deal['id']; ?>)">
                            <i class="fa fa-plus"></i> <?php echo _l('log_call'); ?>
                          </button>
                        </div>
                        <div id="calls-content">
                          <div class="text-center tw-py-4">
                            <i class="fa fa-spinner fa-spin"></i> <?php echo _l('loading'); ?>...
                          </div>
                        </div>
                      </div>

                    </div>
                  </div>
                </div>
              </div>
            </div>

          </div>
        </div>
      </div>
    </div>
  </div>
</div>

<!-- Lost Reason Modal -->
<div class="modal fade" id="lostReasonModal" tabindex="-1" role="dialog">
  <div class="modal-dialog" role="document">
    <div class="modal-content">
      <div class="modal-header">
        <button type="button" class="close" data-dismiss="modal"><span>&times;</span></button>
        <h4 class="modal-title"><?php echo _l('mark_as_lost'); ?></h4>
      </div>
      <div class="modal-body">
        <div class="form-group">
          <label><?php echo _l('lost_reason'); ?></label>
          <select id="lost-reason-select" class="form-control" required>
            <option value="">-- <?php echo _l('select_lost_reason'); ?> --</option>
            <?php foreach (($lost_reasons ?? []) as $r) { ?>
              <option value="<?php echo (int) $r['id']; ?>"><?php echo html_entity_decode($r['name']); ?></option>
            <?php } ?>
          </select>
        </div>
      </div>
      <div class="modal-footer">
        <button type="button" class="btn btn-default" data-dismiss="modal"><?php echo _l('cancel'); ?></button>
        <button type="button" class="btn btn-danger"
          onclick="markDealLost(<?php echo (int) $deal['id']; ?>)"><?php echo _l('mark_as_lost'); ?></button>
      </div>
    </div>
  </div>
</div>

<!-- Contact Modal -->
<div class="modal fade" id="contactModal" tabindex="-1" role="dialog">
  <div class="modal-dialog" role="document">
    <div class="modal-content">
      <div class="modal-header">
        <button type="button" class="close" data-dismiss="modal"><span>&times;</span></button>
        <h4 class="modal-title" id="contactModalTitle"><?php echo _l('add_contact'); ?></h4>
      </div>
      <div class="modal-body">
        <ul class="nav nav-tabs" role="tablist">
          <li role="presentation" class="active">
            <a href="#select-contact" aria-controls="select-contact" role="tab"
              data-toggle="tab"><?php echo _l('select_existing'); ?></a>
          </li>
          <li role="presentation">
            <a href="#create-contact" aria-controls="create-contact" role="tab"
              data-toggle="tab"><?php echo _l('create_new'); ?></a>
          </li>
        </ul>

        <div class="tab-content tw-mt-3">
          <div role="tabpanel" class="tab-pane active" id="select-contact">
            <div class="form-group">
              <label><?php echo _l('select_contact'); ?></label>
              <select class="form-control" id="existing-contact-select">
                <option value=""><?php echo _l('select_contact'); ?></option>
              </select>
            </div>
          </div>

          <div role="tabpanel" class="tab-pane" id="create-contact">
            <div class="form-group">
              <label><?php echo _l('firstname'); ?></label>
              <input type="text" id="contact-firstname" class="form-control" required>
            </div>
            <div class="form-group">
              <label><?php echo _l('lastname'); ?></label>
              <input type="text" id="contact-lastname" class="form-control" required>
            </div>
            <div class="form-group">
              <label><?php echo _l('email'); ?></label>
              <input type="email" id="contact-email" class="form-control" required>
            </div>
            <div class="form-group">
              <label><?php echo _l('phonenumber'); ?></label>
              <input type="text" id="contact-phonenumber" class="form-control">
            </div>
          </div>
        </div>
      </div>
      <div class="modal-footer">
        <button type="button" class="btn btn-default" data-dismiss="modal"><?php echo _l('close'); ?></button>
        <button type="button" class="btn btn-primary" onclick="saveContact()"><?php echo _l('save'); ?></button>
      </div>
    </div>
  </div>
</div>

<!-- Company Modal -->
<div class="modal fade" id="companyModal" tabindex="-1" role="dialog">
  <div class="modal-dialog" role="document">
    <div class="modal-content">
      <div class="modal-header">
        <button type="button" class="close" data-dismiss="modal"><span>&times;</span></button>
        <h4 class="modal-title" id="companyModalTitle"><?php echo _l('add_company'); ?></h4>
      </div>
      <div class="modal-body">
        <ul class="nav nav-tabs" role="tablist">
          <li role="presentation" class="active">
            <a href="#select-company" aria-controls="select-company" role="tab"
              data-toggle="tab"><?php echo _l('select_existing'); ?></a>
          </li>
          <li role="presentation">
            <a href="#create-company" aria-controls="create-company" role="tab"
              data-toggle="tab"><?php echo _l('create_new'); ?></a>
          </li>
        </ul>

        <div class="tab-content tw-mt-3">
          <div role="tabpanel" class="tab-pane active" id="select-company">
            <div class="form-group">
              <label><?php echo _l('select_company'); ?></label>
              <select class="form-control" id="existing-company-select">
                <option value=""><?php echo _l('select_company'); ?></option>
              </select>
            </div>
          </div>

          <div role="tabpanel" class="tab-pane" id="create-company">
            <div class="form-group">
              <label><?php echo _l('company_name'); ?></label>
              <input type="text" id="company-name" class="form-control" required>
            </div>
            <div class="form-group">
              <label><?php echo _l('company_email'); ?></label>
              <input type="email" id="company-email" class="form-control">
            </div>
            <div class="form-group">
              <label><?php echo _l('company_phone'); ?></label>
              <input type="text" id="company-phone" class="form-control">
            </div>
            <div class="form-group">
              <label><?php echo _l('company_website'); ?></label>
              <input type="url" id="company-website" class="form-control">
            </div>
            <div class="form-group">
              <label><?php echo _l('company_address'); ?></label>
              <textarea id="company-address" class="form-control" rows="3"></textarea>
            </div>
          </div>
        </div>
      </div>
      <div class="modal-footer">
        <button type="button" class="btn btn-default" data-dismiss="modal"><?php echo _l('close'); ?></button>
        <button type="button" class="btn btn-primary" onclick="saveCompany()"><?php echo _l('save'); ?></button>
      </div>
    </div>
  </div>
</div>

<!-- Attachment Modal -->
<div class="modal fade" id="attachmentModal" tabindex="-1" role="dialog">
  <div class="modal-dialog" role="document">
    <div class="modal-content">
      <div class="modal-header">
        <button type="button" class="close" data-dismiss="modal"><span>&times;</span></button>
        <h4 class="modal-title"><?php echo _l('add_attachment'); ?></h4>
      </div>
      <div class="modal-body">
        <div class="form-group">
          <label><?php echo _l('file'); ?></label>
          <input type="file" id="attachment-file" class="form-control" required>
        </div>
        <div class="form-group">
          <label><?php echo _l('description'); ?></label>
          <textarea id="attachment-description" class="form-control" rows="3"></textarea>
        </div>
      </div>
      <div class="modal-footer">
        <button type="button" class="btn btn-default" data-dismiss="modal"><?php echo _l('close'); ?></button>
        <button type="button" class="btn btn-primary" onclick="saveAttachment()"><?php echo _l('save'); ?></button>
      </div>
    </div>
  </div>
</div>

<!-- Preview Modal -->
<div class="modal fade" id="previewModal" tabindex="-1" role="dialog">
  <div class="modal-dialog modal-lg" role="document">
    <div class="modal-content">
      <div class="modal-header">
        <button type="button" class="close" data-dismiss="modal"><span>&times;</span></button>
        <h4 class="modal-title">Preview</h4>
      </div>
      <div class="modal-body">
        <div id="preview-content"></div>
      </div>
      <div class="modal-footer">
        <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
      </div>
    </div>
  </div>
</div>

<?php init_tail(); ?>

<script>
  var dealId = <?php echo (int) $deal['id']; ?>;
  var CSRF = {
    name: '<?php echo $this->security->get_csrf_token_name(); ?>',
    value: '<?php echo $this->security->get_csrf_hash(); ?>'
  };

  var staffMap = {};

  $(function () {
    loadContacts(); loadCompanies(); loadAttachments(); loadActivities();
    loadAvailableContacts(); loadAvailableCompanies(); loadStaff();

    $('#activities-search').on('keyup', function () {
      var val = $(this).val().toLowerCase();
      $('#activities-only-list .timeline-item').filter(function () {
        $(this).toggle($(this).text().toLowerCase().indexOf(val) > -1);
      });
    });
    $('#calls-search').on('keyup', function () {
      var val = $(this).val().toLowerCase();
      $('#calls-list .timeline-item').filter(function () {
        $(this).toggle($(this).text().toLowerCase().indexOf(val) > -1);
      });
    });
    $('#notes-search').on('keyup', function () {
      var val = $(this).val().toLowerCase();
      $('#notes-list .timeline-item').filter(function () {
        $(this).toggle($(this).text().toLowerCase().indexOf(val) > -1);
      });
    });

    $('#activity-filter').on('change', filterActivities);
    $('a[data-toggle="tab"]').on('shown.bs.tab', placeTimelineDots);
  });

  function parseIfString(response) {
    if (typeof response === 'string') {
      try {
        return JSON.parse(response);
      } catch (e) {
        return { __parseError: true, error: e, raw: response };
      }
    }
    return response;
  }

  function getActivityIconData(type) {
    // Use only one definition, prefer the one with more types and consistent with your payload
    switch (type) {
      case 'calls':
      case 'call':
        return { icon: 'fa-phone', bg: '#10b981', color: '#fff' };
      case 'emails':
        return { icon: 'fa-envelope', bg: '#6366f1', color: '#fff' };
      case 'notes':
      case 'note':
        return { icon: 'fa-sticky-note-o', bg: '#f59e42', color: '#fff' };
      case 'documents':
        return { icon: 'fa-file-text-o', bg: '#fbbf24', color: '#fff' };
      case 'stage':
        return { icon: 'fa-arrow-right', bg: '#3b82f6', color: '#fff' };
      case 'status':
        return { icon: 'fa-check-circle', bg: '#84c529', color: '#fff' };
      case 'contact':
        return { icon: 'fa-user-plus', bg: '#10b981', color: '#fff' };
      case 'company':
        return { icon: 'fa-building', bg: '#6366f1', color: '#fff' };
      case 'attachment':
        return { icon: 'fa-paperclip', bg: '#f59e42', color: '#fff' };
      default:
        return { icon: 'fa-clock-o', bg: '#6b7280', color: '#fff' };
    }
  }

  function getActivityBadge(type) {
    switch (type) {
      case 'calls': return 'call';
      case 'emails': return 'email';
      case 'notes': return 'note';
      case 'documents': return 'document';
      case 'stage': return 'stage';
      case 'status': return 'status';
      default: return 'activity';
    }
  }
  function isRowType(type) { return ['stage', 'status', 'contact', 'company', 'attachment', 'emails', 'documents'].indexOf(type || '') !== -1; }
  function isCardType(type) { return ['activities', 'activity', 'notes', 'note', 'calls', 'call'].indexOf(type || '') !== -1; }

  function loadStaff() {
    $.get(admin_url + 'deals/get_staff_ajax', function (res) {
      res = parseIfString(res);
      if (res.success && res.staff) {
        res.staff.forEach(function (s) {
          $('#activity-owner').append('<option value="' + s.staffid + '">' + s.firstname + ' ' + s.lastname + '</option>');
          $('#activity-guests').append('<option value="' + s.staffid + '">' + s.firstname + ' ' + s.lastname + '</option>');
        });
      }
    });
  }

  function cancelActivity() {
    $('#activities-add-form').hide();
    $('#activities-controls').show();
  }

  function cancelCall() {
    $('#calls-add-form').hide();
    $('#calls-controls').show();
  }

  function cancelNote() {
    $('#notes-add-form').hide();
    $('#notes-controls').show();
    $('#add-note-btn').show();
  }

  // Only one saveActivity, saveCall, saveNote function, matching your backend payload
  function saveActivity() {
    var title = $('#activity-title').val() ? $('#activity-title').val().trim() : '';
    if (!title) {
      alert('Title is required');
      return;
    }
    var formData = new FormData();
    formData.append(CSRF.name, CSRF.value);
    formData.append('title', title);
    formData.append('activity_date', $('#activity-date').val());
    formData.append('description', $('#activity-description').val());
    formData.append('status', $('#activity-completed').prop('checked') ? 'completed' : 'pending');
    formData.append('owner_id', $('#activity-owner').val());
    formData.append('guests', JSON.stringify($('#activity-guests').val() || []));
    // Reminder calculation
    var num = parseInt($('#reminder-num').val() || 0);
    var unit = $('#reminder-unit').val();
    var when = $('#reminder-when').val();
    var factor = unit === 'minutes' ? 60 : unit === 'hours' ? 3600 : 86400;
    var seconds = num * factor;
    if (when === 'after due') seconds = -seconds;
    formData.append('reminder', seconds);

    $.ajax({
      url: admin_url + 'deals/add_activity/' + dealId,
      type: 'POST',
      data: formData,
      processData: false,
      contentType: false,
      success: function (response) {
        response = parseIfString(response);
        if (response.success) {
          cancelActivity();
          loadActivities();
        } else {
          alert('Error adding activity');
        }
      }
    });
  }


  function saveNote() {
    var description = $('#note-description').val() ? $('#note-description').val().trim() : '';
    if (!description) {
      alert('Description is required');
      return;
    }
    var formData = new FormData();
    formData.append(CSRF.name, CSRF.value);
    formData.append('description', description);

    $.ajax({
      url: admin_url + 'deals/add_note/' + dealId,
      type: 'POST',
      data: formData,
      processData: false,
      contentType: false,
      success: function (response) {
        response = parseIfString(response);
        if (response.success) {
          cancelNote();
          loadActivities();
        } else {
          alert('Error adding note');
        }
      }
    });
  }

  function toggleActivityStatus(id, checked) {
    var formData = new FormData();
    formData.append(CSRF.name, CSRF.value);
    formData.append('status', checked ? 'completed' : 'pending');

    $.ajax({
      url: admin_url + 'deals/update_activity_status/' + id,
      type: 'POST',
      data: formData,
      processData: false,
      contentType: false,
      success: function (response) {
        response = parseIfString(response);
        if (response.success) {
          loadActivities();
        }
      }
    });
  }

  function filterActivitiesByPeriod(period) {
    var now = moment();
    $('#activities-only-list .activity-card').show();
    if (period !== 'all') {
      $('#activities-only-list .activity-card').hide();
      $('#activities-only-list .activity-card').filter(function () {
        var date = $(this).data('date');
        var status = $(this).data('status');
        if (period === 'done') return status === 'completed';
        if (!date) return false;
        var mDate = moment(date);
        if (period === 'today') return mDate.isSame(now, 'day');
        if (period === 'tomorrow') return mDate.isSame(now.clone().add(1, 'day'), 'day');
        if (period === 'this_week') return mDate.isSame(now, 'week');
        if (period === 'next_week') return mDate.isSame(now.clone().add(1, 'week'), 'week');
      }).show();
    }
  }

  function loadActivities() {
    $.get(admin_url + 'deals/get_deal_activities/' + dealId, function (response) {
      response = parseIfString(response);
      if (response.__parseError) {
        var errorHtml = '<div class="text-danger text-center tw-py-4"><i class="fa fa-exclamation-triangle fa-2x tw-mb-2"></i><p>Error parsing activities response</p></div>';
        $('#activities-list,#activities-only-list,#emails-list,#documents-list,#calls-list,#notes-list').html(errorHtml);
        return;
      }
      if (!(response.success && response.activities && response.activities.length)) {
        var noHtml = '<div class="text-muted text-center tw-py-4"><p><?php echo _l("no_activity_found"); ?></p></div>';
        $('#activities-list,#activities-only-list').html(noHtml);
        $('#emails-list').html('<div class="text-muted text-center tw-py-4"><p><?php echo _l("no_emails_found"); ?></p></div>');
        $('#documents-list').html('<div class="text-muted text-center tw-py-4"><p><?php echo _l("no_documents_found"); ?></p></div>');
        $('#calls-list').html('<div class="text-muted text-center tw-py-4"><p><?php echo _l("no_calls_found"); ?></p></div>');
        $('#notes-list').html('<div class="text-muted text-center tw-py-4"><p><?php echo _l("no_notes_found"); ?></p></div>');
        $('#badge-activities,#badge-emails,#badge-documents,#badge-calls,#badge-notes').text('0');
        return;
      }

      var htmlAll = '', htmlActivitiesOnly = '', htmlEmails = '', htmlDocuments = '', htmlCalls = '', htmlNotes = '';
      var countActivities = 0, countEmails = 0, countDocuments = 0, countCalls = 0, countNotes = 0;

      response.activities.forEach(function (a) {
        var t = a.type || 'activity';
        var icon = getActivityIconData(t);
        var badge = getActivityBadge(t);

        function renderRow() {
          var row = '';
          row += '<div class="timeline-item timeline-row" data-type="' + t + '" data-icon="' + icon.icon + '" data-icon-bg="' + icon.bg + '" data-icon-color="' + icon.color + '">';
          row += '<span class="dot"></span>';
          row += '<p class="timeline-row-text">' + (a.description || '—') + ' <span class="timeline-row-meta">-  ' + (a.full_name || '—') + ' -  ' + (a.date ? moment(a.date).format('MMM DD, YYYY HH:mm') : '—') + '</span></p>';
          row += '</div>';
          return row;
        }
        function renderCard() {
          var card = '';
          card += '<div class="timeline-item timeline-card" data-type="' + t + '" data-icon="' + icon.icon + '" data-icon-bg="' + icon.bg + '" data-icon-color="' + icon.color + '">';
          card += '<span class="dot"></span>';
          card += '<div class="timeline-content">';
          card += '<div class="timeline-header">';
          card += '<div class="timeline-info">';
          card += '<h6 class="timeline-title">' + (a.title || a.description || 'No description') + '</h6>';
          card += '<p class="timeline-meta"><i class="fa fa-user"></i> ' + (a.full_name || 'Unknown user') + ' <span class="meta-sep">&bull;</span> <i class="fa fa-calendar"></i> ' + (a.date ? moment(a.date).format('MMM DD, YYYY HH:mm') : 'Unknown date') + '</p>';
          card += '</div>';
          card += '<span class="activity-badge ' + badge + '">' + (t || 'activity') + '</span>';
          card += '</div>';
          if (a.additional_data) {
            try {
              var addData = typeof a.additional_data === 'string' ? JSON.parse(a.additional_data) : a.additional_data;
              var desc = '';
              if (addData.outcome !== undefined) {
                desc += '<div><strong>Outcome:</strong> ' + (addData.outcome ? addData.outcome : '-') + '</div>';
              }
              if (addData.date !== undefined) {
                // Format date to DD-MM-YYYY (Indian format)
                var dateVal = addData.date;
                var formattedDate = '-';
                if (dateVal) {
                  var d = new Date(dateVal);
                  if (!isNaN(d.getTime())) {
                    var day = ('0' + d.getDate()).slice(-2);
                    var month = ('0' + (d.getMonth() + 1)).slice(-2);
                    var year = d.getFullYear();
                    formattedDate = day + '-' + month + '-' + year;
                  } else if (typeof dateVal === 'string' && dateVal.length >= 10) {
                    // fallback: try to parse as YYYY-MM-DD or YYYYMMDD
                    var m = dateVal.match(/^(\d{4})-?(\d{2})-?(\d{2})/);
                    if (m) {
                      formattedDate = m[3] + '-' + m[2] + '-' + m[1];
                    } else {
                      formattedDate = dateVal;
                    }
                  }
                }
                desc += '<div><strong>Date:</strong> ' + formattedDate + '</div>';
              }
              if (addData.notes !== undefined) {
                desc += '<div><strong>Notes:</strong> ' + (addData.notes ? addData.notes : '-') + '</div>';
              }
              card += '<div class="timeline-description">' + desc + '</div>';
            } catch (e) {
              card += '<div class="timeline-description">' + a.additional_data + '</div>';
            }
          }
          if (t === 'activity' || t === 'activities') {
            // card += '<div class="tw-mt-2"><label class="tw-text-xs"><input type="checkbox" ' + ((a.status === 'completed') ? 'checked' : '') + ' onchange="toggleActivityStatus(' + a.id + ', this.checked)"> Completed</label></div>';
          }
          card += '<div class="timeline-actions">';
          card += '<button class="btn btn-pin" onclick="pinActivity(' + a.id + ')" title="Pin to Top"><i class="fa fa-thumb-tack"></i></button>';
          card += '<button class="btn btn-edit" onclick="editActivity(' + a.id + ')" title="Edit"><i class="fa fa-edit"></i></button>';
          card += '<button class="btn btn-delete" onclick="deleteActivity(' + a.id + ')" title="Delete"><i class="fa fa-trash"></i></button>';
          card += '</div>';
          card += '</div>';
          card += '</div>';
          return card;
        }

        var block = isRowType(t) ? renderRow() : renderCard();
        htmlAll += block;

        switch (t) {
          case 'emails': countEmails++; htmlEmails += block; break;
          case 'documents': countDocuments++; htmlDocuments += block; break;
          case 'calls': case 'call': countCalls++; htmlCalls += block; break;
          case 'notes': case 'note': countNotes++; htmlNotes += block; break;
          default: countActivities++; htmlActivitiesOnly += block; break;
        }
      });

      $('#activities-list').html(htmlAll);
      $('#activities-only-list').html(htmlActivitiesOnly || '<div class="text-muted text-center tw-py-4"><p><?php echo _l("no_activity_found"); ?></p></div>');
      $('#emails-list').html(htmlEmails || '<div class="text-muted text-center tw-py-4"><p><?php echo _l("no_emails_found"); ?></p></div>');
      $('#documents-list').html(htmlDocuments || '<div class="text-muted text-center tw-py-4"><p><?php echo _l("no_documents_found"); ?></p></div>');
      $('#calls-list').html(htmlCalls || '<div class="text-muted text-center tw-py-4"><p><?php echo _l("no_calls_found"); ?></p></div>');
      $('#notes-list').html(htmlNotes || '<div class="text-muted text-center tw-py-4"><p><?php echo _l("no_notes_found"); ?></p></div>');

      $('#badge-activities').text(countActivities);
      $('#badge-emails').text(countEmails);
      $('#badge-documents').text(countDocuments);
      $('#badge-calls').text(countCalls);
      $('#badge-notes').text(countNotes);

      placeTimelineDots();
    }).fail(function () {
      var errorHtml = '<div class="text-danger text-center tw-py-4"><i class="fa fa-exclamation-triangle fa-2x tw-mb-2"></i><p>Error loading activities</p></div>';
      $('#activities-list,#activities-only-list,#emails-list,#documents-list,#calls-list,#notes-list').html(errorHtml);
    });
  }


  function getActivityIconData(type) {
    switch (type) {
      case 'calls':
      case 'call':
        return { icon: 'fa-phone', bg: '#ff69b4', color: '#fff' }; // Pink as in screenshot for calls
      case 'emails':
        return { icon: 'fa-envelope', bg: '#6366f1', color: '#fff' };
      case 'notes':
      case 'note':
        return { icon: 'fa-sticky-note', bg: '#ff69b4', color: '#fff' }; // Pink for notes
      case 'documents':
        return { icon: 'fa-file-text', bg: '#fbbf24', color: '#fff' };
      case 'activity':
        return { icon: 'fa-check', bg: '#84c529', color: '#fff' }; // Green check for activities
      case 'stage':
        return { icon: 'fa-arrow-right', bg: '#add8e6', color: '#000' }; // Light blue arrow for stage changes
      case 'status':
        return { icon: 'fa-trophy', bg: '#add8e6', color: '#000' }; // Light blue for won/lost
      case 'contact':
      case 'company':
      case 'attachment':
        return { icon: 'fa-link', bg: '#add8e6', color: '#000' }; // Light blue for associations
      default:
        return { icon: 'fa-info-circle', bg: '#add8e6', color: '#fff' }; // Default light blue
    }
  }

  function loadContacts() {
    console.log('Loading contacts for deal:', dealId);
    $.get(admin_url + 'deals/get_deal_contacts/' + dealId, function (response) {
      response = parseIfString(response);
      if (response.__parseError) {
        console.error('Failed to parse contacts response:', response.error, response.raw);
        $('#contacts-list').html(
          '<div class="error-state d-flex flex-column align-items-center justify-content-center py-4">' +
          '<i class="fa fa-exclamation-triangle fa-2x mb-2 text-danger"></i>' +
          '<h5 class="mb-0">Error parsing contacts response</h5>' +
          '</div>'
        );
        return;
      }
      if (response.success && response.contacts && response.contacts.length > 0) {
        var html = '<div class="row g-3">';
        response.contacts.forEach(function (contact) {
          html += '<div class="col-12">';
          html += '<div class="contact-item shadow-sm h-100 d-flex flex-column justify-content-between">';
          html += '<div class="d-flex align-items-center gap-3">';
          html += '<div class="contact-avatar flex-shrink-0 d-flex align-items-center justify-content-center bg-light rounded-circle" style="width:48px;height:48px;">';
          html += '<i class="fa fa-user fa-lg white"></i>';
          html += '</div>';
          html += '<div class="contact-info flex-grow-1">';
          html += '<h6 class="contact-name mb-1 fw-bold text-truncate">' +
            (contact.firstname || '') + ' ' + (contact.lastname || '') +
            '</h6>';
          if (contact.email) {
            html += '<div class="contact-detail small text-muted mb-1"><i class="fa fa-envelope me-1"></i> <span class="text-break">' + contact.email + '</span></div>';
          }
          if (contact.phonenumber) {
            html += '<div class="contact-detail small text-muted"><i class="fa fa-phone me-1"></i> <span>' + contact.phonenumber + '</span></div>';
          }
          html += '</div>';
          html += '</div>';
          html += '<div class="contact-actions mt-3 d-flex gap-2 justify-content-end">';
          html += '<button class="btn btn-sm btn-outline-primary" onclick="editContact(' + contact.id + ')" title="Edit"><i class="fa fa-edit"></i></button>';
          html += '<button class="btn btn-sm btn-outline-danger" onclick="removeContact(' + contact.id + ')" title="Remove"><i class="fa fa-times"></i></button>';
          html += '</div>';
          html += '</div>';
          html += '</div>';
        });
        html += '</div>';
        $('#contacts-list').html(html);
      } else {
        $('#contacts-list').html(
          '<div class="empty-state d-flex flex-column align-items-center justify-content-center py-4">' +
          '<i class="fa fa-users fa-2x mb-2 text-secondary"></i>' +
          '<h5 class="mb-1"><?php echo _l("no_contacts_found"); ?></h5>' +
          '<p class="text-muted mb-0"><?php echo _l("add_contacts_to_get_started"); ?></p>' +
          '</div>'
        );
      }
    }).fail(function (xhr, status, error) {
      console.error('Error loading contacts:', error);
      console.error('Response:', xhr.responseText);
      $('#contacts-list').html(
        '<div class="error-state d-flex flex-column align-items-center justify-content-center py-4">' +
        '<i class="fa fa-exclamation-triangle fa-2x mb-2 text-danger"></i>' +
        '<h5 class="mb-0">Error loading contacts</h5>' +
        '</div>'
      );
    });
  }

  function loadCompanies() {
    console.log('Loading companies for deal:', dealId);
    $.get(admin_url + 'deals/get_deal_companies/' + dealId, function (response) {
      response = parseIfString(response);
      if (response.__parseError) {
        console.error('Failed to parse companies response:', response.error, response.raw);
        $('#companies-list').html(
          '<div class="d-flex flex-column align-items-center justify-content-center py-4 text-danger">' +
          '<i class="fa fa-exclamation-triangle fa-2x mb-2"></i>' +
          '<p class="mb-0">Error parsing companies response</p>' +
          '</div>'
        );
        $('#companies-count').text('(0)');
        return;
      }
      if (response.success && response.companies && response.companies.length > 0) {
        var html = '<div class="row g-3">';
        response.companies.forEach(function (company) {
          html += '<div class="col-12">';
          html += '<div class="company-item shadow-sm h-100 d-flex flex-column justify-content-between">';
          html += '<div class="d-flex align-items-center gap-3">';
          html += '<div class="company-avatar flex-shrink-0 d-flex align-items-center justify-content-center bg-light rounded-circle" style="width:48px;height:48px;">';
          html += '<i class="fa fa-building fa-lg white"></i>';
          html += '</div>';
          html += '<div class="company-info flex-grow-1">';
          html += '<h6 class="company-name mb-1 fw-bold text-truncate">' + (company.name || '') + '</h6>';
          if (company.email) {
            html += '<div class="company-detail small text-muted mb-1"><i class="fa fa-envelope me-1"></i> <span class="text-break">' + company.email + '</span></div>';
          }
          if (company.phone) {
            html += '<div class="company-detail small text-muted mb-1"><i class="fa fa-phone me-1"></i> <span>' + company.phone + '</span></div>';
          }
          if (company.website) {
            html += '<div class="company-detail small text-muted"><i class="fa fa-globe me-1"></i> <a href="' + company.website + '" target="_blank" class="text-primary text-decoration-none text-break">' + company.website + '</a></div>';
          }
          html += '</div>';
          html += '</div>';
          html += '<div class="company-actions mt-3 d-flex gap-2 justify-content-end">';
          html += '<button class="btn btn-sm btn-outline-primary" onclick="editCompany(' + company.id + ')" title="Edit"><i class="fa fa-edit"></i></button>';
          html += '<button class="btn btn-sm btn-outline-danger" onclick="removeCompany(' + company.id + ')" title="Remove"><i class="fa fa-times"></i></button>';
          html += '</div>';
          html += '</div>';
          html += '</div>';
        });
        html += '</div>';
        $('#companies-list').html(html);
        $('#companies-count').text('(' + response.companies.length + ')');
      } else {
        $('#companies-list').html(
          '<div class="d-flex flex-column align-items-center justify-content-center py-4 text-muted">' +
          '<i class="fa fa-building fa-2x mb-2"></i>' +
          '<p class="mb-0"><?php echo _l("no_company_associated"); ?></p>' +
          '</div>'
        );
        $('#companies-count').text('(0)');
      }
    }).fail(function (xhr, status, error) {
      console.error('Error loading companies:', error);
      console.error('Response:', xhr.responseText);
      $('#companies-list').html(
        '<div class="d-flex flex-column align-items-center justify-content-center py-4 text-danger">' +
        '<i class="fa fa-exclamation-triangle fa-2x mb-2"></i>' +
        '<p class="mb-0">Error loading companies</p>' +
        '</div>'
      );
      $('#companies-count').text('(0)');
    });
  }

  function isImage(filename) {
    return /\.(gif|jpe?g|tiff?|png|webp|bmp)$/i.test(filename);
  }

  function formatFileSize(bytes) {
    if (bytes === 0) return '0 Bytes';
    const k = 1024;
    const sizes = ['Bytes', 'KB', 'MB', 'GB'];
    const i = Math.floor(Math.log(bytes) / Math.log(k));
    return parseFloat((bytes / Math.pow(k, i)).toFixed(2)) + ' ' + sizes[i];
  }

  function previewAttachment(id, filename) {
    var url = admin_url + 'deals/download_attachment/' + id;
    var content = '';
    if (isImage(filename)) {
      content = '<img src="' + url + '" alt="' + filename + '" style="max-width:100%; height:auto;">';
    } else if (filename.toLowerCase().endsWith('.pdf')) {
      content = '<iframe src="' + url + '" width="100%" height="600px" frameborder="0"></iframe>';
    } else {
      content = '<p>Preview not available for this file type. <a href="' + url + '">Download</a> to view.</p>';
    }
    $('#preview-content').html(content);
    $('#previewModal').modal('show');
  }

  function loadAttachments() {
    console.log('Loading attachments for deal:', dealId);
    $.get(admin_url + 'deals/get_deal_attachments/' + dealId, function (response) {
      response = parseIfString(response);
      if (response.__parseError) {
        console.error('Failed to parse attachments response:', response.error, response.raw);
        $('#attachments-list').html('<div class="text-danger text-center tw-py-4"><i class="fa fa-exclamation-triangle fa-2x tw-mb-2"></i><p>Error parsing attachments response</p></div>');
        return;
      }
      console.log('Attachments response:', response);
      if (response.success && response.attachments && response.attachments.length > 0) {
        var html = '';
        response.attachments.forEach(function (attachment) {
          html += '<div class="attachment-item">';
          html += '<div class="attachment-header">';
          var url = admin_url + 'deals/download_attachment/' + attachment.id;
          if (isImage(attachment.file_name)) {
            html += '<div class="attachment-preview">';
            html += '<img src="' + url + '" style="max-width:60px; max-height:60px; width:auto; height:auto; object-fit:cover; border-radius:8px;" alt="' + attachment.file_name + '">';
            html += '</div>';
          } else {
            html += '<div class="attachment-icon">';
            html += '<i class="fa fa-file" style="font-size:24px; color:#6b7280;"></i>';
            html += '</div>';
          }
          html += '<div class="attachment-info">';
          html += '<h6 class="attachment-name">' + (attachment.file_name || 'Unknown file') + '</h6>';
          if (attachment.description) {
            html += '<p class="attachment-description">' + attachment.description + '</p>';
          }
          html += '<div class="attachment-meta">';
          // html += '<span class="attachment-size">' + (attachment.file_size ? formatFileSize(attachment.file_size) : '') + '</span>';
          html += '<span class="attachment-date">' + (attachment.dateadded ? moment(attachment.dateadded).format('MMM DD, YYYY') : '') + '</span>';
          html += '</div>';
          html += '</div>';
          html += '</div>';
          html += '<div class="attachment-actions">';
          html += '<button class="btn btn-sm btn-outline-primary" onclick="previewAttachment(' + attachment.id + ', \'' + attachment.file_name + '\')" title="Preview"><i class="fa fa-eye"></i></button>';
          html += '<a href="' + url + '" class="btn btn-sm btn-outline-success" title="Download"><i class="fa fa-download"></i></a>';
          html += '<button class="btn btn-sm btn-outline-danger" onclick="removeAttachment(' + attachment.id + ')" title="Remove"><i class="fa fa-trash"></i></button>';
          html += '</div>';
          html += '</div>';
        });
        $('#attachments-list').html(html);
        console.log('Attachments HTML updated:', html);
      } else {
        console.log('No attachments found or error in response');
        $('#attachments-list').html('<div class="text-muted text-center tw-py-4"><i class="fa fa-paperclip fa-2x tw-mb-2"></i><p><?php echo _l("no_attachments_uploaded"); ?></p></div>');
      }
    }).fail(function (xhr, status, error) {
      console.error('Error loading attachments:', error);
      console.error('Response:', xhr.responseText);
      $('#attachments-list').html('<div class="text-danger text-center tw-py-4"><i class="fa fa-exclamation-triangle fa-2x tw-mb-2"></i><p>Error loading attachments</p></div>');
    });
  }

  // --- TIMELINE ICONS ON LINE, NOT IN CARD ---


  function loadAvailableContacts() {
    $.get(admin_url + 'deals/get_available_contacts/' + dealId, function (response) {
      response = parseIfString(response);
      if (response.__parseError) {
        console.error('Failed to parse available contacts response:', response.error, response.raw);
        $('#existing-contact-select').html('<option value=""><?php echo _l("select_contact"); ?></option>');
        return;
      }
      console.log('Contacts response:', response);
      if (response.success) {
        var html = '<option value=""><?php echo _l("select_contact"); ?></option>';
        if (response.contacts && response.contacts.length > 0) {
          response.contacts.forEach(function (contact) {
            html += '<option value="' + contact.id + '">' + contact.firstname + ' ' + contact.lastname + ' (' + contact.email + ')</option>';
          });
        }
        $('#existing-contact-select').html(html);
      }
    }).fail(function (xhr, status, error) {
      console.error('Error loading contacts:', error);
    });
  }

  function loadAvailableCompanies() {
    $.get(admin_url + 'deals/get_available_companies/' + dealId, function (response) {
      response = parseIfString(response);
      if (response.__parseError) {
        console.error('Failed to parse available companies response:', response.error, response.raw);
        $('#existing-company-select').html('<option value=""><?php echo _l("select_company"); ?></option>');
        return;
      }
      console.log('Companies response:', response);
      if (response.success) {
        var html = '<option value=""><?php echo _l("select_company"); ?></option>';
        if (response.companies && response.companies.length > 0) {
          response.companies.forEach(function (company) {
            html += '<option value="' + company.id + '">' + company.name + '</option>';
          });
        }
        $('#existing-company-select').html(html);
      }
    }).fail(function (xhr, status, error) {
      console.error('Error loading companies:', error);
    });
  }
  function toggleAddActivityForm() {
    $('#add-activity-form').toggle();
  }

  function toggleLogCallForm() {
    $('#log-call-form').toggle();
  }

  function toggleAddNoteForm() {
    $('#add-note-form').toggle();
  }
  function addComment(activityId) {
    var desc = prompt('Add comment');
    if (desc) {
      var formData = new FormData();
      formData.append(CSRF.name, CSRF.value);
      formData.append('description', desc);
      $.ajax({
        url: admin_url + 'deals/add_comment/' + activityId,
        type: 'POST',
        data: formData,
        processData: false,
        contentType: false,
        success: function (response) {
          response = parseIfString(response);
          if (response.success) {
            loadActivities();
          }
        }
      });
    }
  }

  function addContact() {
    $('#contactModalTitle').text('<?php echo _l("add_contact"); ?>');
    // Clear form fields
    $('#contact-firstname').val('');
    $('#contact-lastname').val('');
    $('#contact-email').val('');
    $('#contact-phonenumber').val('');
    $('#existing-contact-select').val('');
    $('#contactModal').modal('show');
  }

  function addCompany() {
    $('#companyModalTitle').text('<?php echo _l("add_company"); ?>');
    // Clear form fields
    $('#company-name').val('');
    $('#company-email').val('');
    $('#company-phone').val('');
    $('#company-website').val('');
    $('#company-address').val('');
    $('#existing-company-select').val('');
    $('#companyModal').modal('show');
  }

  function addAttachment() {
    // Clear form fields
    $('#attachment-file').val('');
    $('#attachment-description').val('');
    $('#attachmentModal').modal('show');
  }

  function showLostReasonModal() {
    $('#lost-reason-select').val('');
    $('#lostReasonModal').modal('show');
  }

  function editContact(id) {
    alert('Edit contact functionality will be implemented for ID: ' + id);
  }

  function editCompany(id) {
    alert('Edit company functionality will be implemented for ID: ' + id);
  }

  function saveContact() {
    var contactId = $('#existing-contact-select').val();
    var formData = new FormData();

    // Add CSRF token
    formData.append(CSRF.name, CSRF.value);

    if (contactId) {
      formData.append('contact_id', contactId);
    } else {
      formData.append('firstname', $('#contact-firstname').val());
      formData.append('lastname', $('#contact-lastname').val());
      formData.append('email', $('#contact-email').val());
      formData.append('phonenumber', $('#contact-phonenumber').val());
    }

    $.ajax({
      url: admin_url + 'deals/add_contact_to_deal/' + dealId,
      type: 'POST',
      data: formData,
      processData: false,
      contentType: false,
      success: function (response) {
        response = parseIfString(response);
        if (response.__parseError) {
          alert('Error parsing save contact response: ' + response.error);
          return;
        }
        console.log('Save contact response:', response);
        if (response.success) {
          $('#contactModal').modal('hide');
          refreshAllData();
        } else {
          alert('Error: ' + (response.message || 'Unknown error occurred'));
        }
      },
      error: function (xhr, status, error) {
        console.error('Error saving contact:', error);
        alert('Error saving contact: ' + error);
      }
    });
  }

  function saveCompany() {
    var companyId = $('#existing-company-select').val();
    var formData = new FormData();

    // Add CSRF token
    formData.append(CSRF.name, CSRF.value);

    if (companyId) {
      formData.append('company_id', companyId);
    } else {
      formData.append('company_name', $('#company-name').val());
      formData.append('company_email', $('#company-email').val());
      formData.append('company_phone', $('#company-phone').val());
      formData.append('company_website', $('#company-website').val());
      formData.append('company_address', $('#company-address').val());
    }

    $.ajax({
      url: admin_url + 'deals/add_company_to_deal/' + dealId,
      type: 'POST',
      data: formData,
      processData: false,
      contentType: false,
      success: function (response) {
        response = parseIfString(response);
        if (response.__parseError) {
          alert('Error parsing save company response: ' + response.error);
          return;
        }
        console.log('Save company response:', response);
        if (response.success) {
          $('#companyModal').modal('hide');
          refreshAllData();
        } else {
          alert('Error: ' + (response.message || 'Unknown error occurred'));
        }
      },
      error: function (xhr, status, error) {
        console.error('Error saving company:', error);
        alert('Error saving company: ' + error);
      }
    });
  }

  function saveAttachment() {
    var formData = new FormData();

    // Add CSRF token
    formData.append(CSRF.name, CSRF.value);
    formData.append('attachment', $('#attachment-file')[0].files[0]);
    formData.append('description', $('#attachment-description').val());

    $.ajax({
      url: admin_url + 'deals/add_attachment_to_deal/' + dealId,
      type: 'POST',
      data: formData,
      processData: false,
      contentType: false,
      success: function (response) {
        response = parseIfString(response);
        if (response.__parseError) {
          alert('Error parsing save attachment response: ' + response.error);
          return;
        }
        console.log('Save attachment response:', response);
        if (response.success) {
          $('#attachmentModal').modal('hide');
          refreshAllData();
        } else {
          alert('Error: ' + (response.message || 'Unknown error occurred'));
        }
      },
      error: function (xhr, status, error) {
        console.error('Error saving attachment:', error);
        alert('Error saving attachment: ' + error);
      }
    });
  }

  function removeContact(contactId) {
    if (confirm('<?php echo _l("confirm_action_prompt"); ?>')) {
      var formData = new FormData();
      formData.append(CSRF.name, CSRF.value);

      $.ajax({
        url: admin_url + 'deals/remove_contact_from_deal/' + dealId + '/' + contactId,
        type: 'POST',
        data: formData,
        processData: false,
        contentType: false,
        success: function (response) {
          response = parseIfString(response);
          if (response.__parseError) {
            alert('Error parsing remove contact response: ' + response.error);
            return;
          }
          if (response.success) {
            refreshAllData();
          }
        }
      });
    }
  }

  function removeCompany(companyId) {
    if (confirm('<?php echo _l("confirm_action_prompt"); ?>')) {
      var formData = new FormData();
      formData.append(CSRF.name, CSRF.value);

      $.ajax({
        url: admin_url + 'deals/remove_company_from_deal/' + dealId + '/' + companyId,
        type: 'POST',
        data: formData,
        processData: false,
        contentType: false,
        success: function (response) {
          response = parseIfString(response);
          if (response.__parseError) {
            alert('Error parsing remove company response: ' + response.error);
            return;
          }
          if (response.success) {
            refreshAllData();
          }
        }
      });
    }
  }

  function removeAttachment(attachmentId) {
    if (confirm('<?php echo _l("confirm_action_prompt"); ?>')) {
      var formData = new FormData();
      formData.append(CSRF.name, CSRF.value);

      $.ajax({
        url: admin_url + 'deals/remove_attachment_from_deal/' + dealId + '/' + attachmentId,
        type: 'POST',
        data: formData,
        processData: false,
        contentType: false,
        success: function (response) {
          response = parseIfString(response);
          if (response.__parseError) {
            alert('Error parsing remove attachment response: ' + response.error);
            return;
          }
          if (response.success) {
            refreshAllData();
          }
        }
      });
    }
  }

  // This function is called by the stage pipeline UI (see @file_context_0)
  function setDealStagePipeline(dealId, pipelineId, stageId) {
    if (confirm('<?php echo _l("confirm_action_prompt"); ?>')) {
      var formData = new FormData();
      formData.append(CSRF.name, CSRF.value);
      formData.append('stage_id', stageId);
      formData.append('pipeline_id', pipelineId);

      $.ajax({
        url: admin_url + 'deals/set_stage/' + dealId,
        type: 'POST',
        data: formData,
        processData: false,
        contentType: false,
        success: function (response) {
          response = parseIfString(response);
          if (response.__parseError) {
            alert('Error parsing set stage response: ' + response.error);
            return;
          }
          window.location.reload();
        }
      });
    }
  }

  function markDealWon(dealId) {
    if (confirm('<?php echo _l("confirm_action_prompt"); ?>')) {
      var formData = new FormData();
      formData.append(CSRF.name, CSRF.value);

      $.ajax({
        url: admin_url + 'deals/mark_won/' + dealId,
        type: 'POST',
        data: formData,
        processData: false,
        contentType: false,
        success: function (response) {
          response = parseIfString(response);
          if (response.__parseError) {
            alert('Error parsing mark won response: ' + response.error);
            return;
          }
          window.location.reload();
        }
      });
    }
  }

  function markDealLost(dealId) {
    var lostReasonId = $('#lost-reason-select').val();
    if (lostReasonId === '') {
      alert('<?php echo _l("please_select_lost_reason"); ?>');
      return;
    }
    if (confirm('<?php echo _l("confirm_action_prompt"); ?>')) {
      var formData = new FormData();
      formData.append(CSRF.name, CSRF.value);
      formData.append('lost_reason_id', lostReasonId);

      $.ajax({
        url: admin_url + 'deals/mark_lost/' + dealId,
        type: 'POST',
        data: formData,
        processData: false,
        contentType: false,
        success: function (response) {
          response = parseIfString(response);
          if (response.__parseError) {
            alert('Error parsing mark lost response: ' + response.error);
            return;
          }
          $('#lostReasonModal').modal('hide');
          window.location.reload();
        }
      });
    }
  }



  function pinActivity(activityId) {
    // Implementation for pinning activity
    alert('Pin activity functionality will be implemented');
  }

  // Activity Management Functions
  function addActivity() {
    $('#activity-description').val('');
    $('#addActivityModal').modal('show');
  }

  function logCall() {
    $('#call-type').val('outbound');
    $('#call-status').val('completed');
    $('#call-duration').val('');
    $('#call-notes').val('');
    $('#call-date').val(new Date().toISOString().slice(0, 16));
    $('#logCallModal').modal('show');
  }

  function addNote() {
    $('#note-description').val('');
    $('#addNoteModal').modal('show');
  }

  function editActivity(activityId) {
    // Edit activity functionality
    console.log('Editing activity:', activityId);
    // Add your edit logic here
  }

  function deleteActivity(activityId) {
    // Delete activity functionality
    if (confirm('Are you sure you want to delete this activity?')) {
      console.log('Deleting activity:', activityId);
      // Add your delete logic here
    }
  }

  function filterActivities() {
    var filterValue = $('#activity-filter').val();
    console.log('Filtering activities by:', filterValue);

    if (filterValue === 'all') {
      $('.timeline-item').show();
    } else {
      $('.timeline-item').hide();
      $('.timeline-item[data-type="' + filterValue + '"]').show();
    }
  }

  function refreshAllData() {
    loadContacts();
    loadCompanies();
    loadAttachments();
    loadActivities();
    loadAvailableContacts();
    loadAvailableCompanies();
  }

  function saveActivity() {
    var description = $('#activity-description').val().trim();
    if (!description) {
      alert('Description is required');
      return;
    }
    var formData = new FormData();
    formData.append(CSRF.name, CSRF.value);
    formData.append('description', description);
    $.ajax({
      url: admin_url + 'deals/add_activity/' + dealId,
      type: 'POST',
      data: formData,
      processData: false,
      contentType: false,
      success: function (response) {
        response = parseIfString(response);
        if (response.success) {
          $('#addActivityModal').modal('hide');
          loadActivities();
        } else {
          alert('Error adding activity: ' + (response.message || ''));
        }
      },
      error: function () {
        alert('Error adding activity');
      }
    });
  }

  function saveCall() {
    var payload = {
      call_type: $('#call_type').val(),
      outcome: $('#outcome').val(),
      call_duration: $('#call_duration').val(),
      call_notes: $('#call_notes').val(),
      call_date: $('#call_date').val()
    };
    if (!payload.call_type || !payload.outcome) {
      alert('Call type and status are required');
      return;
    }
    var formData = new FormData();
    formData.append(CSRF.name, CSRF.value);
    for (var key in payload) {
      formData.append(key, payload[key] || '');
    }
    $.ajax({
      url: admin_url + 'deals/add_call/' + dealId,
      type: 'POST',
      data: formData,
      processData: false,
      contentType: false,
      success: function (response) {
        // Ensure response is parsed and handled as JSON, not as a redirect
        try {
          response = parseIfString(response);
        } catch (e) {
          alert('Unexpected response from server.');
          return;
        }
        if (response && response.success) {
          $('#add_call_modal').modal('hide');
          alert('Call added successfully');
        } else {
          alert('Error adding call: ' + (response && response.message ? response.message : ''));
        }
      },
      error: function (xhr) {
        // Try to show error message if available
        var msg = 'Error adding call';
        if (xhr && xhr.responseText) {
          try {
            var resp = JSON.parse(xhr.responseText);
            if (resp && resp.message) msg += ': ' + resp.message;
          } catch (e) { }
        }
        alert(msg);
      }
    });
  }

  function saveNote() {
    var description = $('#note-description').val().trim();
    if (!description) {
      alert('Description is required');
      return;
    }
    var formData = new FormData();
    formData.append(CSRF.name, CSRF.value);
    formData.append('description', description);
    $.ajax({
      url: admin_url + 'deals/add_note/' + dealId,
      type: 'POST',
      data: formData,
      processData: false,
      contentType: false,
      success: function (response) {
        response = parseIfString(response);
        if (response.success) {
          $('#addNoteModal').modal('hide');
          loadActivities();
        } else {
          alert('Error adding note: ' + (response.message || ''));
        }
      },
      error: function () {
        alert('Error adding note');
      }
    });
  }


  function placeTimelineDots() {
    $('.timeline-item').each(function () {
      var $it = $(this);
      var icon = $it.data('icon') || 'fa-clock-o';
      var bg = $it.data('icon-bg') || '#6b7280';
      var color = $it.data('icon-color') || '#fff';
      var $dot = $it.find('.dot');
      $dot.html('<i class="fa ' + icon + '"></i>').css({ background: bg, color: color });
    });
  }

  function filterActivities() {
    var v = $('#activity-filter').val();
    if (v === 'all') $('.timeline-item').show();
    else { $('.timeline-item').hide(); $('.timeline-item[data-type="' + v + '"]').show(); }
    placeTimelineDots();
  }
  function toggleAddActivityForm() { $('#add-activity-form').toggle(); }
  function toggleLogCallForm() { $('#log-call-form').toggle(); }
  function toggleAddNoteForm() { $('#add-note-form').toggle(); }

  function editActivity(id) { /* open modal, load item, submit to edit endpoints */ }
  function deleteActivity(id) { if (confirm('Delete this item?')) { /* call delete endpoint then reload */ } }
  function pinActivity(id) { /* optional */ }
  // Initialize activity filter
  $(document).ready(function () {
    $('#activity-filter').on('change', filterActivities);
  });

  // Remove duplicate/alternate saveActivity, saveCall, saveNote functions
  // Only keep the above versions that match your backend payload

  function placeTimelineDots() {
    $('.timeline-item').each(function () {
      var $it = $(this);
      var icon = $it.data('icon') || 'fa-clock-o';
      var bg = $it.data('icon-bg') || '#6b7280';
      var color = $it.data('icon-color') || '#fff';
      var $dot = $it.find('.dot');
      $dot.html('<i class="fa ' + icon + '"></i>').css({ background: bg, color: color });
    });
  }

  function filterActivities() {
    var v = $('#activity-filter').val();
    if (v === 'all') $('.timeline-item').show();
    else { $('.timeline-item').hide(); $('.timeline-item[data-type="' + v + '"]').show(); }
    placeTimelineDots();
  }

  // Remove duplicate toggleAddActivityForm, toggleLogCallForm, toggleAddNoteForm, etc.
  // Only keep one version of each function

  // Initialize activity filter
  $(document).ready(function () {
    $('#activity-filter').on('change', filterActivities);
  });











  $(function () {
    // Show edit icon on hover for amount
    $('.deal-value-group').hover(
      function () { $(this).find('.edit-amount-btn').show(); },
      function () { if (!$('#edit-amount-form').is(':visible')) $(this).find('.edit-amount-btn').hide(); }
    );
    // Show edit icon on hover for close date
    $('.close-date-group').hover(
      function () { $(this).find('.edit-close-date-btn').show(); },
      function () { if (!$('#edit-close-date-form').is(':visible')) $(this).find('.edit-close-date-btn').hide(); }
    );

    // Amount form submit
    $('#edit-amount-form').on('submit', function (e) {
      e.preventDefault();
      saveDealAmount();
    });

    // Close date form submit
    $('#edit-close-date-form').on('submit', function (e) {
      e.preventDefault();
      saveCloseDate();
    });
  });

  function editDealAmount() {
    $('.deal-value-display').hide();
    $('#edit-amount-form').show();
    $('.edit-amount-btn').hide();
    $('#edit-amount-input').focus();
  }
  function cancelEditAmount() {
    $('#edit-amount-form').hide();
    $('.deal-value-display').show();
    $('.edit-amount-btn').hide();
  }
  function saveDealAmount() {
    var amount = parseFloat($('#edit-amount-input').val());
    if (isNaN(amount) || amount < 0) {
      alert('Please enter a valid amount');
      return;
    }
    var formData = new FormData();
    formData.append('<?php echo $this->security->get_csrf_token_name(); ?>', '<?php echo $this->security->get_csrf_hash(); ?>');
    formData.append('deal_value', amount);
    $.ajax({
      url: admin_url + 'deals/update_amount/<?php echo (int) $deal['id']; ?>',
      type: 'POST',
      data: formData,
      processData: false,
      contentType: false,
      success: function (response) {
        try { response = typeof response === 'string' ? JSON.parse(response) : response; } catch (e) { }
        if (response && response.success) {
          location.reload();
        } else {
          alert('Failed to update amount');
        }
      },
      error: function () { alert('Failed to update amount'); }
    });
  }

  function editCloseDate() {
    $('.close-date-display').hide();
    $('#edit-close-date-form').show();
    $('.edit-close-date-btn').hide();
    $('#edit-close-date-input').focus();
  }
  function cancelEditCloseDate() {
    $('#edit-close-date-form').hide();
    $('.close-date-display').show();
    $('.edit-close-date-btn').hide();
  }
  function saveCloseDate() {
    var date = $('#edit-close-date-input').val();
    if (!date) {
      alert('Please select a date');
      return;
    }
    var formData = new FormData();
    formData.append('<?php echo $this->security->get_csrf_token_name(); ?>', '<?php echo $this->security->get_csrf_hash(); ?>');
    formData.append('expected_close_date', date);
    $.ajax({
      url: admin_url + 'deals/update_close_date/<?php echo (int) $deal['id']; ?>',
      type: 'POST',
      data: formData,
      processData: false,
      contentType: false,
      success: function (response) {
        try { response = typeof response === 'string' ? JSON.parse(response) : response; } catch (e) { }
        if (response && response.success) {
          location.reload();
        } else {
          alert('Failed to update close date');
        }
      },
      error: function () { alert('Failed to update close date'); }
    });
  }

  // New functions for tabs functionality
  function loadDealProposals(dealId) {
    $.get(admin_url + 'deals/get_deal_proposals/' + dealId, function (response) {
      var proposals = parseIfString(response);
      var html = '';

      if (proposals && proposals.length > 0) {
        proposals.forEach(function (proposal) {
          html += '<div class="timeline-item timeline-card">';
          html += '<div class="dot" style="background: #6366f1; color: #fff;">';
          html += '<i class="fa fa-file-text-o"></i>';
          html += '</div>';
          html += '<div class="timeline-content">';
          html += '<div class="timeline-header">';
          html += '<h6>' + proposal.subject + '</h6>';
          html += '<span class="badge badge-info">' + proposal.status + '</span>';
          html += '</div>';
          html += '<p class="text-muted">' + proposal.date + '</p>';
          html += '<p>' + proposal.content.substring(0, 100) + '...</p>';
          html += '</div>';
          html += '</div>';
        });
      } else {
        html = '<div class="text-center tw-py-4"><i class="fa fa-file-text-o fa-2x tw-mb-2"></i><p>No proposals found</p></div>';
      }

      $('#proposals-content').html(html);
    });
  }

  function loadDealTasks(dealId) {
    $.get(admin_url + 'deals/get_deal_tasks/' + dealId, function (response) {
      var tasks = parseIfString(response);
      var html = '';

      if (tasks && tasks.length > 0) {
        tasks.forEach(function (task) {
          html += '<div class="timeline-item timeline-card" style="display: flex; align-items: flex-start;">';
          html += '<div class="dot" style="background: #10b981; color: #fff; ">';
          html += '<i class="fa fa-check-circle"></i>';
          html += '</div>';
          html += '<div class="timeline-content" style="flex: 1;">';
          html += '<div class="timeline-header" style="display: flex; align-items: center; justify-content: space-between;">';
          html += '<h6 style="margin: 0;">' + task.name + '</h6>';
          html += '<span class="badge badge-success">' + task.status + '</span>';
          html += '</div>';
          html += '<p class="text-muted" style="margin-bottom: 4px;">Due: ' + task.duedate + '</p>';
          html += '<p>' + task.description.substring(0, 100) + '...</p>';
          html += '</div>';
          html += '</div>';
        });
      } else {
        html = '<div class="text-center tw-py-4"><i class="fa fa-check-circle fa-2x tw-mb-2"></i><p>No tasks found</p></div>';
      }

      $('#tasks-content').html(html);
    });
  }

  function loadDealAttachments(dealId) {
    $.get(admin_url + 'deals/get_deal_attachments/' + dealId, function (response) {
      var attachments = parseIfString(response);
      var html = '';

      if (attachments && attachments.length > 0) {
        attachments.forEach(function (attachment) {
          html += '<div class="timeline-item timeline-card">';
          html += '<div class="dot" style="background: #f59e42; color: #fff;">';
          html += '<i class="fa fa-paperclip"></i>';
          html += '</div>';
          html += '<div class="timeline-content">';
          html += '<div class="timeline-header">';
          html += '<h6>' + attachment.file_name + '</h6>';
          html += '<span class="badge badge-warning">' + attachment.filetype + '</span>';
          html += '</div>';
          html += '<p class="text-muted">Uploaded: ' + attachment.dateadded + '</p>';
          html += '<a href="' + attachment.file_url + '" class="btn btn-sm btn-primary">Download</a>';
          html += '</div>';
          html += '</div>';
        });
      } else {
        html = '<div class="text-center tw-py-4"><i class="fa fa-paperclip fa-2x tw-mb-2"></i><p>No attachments found</p></div>';
      }

      $('#attachments-content').html(html);
    });
  }

  function loadDealReminders(dealId) {
    $.get(admin_url + 'deals/get_deal_reminders/' + dealId, function (response) {
      var reminders = parseIfString(response);
      var html = '';

      if (reminders && reminders.length > 0) {
        reminders.forEach(function (reminder) {
          html += '<div class="timeline-item timeline-card">';
          html += '<div class="dot" style="background: #fbbf24; color: #fff;">';
          html += '<i class="fa fa-bell"></i>';
          html += '</div>';
          html += '<div class="timeline-content">';
          html += '<div class="timeline-header">';
          html += '<h6>' + reminder.description + '</h6>';
          html += '<span class="badge badge-warning">' + reminder.date + '</span>';
          html += '</div>';
          html += '<p class="text-muted">Reminder for: ' + reminder.staff_name + '</p>';
          html += '</div>';
          html += '</div>';
        });
      } else {
        html = '<div class="text-center tw-py-4"><i class="fa fa-bell fa-2x tw-mb-2"></i><p>No reminders found</p></div>';
      }

      $('#reminders-content').html(html);
    });
  }

  function loadDealNotes(dealId) {
    $.get(admin_url + 'deals/get_deal_notes/' + dealId, function (response) {
      var notes = parseIfString(response);
      var html = '';

      if (notes && notes.length > 0) {
        notes.forEach(function (note) {
          html += '<div class="timeline-item timeline-card">';
          html += '<div class="dot" style="background: #f59e42; color: #fff;">';
          html += '<i class="fa fa-sticky-note"></i>';
          html += '</div>';
          html += '<div class="timeline-content">';
          html += '<div class="timeline-header">';
          html += '<h6>Note by ' + note.staff_name + '</h6>';
          html += '<span class="badge badge-info">' + note.dateadded + '</span>';
          html += '</div>';
          html += '<p>' + note.description + '</p>';
          html += '</div>';
          html += '</div>';
        });
      } else {
        html = '<div class="text-center tw-py-4"><i class="fa fa-sticky-note-o fa-2x tw-mb-2"></i><p>No notes found</p></div>';
      }

      $('#notes-content').html(html);
    });
  }

  function loadDealActivities(dealId) {
    $.get(admin_url + 'deals/get_deal_activities/' + dealId, function (response) {
      var activities = parseIfString(response);
      var html = '';

      if (activities && activities.length > 0) {
        activities.forEach(function (activity) {
          html += '<div class="timeline-item timeline-card">';
          html += '<div class="dot" style="background: #38bdf8; color: #fff;">'; // blue for activity
          html += '<i class="far fa-clock"></i>';
          html += '</div>';

          html += '<div class="timeline-content">';
          html += '<div class="timeline-header">';
          html += '<h5>' + activity.description + '</h5>';
          html += '<span class="badge badge-info">' + activity.date + '</span>';

          html += '</div>';
          html += '<p class="text-muted">By: ' + activity.full_name + '</p>';
          html += '</div>';
          html += '</div>';
        });
      } else {
        html = '<div class="text-center tw-py-4"><i class="fa fa-clock-o fa-2x tw-mb-2"></i><p>No activities found</p></div>';
      }

      $('#activity-content').html(html);
    });
  }

  function loadDealEmails(dealId) {
    $.get(admin_url + 'deals/get_deal_emails/' + dealId, function (response) {
      var emails = parseIfString(response);
      var html = '';

      // The backend returns an array of objects with keys:
      // id, deal_id, from_email, from_name, to_email, subject, message, sent, sent_date, dateadded, staffid, attachments
      if (emails && emails.length > 0) {
        emails.forEach(function (email) {
          var ad = parseIfString(email.additional_data);
          html += '<div class="timeline-item timeline-card">';
          html += '<div class="dot" style="background: #6366f1; color: #fff;">';
          html += '<i class="fa fa-envelope"></i>';
          html += '</div>';
          html += '<div class="timeline-content">';
          html += '<div class="timeline-header">';
          // Prefer ad.subject if available, fallback to email.subject, then (No Subject)
          var subject = ad && ad.subject ? ad.subject : (email.subject ? email.subject : '(No Subject)');
          html += '<h6>' + escapeHtml(subject) + '</h6>';
          html += '<span class="badge badge-primary">' + (email.sent_date ? escapeHtml(email.sent_date) : escapeHtml(email.dateadded)) + '</span>';
          html += '</div>';
          // Prefer ad.to if available, fallback to email.to_email
          var toEmail = ad && ad.to ? ad.to : email.to_email;
          // Prefer ad.body if available, fallback to email.message
          var message = ad && ad.body ? ad.body : email.message;
          // html += '<p class="text-muted">From: ' + (email.from_name ? escapeHtml(email.from_name) : '') + ' &lt;' + escapeHtml(email.from_email) + '&gt;</p>';
          html += '<p class="text-muted">To: ' + escapeHtml(toEmail) + '</p>';
          if (message) {
            html += '<div class="email-message tw-mb-2" style="white-space:pre-line;">' + escapeHtml(message.length > 200 ? message.substring(0, 200) + '...' : message) + '</div>';
          }
          // Attachments
          if (email.attachments) {
            var files = [];
            try { files = JSON.parse(email.attachments); } catch (e) { }
            if (Array.isArray(files) && files.length > 0) {
              html += '<div class="email-attachments tw-mb-2"><strong>Attachments:</strong><ul>';
              files.forEach(function (file) {
                html += '<li><a href="' + site_url + 'uploads/deal_emails/' + encodeURIComponent(file) + '" target="_blank">' + escapeHtml(file) + '</a></li>';
              });
              html += '</ul></div>';
            }
          }
          html += '</div>';
          html += '</div>';
        });
      } else {
        html = '<div class="text-center tw-py-4"><i class="fa fa-envelope fa-2x tw-mb-2"></i><p>No emails found</p></div>';
      }
      $('#emails-content').html(html);
    })
  }


  function loadDealCalls(dealId) {
    $.get(admin_url + 'deals/get_deal_calls/' + dealId, function (response) {
      var calls = parseIfString(response);
      var html = '';

      if (calls && calls.length > 0) {
        calls.forEach(function (call) {
          html += '<div class="timeline-item timeline-card">';
          html += '<div class="dot" style="background: #10b981; color: #fff;">';
          html += '<i class="fa fa-phone"></i>';
          html += '</div>';
          html += '<div class="timeline-content">';
          html += '<div class="timeline-header">';
          html += '<h6>' + call.type + ' Call</h6>';
          html += '<span class="badge badge-success">' + call.status + '</span>';
          html += '</div>';
          html += '<p class="text-muted">Duration: ' + call.duration + ' minutes</p>';
          html += '<p>' + call.notes + '</p>';
          html += '</div>';
          html += '</div>';
        });
      } else {
        html = '<div class="text-center tw-py-4"><i class="fa fa-phone fa-2x tw-mb-2"></i><p>No calls found</p></div>';
      }

      $('#calls-content').html(html);
    });
  }

  // Modal functions
  function openNewProposalModal(dealId) {
    // Open the existing proposal modal from leads module
    window.open(admin_url + 'proposals/proposal?rel_type=deal&rel_id=' + dealId, '_blank');
  }

  function openNewTaskModal(dealId) {
    $('#add_task_modal').modal('show');
  }

  function openNewReminderModal(dealId) {
    $('#add_reminder_modal').modal('show');
  }

  function openNewNoteModal(dealId) {
    $('#add_note_modal').modal('show');
  }

  function openNewActivityModal(dealId) {
    $('#add_activity_modal').modal('show');
  }

  function openNewEmailModal(dealId) {
    // Open the existing email modal from leads module
    $('#add_email_modal ').modal('show');
    // window.open(admin_url + 'leads/send_email/' + dealId, '_blank');
  }

  function openNewCallModal(dealId) {
    // Open the existing call modal from leads module
    $('#add_call_modal').modal('show');
    // window.open(admin_url + 'leads/log_call/' + dealId, '_blank');
  }

  function openAddAttachmentModal(dealId) {
    $('#add_attachment_modal').modal('show');
  }
</script>

<style>
  /* Contact, Company, and Attachment Items - Modern Design */
  .contact-item,
  .company-item,
  .attachment-item {
    background: #fff;
    border-radius: 8px;
    padding: 16px;
    margin-bottom: 12px;
    border: 1px solid #e5e7eb;
    transition: all 0.3s ease;
    position: relative;
    box-shadow: 0 1px 3px rgba(0, 0, 0, 0.1);
  }

  .contact-item:hover,
  .company-item:hover,
  .attachment-item:hover {
    border-color: #3b82f6;
    box-shadow: 0 4px 12px rgba(59, 130, 246, 0.15);
    transform: translateY(-2px);
  }

  .contact-actions,
  .company-actions {
    position: absolute;
    right: 16px;
    top: 16px;
    opacity: 0;
    transition: all 0.3s ease;
    display: flex;
    gap: 8px;
  }

  .contact-item:hover .contact-actions,
  .company-item:hover .company-actions {
    opacity: 1;
  }

  .contact-header,
  .company-header {
    display: flex;
    align-items: flex-start;
    margin-bottom: 12px;
  }

  .contact-avatar,
  .company-avatar {
    width: 40px;
    height: 40px;
    border-radius: 50%;
    background: linear-gradient(135deg, #3b82f6, #1d4ed8);
    color: #fff;
    display: flex;
    align-items: center;
    justify-content: center;
    margin-right: 16px;
    font-size: 16px;
    box-shadow: 0 2px 8px rgba(59, 130, 246, 0.3);
  }

  .contact-name,
  .company-name {
    font-weight: 600;
    color: #1f2937;
    font-size: 16px;
    margin-bottom: 4px;
  }

  .contact-detail,
  .company-detail {
    color: #6b7280;
    font-size: 14px;
    margin-bottom: 4px;
    display: flex;
    align-items: center;
    gap: 8px;
  }

  .contact-detail i,
  .company-detail i {
    width: 16px;
    color: #9ca3af;
  }

  /* Attachment specific styles */
  .attachment-header {
    display: flex;
    align-items: flex-start;
    margin-bottom: 12px;
  }

  .attachment-preview,
  .attachment-icon {
    width: 60px;
    height: 60px;
    border-radius: 8px;
    background: #f8fafc;
    display: flex;
    align-items: center;
    justify-content: center;
    margin-right: 16px;
    border: 1px solid #e2e8f0;
  }

  .attachment-info {
    flex: 1;
  }

  .attachment-name {
    font-weight: 600;
    color: #1f2937;
    font-size: 16px;
    margin-bottom: 4px;
  }

  .attachment-description {
    color: #6b7280;
    font-size: 14px;
    margin-bottom: 8px;
  }

  .attachment-meta {
    display: flex;
    gap: 16px;
    font-size: 12px;
    color: #9ca3af;
  }

  .attachment-actions {
    position: absolute;
    right: 16px;
    top: 16px;
    opacity: 0;
    transition: all 0.3s ease;
    display: flex;
    gap: 8px;
  }

  .attachment-item:hover .attachment-actions {
    opacity: 1;
  }



  /* Timeline spine - Modern Design */
  .timeline-container {
    position: relative;
    padding: 20px 0 20px 50px;
  }

  .timeline-container::before {
    content: '';
    position: absolute;
    left: 25px;
    top: 0;
    bottom: 0;
    width: 3px;
    background: linear-gradient(to bottom, #e5e7eb, #d1d5db);
    border-radius: 2px;
  }

  .timeline-item {
    position: relative;
    margin-bottom: 20px;
    min-height: 40px;
  }

  .timeline-item .dot {
    position: absolute;
    left: 0;
    top: 4px;
    width: 50px;
    height: 50px;
    border-radius: 50%;
    display: flex;
    align-items: center;
    justify-content: center;
    color: #fff;
    box-shadow: 0 4px 12px rgba(0, 0, 0, 0.15);
    z-index: 2;
    font-size: 20px;
    border: 3px solid #fff;
    margin-right: 10px;
  }

  /* Single-line rows */
  .timeline-item.timeline-row .timeline-row-text {
    margin: 8px 0 0 70px;
    font-size: 14px;
    color: #374151;
    line-height: 1.5;
  }

  .timeline-item.timeline-row .timeline-row-meta {
    color: #9ca3af;
    margin-left: 8px;
    font-size: 13px;
  }

  /* Cards */
  .timeline-item.timeline-card .timeline-content {
    margin-left: 70px;
    background: #fff;
    border: 1px solid #e5e7eb;
    border-radius: 12px;
    padding: 20px;
    box-shadow: 0 2px 8px rgba(0, 0, 0, 0.08);
    transition: all 0.3s ease;
  }

  .timeline-item.timeline-card .timeline-content:hover {
    box-shadow: 0 4px 16px rgba(0, 0, 0, 0.12);
    transform: translateY(-2px);
  }

  .timeline-header {
    display: flex;
    align-items: flex-start;
    margin-bottom: 12px;
  }

  .timeline-info {
    flex: 1;
  }

  .timeline-title {
    font-weight: 600;
    color: #1f2937;
    margin: 0 0 6px 0;
    font-size: 16px;
    line-height: 1.4;
  }

  .timeline-meta {
    color: #6b7280;
    font-size: 13px;
    margin: 0;
    display: flex;
    align-items: center;
    gap: 8px;
  }

  .timeline-meta i {
    color: #9ca3af;
    width: 14px;
  }

  .meta-sep {
    margin: 0 6px;
    color: #cbd5e1;
  }

  .timeline-description {
    color: #475569;
    line-height: 1.6;
    margin: 12px 0 8px;
    font-size: 14px;
    background: #f8fafc;
    padding: 12px;
    border-radius: 8px;
    border-left: 3px solid #e2e8f0;
  }

  .timeline-actions {
    position: absolute;
    right: 16px;
    top: 16px;
    opacity: 0;
    transform: translateX(8px);
    transition: all .3s ease;
    display: flex;
    gap: 8px;
  }

  .timeline-item:hover .timeline-actions {
    opacity: 1;
    transform: translateX(0);
  }

  .timeline-actions .btn {
    width: 32px;
    height: 32px;
    border-radius: 50%;
    display: flex;
    align-items: center;
    justify-content: center;
    border: none;
    font-size: 12px;
    transition: all 0.3s ease;
    box-shadow: 0 2px 8px rgba(0, 0, 0, 0.15);
  }

  .timeline-actions .btn:hover {
    transform: scale(1.1);
  }

  .timeline-actions .btn-edit {
    background: #3b82f6;
    color: #fff;
  }

  .timeline-actions .btn-edit:hover {
    background: #2563eb;
  }

  .timeline-actions .btn-delete {
    background: #ef4444;
    color: #fff;
  }

  .timeline-actions .btn-delete:hover {
    background: #dc2626;
  }

  .timeline-actions .btn-pin {
    background: #8b5cf6;
    color: #fff;
  }

  .timeline-actions .btn-pin:hover {
    background: #7c3aed;
  }

  /* Badges */
  .activity-badge {
    display: inline-block;
    padding: 4px 12px;
    border-radius: 16px;
    font-size: 11px;
    font-weight: 600;
    text-transform: uppercase;
    margin-left: 12px;
    background: #f3f4f6;
    color: #6b7280;
    letter-spacing: 0.5px;
  }

  .activity-badge.call {
    background: linear-gradient(135deg, #d1fae5, #a7f3d0);
    color: #065f46;
    border: 1px solid #10b981;
  }

  .activity-badge.email {
    background: linear-gradient(135deg, #e0e7ff, #c7d2fe);
    color: #3730a3;
    border: 1px solid #6366f1;
  }

  .activity-badge.note {
    background: linear-gradient(135deg, #fef3c7, #fde68a);
    color: #92400e;
    border: 1px solid #f59e42;
  }

  .activity-badge.document {
    background: linear-gradient(135deg, #fef9c3, #fef08a);
    color: #a16207;
    border: 1px solid #fbbf24;
  }

  .activity-badge.stage {
    background: linear-gradient(135deg, #dbeafe, #bfdbfe);
    color: #1e40af;
    border: 1px solid #3b82f6;
  }

  .activity-badge.status {
    background: linear-gradient(135deg, #e9fbe5, #d1fae5);
    color: #166534;
    border: 1px solid #84c529;
  }

  .activity-badge.activity {
    background: linear-gradient(135deg, #f3f4f6, #e5e7eb);
    color: #374151;
    border: 1px solid #6b7280;
  }

  /* Cards in list-only tabs */
  #activities-only-list,
  #calls-list,
  #notes-list {
    padding: 0;
  }

  #activities-only-list .timeline-item.timeline-card .timeline-content,
  #calls-list .timeline-item.timeline-card .timeline-content,
  #notes-list .timeline-item.timeline-card .timeline-content {
    border-left: none;
    background: #fff;
  }

              /* General theme */
              .btn-primary {
    background: #6366f1;
    border-color: #6366f1;
  }

  .nav-tabs-scroll-wrapper {
    overflow-x: auto;
    overflow-y: hidden;
    white-space: nowrap;
    -webkit-overflow-scrolling: touch;
    margin-bottom: 0;
    /* Hide scrollbar for Chrome, Safari and Opera */
    scrollbar-width: thin;
    scrollbar-color: #d1d5db #eff6ff;
  }
  .nav-tabs-scroll-wrapper::-webkit-scrollbar {
    height: 6px;
    background: #eff6ff;
  }
  .nav-tabs-scroll-wrapper::-webkit-scrollbar-thumb {
    background: #d1d5db;
    border-radius: 4px;
  }

  .nav-tabs {
    display: inline-flex;
    flex-wrap: nowrap;
    background: #eff6ff;
    border: none;
    border-radius: 4px;
    padding: 6px;
    margin-bottom: 0;
    white-space: nowrap;
    min-width: max-content;
  }

  .nav-tabs>li {
    float: none;
    display: inline-block;
    vertical-align: top;
    white-space: nowrap;
  }

  .nav-tabs>li>a {
    border: none;
    border-radius: 4px;
    padding: 10px 16px;
    color: #333;
    font-weight: 500;
    display: inline-block;
    white-space: nowrap;
  }

  .nav-tabs>li.active>a {
    border-bottom: 2px solid #6366f1;
    background: transparent;
    color: #6366f1;
  }

  .badge {
    background: #ff0000;
    color: #fff;
    border-radius: 10px;
    padding: 3px 6px;
    font-size: 10px;
  }

  .form-control {
    border-radius: 8px;
    border: 1px solid #ddd;
  }

  .modern-card {
    background: #fff;
    border-radius: 12px;
    padding: 24px;
    border: 1px solid #e5e7eb;
    margin-bottom: 20px;
    box-shadow: 0 2px 8px rgba(0, 0, 0, 0.06);
    transition: all 0.3s ease;
  }

  .modern-card:hover {
    box-shadow: 0 4px 16px rgba(0, 0, 0, 0.1);
    transform: translateY(-2px);
  }

  .modern-card-header {
    display: flex;
    align-items: center;
    justify-content: space-between;
    margin-bottom: 16px;
    padding-bottom: 16px;
    border-bottom: 2px solid #f3f4f6;
  }

  .modern-card-title {
    font-size: 18px;
    font-weight: 600;
    color: #1f2937;
    margin: 0;
  }
  @media (max-width: 768px) {
    .timeline-container {
      padding-left: 34px;
    }

    .timeline-container::before {
      left: 16px;
    }


    .timeline-item.timeline-card .timeline-content,
    .timeline-item.timeline-row .timeline-row-text {
      margin-left: 44px;
    }

    .timeline-actions {
      position: static;
      opacity: 1;
      transform: none;
      margin-top: 6px;
      justify-content: flex-end;
    }
  }
</style>
<!-- Include Modals -->
<?php $this->load->view('modals/add_task', $data); ?>
<?php $this->load->view('modals/add_note', $data); ?>
<?php $this->load->view('modals/add_reminder', $data); ?>
<?php $this->load->view('modals/add_activity', $data); ?>
<?php $this->load->view('modals/add_call_log', $data); ?>
<?php $this->load->view('modals/add_email', $data); ?>
<?php $this->load->view('modals/add_attachment', $data); ?>