<?php

defined('BASEPATH') or exit('No direct script access allowed');

// Build deals table columns with identifiers for configurable order
$table_data = [
    '<span class="hide"> - </span><div class="checkbox mass_select_all_wrap"><input type="checkbox" id="mass_select_all" data-to-table="deals"><label></label></div>',
    [
        'id' => 'number',
        'name' => _l('the_number_sign'),
        'th_attrs' => ['class' => 'toggleable', 'id' => 'th-number'],
    ],
    [
        'id' => 'name',
        'name' => _l('deals_dt_name'),
        'th_attrs' => ['class' => 'toggleable', 'id' => 'th-name'],
    ],
    [
        'id' => 'company',
        'name' => _l('deal_company'),
        'th_attrs' => ['class' => 'toggleable', 'id' => 'th-company'],
    ],
    [
        'id' => 'email',
        'name' => _l('leads_dt_email'),
        'th_attrs' => ['class' => 'toggleable', 'id' => 'th-email'],
    ],
    [
        'id' => 'phone',
        'name' => _l('leads_dt_phonenumber'),
        'th_attrs' => ['class' => 'toggleable', 'id' => 'th-phone'],
    ],
    [
        'id' => 'deal-value',
        'name' => _l('deals_dt_lead_value'),
        'th_attrs' => ['class' => 'toggleable', 'id' => 'th-lead-value'],
    ],
    [
        'id' => 'tags',
        'name' => _l('tags'),
        'th_attrs' => ['class' => 'toggleable', 'id' => 'th-tags'],
    ],
    [
        'id' => 'assigned',
        'name' => _l('leads_dt_assigned'),
        'th_attrs' => ['class' => 'toggleable', 'id' => 'th-assigned'],
    ],
    [
        'id' => 'status',
        'name' => _l('leads_dt_status'),
        'th_attrs' => ['class' => 'toggleable', 'id' => 'th-status'],
    ],
    [
        'id' => 'source',
        'name' => _l('leads_source'),
        'th_attrs' => ['class' => 'toggleable', 'id' => 'th-source'],
    ],
    [
        'id' => 'last-contact',
        'name' => _l('leads_dt_last_contact'),
        'th_attrs' => ['class' => 'toggleable', 'id' => 'th-last-contact'],
    ],
    [
        'id' => 'date-created',
        'name' => _l('leads_dt_datecreated'),
        'th_attrs' => ['class' => 'date-created toggleable', 'id' => 'th-date-created'],
    ],
];

$table_data = hooks()->apply_filters('deals_table_columns', $table_data);

render_datatable(
    $table_data,
    'deals',
    ['customizable-table number-index-2'],
    [
        'id' => 'table-deals',
        'data-last-order-identifier' => 'deals',
        'data-default-order' => get_table_last_order('deals'),
    ]
);
?>