<?php defined('BASEPATH') or exit('No direct script access allowed'); ?>
<div class="modal fade" id="add_email_modal" tabindex="-1" role="dialog">
    <div class="modal-dialog" role="document">
        <?php echo form_open_multipart(admin_url('deals/add_deal_email/' . $deal_id), ['id' => 'add_email_form']); ?>
        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
                <h4 class="modal-title"><?php echo _l('send_email'); ?></h4>
            </div>
            <div class="modal-body">
                <div class="form-group">
                    <label for="email_subject"><?php echo _l('subject'); ?> <span class="text-danger">*</span></label>
                    <input type="text" name="subject" id="email_subject" class="form-control" required>
                </div>
                <div class="form-group">
                    <label for="email_message"><?php echo _l('message'); ?> <span class="text-danger">*</span></label>
                    <textarea name="message" id="email_message" class="form-control" rows="4" required></textarea>
                </div>
                <div class="form-group">
                    <label for="to_email"><?php echo _l('to_email'); ?> <span class="text-danger">*</span></label>
                    <input type="email" name="to_email" id="to_email" class="form-control" required>
                </div>
                <div class="form-group">
                    <label for="email_attachments"><?php echo _l('attachments'); ?></label>
                    <input type="file" name="attachments[]" id="email_attachments" multiple class="form-control">
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-default" data-dismiss="modal"><?php echo _l('close'); ?></button>
                <button type="submit" class="btn btn-primary"><?php echo _l('send'); ?></button>
            </div>
        </div>
        <?php echo form_close(); ?>
    </div>
</div>

<script>
$(document).ready(function() {
    appValidateForm($('#add_email_form'), {
        subject: 'required',
        message: 'required',
        to_email: {
            required: true,
            email: true
        }
    });

    $('#add_email_modal').on('hidden.bs.modal', function() {
        $('#add_email_form')[0].reset();
    });
});
</script>