<?php defined('BASEPATH') or exit('No direct script access allowed'); ?>

<?php init_head(); ?>
<div id="wrapper">
  <div class="content">
    <div class="row">
      <div class="col-md-8 col-md-offset-2">
        <div class="panel_s">
          <div class="panel-body">
            <h4 class="tw-mt-0"><?php echo isset($deal) ? _l('edit_deal') : _l('new_deal'); ?></h4>
            <hr class="hr-panel-heading" />
            <?php echo form_open(admin_url(isset($deal) ? 'deals/edit/' . $deal['id'] : 'deals/create')); ?>
            <div class="row">
              <div class="col-md-6">
                <?php echo render_input('name', 'name', isset($deal) ? $deal['name'] : ''); ?>
              </div>
              <div class="col-md-6">
                <?php echo render_input('company', 'company', isset($deal) ? $deal['company'] : ''); ?>
              </div>
              <div class="col-md-12">
                <div class="form-group">
                  <label class="control-label"><?php echo _l('pipelines'); ?> / <?php echo _l('stage'); ?> / <?php echo _l('score'); ?></label>
                  <div id="deal-pipelines-list">
                    <?php if (isset($deal) && !empty($deal['id'])) { ?>
                      <?php $allPipes = $this->deals_model->get_deal_pipelines($deal['id']); ?>
                      <?php foreach ($allPipes as $idx => $rel) { ?>
                        <div class="tw-flex tw-items-center tw-space-x-2 tw-mb-2">
                          <select name="pipelines[<?php echo $idx; ?>][pipeline_id]" class="selectpicker" data-width="30%">
                            <?php foreach (($pipelines ?? []) as $pipeline) { ?>
                              <option value="<?php echo (int)$pipeline['id']; ?>" <?php echo ($rel['pipeline']['id'] == $pipeline['id']) ? 'selected' : ''; ?>><?php echo html_entity_decode($pipeline['name']); ?></option>
                            <?php } ?>
                          </select>
                          <select name="pipelines[<?php echo $idx; ?>][stage_id]" class="selectpicker" data-width="30%" data-pipeline="<?php echo (int)$rel['pipeline']['id']; ?>">
                            <?php $rows = $this->deals_model->get_stages($rel['pipeline']['id']); foreach ($rows as $stage) { ?>
                              <option value="<?php echo (int)$stage['id']; ?>" <?php echo ($rel['stage']['id'] == $stage['id']) ? 'selected' : ''; ?>><?php echo html_entity_decode($stage['name']); ?></option>
                            <?php } ?>
                          </select>
                          <input type="number" name="pipelines[<?php echo $idx; ?>][score]" class="form-control" style="width:120px" placeholder="<?php echo _l('score'); ?>" value="<?php echo isset($rel['score']) ? (int)$rel['score'] : ''; ?>">
                          <a href="#" class="text-danger" onclick="removePipelineRow(this); return false;"><i class="fa-regular fa-trash-can"></i></a>
                        </div>
                      <?php } ?>
                    <?php } else { ?>
                      <div class="tw-flex tw-items-center tw-space-x-2 tw-mb-2">
                        <select name="pipelines[0][pipeline_id]" class="selectpicker" data-width="30%">
                          <?php foreach (($pipelines ?? []) as $pipeline) { ?>
                            <option value="<?php echo (int)$pipeline['id']; ?>"><?php echo html_entity_decode($pipeline['name']); ?></option>
                          <?php } ?>
                        </select>
                        <select name="pipelines[0][stage_id]" class="selectpicker" data-width="30%"></select>
                        <input type="number" name="pipelines[0][score]" class="form-control" style="width:120px" placeholder="<?php echo _l('score'); ?>">
                        <a href="#" class="text-danger" onclick="removePipelineRow(this); return false;"><i class="fa-regular fa-trash-can"></i></a>
                      </div>
                    <?php } ?>
                  </div>
                  <a href="#" class="btn btn-default" onclick="addPipelineRow(); return false;"><i class="fa-regular fa-plus tw-mr-1"></i><?php echo _l('add'); ?></a>
                </div>
              </div>
              <div class="col-md-6">
                <?php echo render_select('source', $sources, array('id', 'name'), 'lead_add_edit_source', isset($deal) ? $deal['source'] : ''); ?>
              </div>
              <div class="col-md-6">
                <?php echo render_select('status', $statuses, array('id', 'name'), 'lead_add_edit_status', isset($deal) ? $deal['status'] : ''); ?>
              </div>
              <div class="col-md-6">
                <?php
                  $categories = $this->db->order_by('name','asc')->get(db_prefix() . 'deals_business_categories')->result_array();
                  echo render_select('business_category', $categories, array('id', 'name'), 'business_category_name', isset($deal) ? ($deal['business_category'] ?? '') : '');
                ?>
              </div>
              <div class="col-md-6">
                <?php echo render_select('assigned', $staff, array('staffid', array('firstname', 'lastname')), 'lead_add_edit_assigned', isset($deal) ? $deal['assigned'] : ''); ?>
              </div>
              <div class="col-md-12">
                <?php echo render_textarea('description', 'description', isset($deal) ? $deal['description'] : ''); ?>
              </div>
              <div class="col-md-4">
                <?php echo render_input('deal_value', 'deal_value', isset($deal) ? $deal['deal_value'] : '', 'number'); ?>
              </div>
              <div class="col-md-4">
                <?php echo render_date_input('expected_close_date', 'expected_close_date', isset($deal) ? $deal['expected_close_date'] : ''); ?>
              </div>
            </div>
            <div class="text-right">
              <button type="submit" class="btn btn-primary"><?php echo _l('submit'); ?></button>
            </div>
            <?php echo form_close(); ?>
          </div>
        </div>
      </div>
    </div>
  </div>
</div>
<?php init_tail(); ?>
<script>
  function addPipelineRow(){
    var idx = $('#deal-pipelines-list .tw-flex').length;
    var row = `
      <div class="tw-flex tw-items-center tw-space-x-2 tw-mb-2">
        <select name="pipelines[${idx}][pipeline_id]" class="selectpicker pipeline-select" data-width="30%">
          <?php foreach (($pipelines ?? []) as $pipeline) { ?>
            <option value="<?php echo (int)$pipeline['id']; ?>"><?php echo html_entity_decode($pipeline['name']); ?></option>
          <?php } ?>
        </select>
        <select name="pipelines[${idx}][stage_id]" class="selectpicker stage-select" data-width="30%"></select>
        <input type="number" name="pipelines[${idx}][score]" class="form-control" style="width:120px" placeholder="<?php echo _l('score'); ?>">
        <a href="#" class="text-danger" onclick="removePipelineRow(this); return false;"><i class="fa-regular fa-trash-can"></i></a>
      </div>`;
    $('#deal-pipelines-list').append(row);
    $('.selectpicker').selectpicker('refresh');
    var $container = $('#deal-pipelines-list .tw-flex').last();
    var pipelineId = $container.find('.pipeline-select').val();
    populateStages($container.find('.stage-select'), pipelineId);
  }
  function removePipelineRow(el){
    $(el).closest('.tw-flex').remove();
  }
  function populateStages($stageSelect, pipelineId){
    $stageSelect.empty();
    if(!pipelineId){ $('.selectpicker').selectpicker('refresh'); return; }
    $.get(admin_url + 'deals/get_stages/' + pipelineId, function(res){
      try { res = typeof res === 'string' ? JSON.parse(res) : res; } catch(e){ res = {success:false, stages:[]}; }
      if(res.success && res.stages){
        res.stages.forEach(function(s){
          $stageSelect.append('<option value="'+s.id+'">'+s.name.replace(/</g,'&lt;')+'</option>');
        });
      }
      $('.selectpicker').selectpicker('refresh');
    });
  }
  $(document).on('change', '.pipeline-select', function(){
    var $row = $(this).closest('.tw-flex');
    var pipelineId = $(this).val();
    var $stageSelect = $row.find('.stage-select');
    populateStages($stageSelect, pipelineId);
  });
</script>