<?php defined('BASEPATH') or exit('No direct script access allowed'); ?>
 
<li data-deal-id="<?= e($deal['id']); ?>"
    <?= isset($deal['is_deal_client']) && $deal['is_deal_client'] !== '0' ? 'data-toggle="tooltip" title="' . _l('deal_have_client_profile') . '"' : ''; ?>
    class="deal-kan-ban<?= $deal['assigned'] == get_staff_user_id() ? ' current-user-deal' : ''; ?><?= isset($deal['is_deal_client']) && $deal['is_deal_client'] !== '0' && get_option('deal_lock_after_convert_to_customer') == 1 && !is_admin() ? ' not-sortable' : ''; ?>">
    <div class="panel-body deal-body">
        <div class="tw-flex deal-name">
            <?php if ($deal['assigned'] != 0) { ?>
                <a href="<?= admin_url('profile/' . $deal['assigned']); ?>" data-placement="right" data-toggle="tooltip"
                    title="<?= e(get_staff_full_name($deal['assigned'])); ?>" class="mtop8 tw-mr-1.5">
                    <?= staff_profile_image($deal['assigned'], ['staff-profile-image-xs']); ?>
                </a>
            <?php } ?>
            <a href="javascript:void(0)" title="#<?= e($deal['id']) . ' - ' . e($deal['name'] ?? 'Unnamed Deal'); ?>"
                onclick="openViewDealModal(<?= e($deal['id']); ?>); return false;" class="tw-block tw-min-w-0 tw-font-medium">
                <span class="mtop10 mbot10 tw-truncate tw-block">
                    #<?= e($deal['id']) . ' - ' . e($deal['name'] ?? 'Unnamed Deal'); ?>
                </span>
            </a>
        </div>
        <div class="row">
            <div class="col-md-12">
                <div class="tw-flex">
                    <div class="tw-grow tw-mr-2">
                        <p class="tw-text-sm tw-mb-0">
                            <?= 'Source: ' . ($deal['source_name'] ?? 'Unknown'); ?>
                        </p>
                        <?php
                        $deal_value = isset($deal['deal_value']) && $deal['deal_value'] != 0
                            ? app_format_money($deal['deal_value'], $base_currency->symbol)
                            : '--';
                        ?>
                        <p class="tw-text-sm tw-mb-0">
                            <?= 'Deal Value: ' . $deal_value; ?>
                        </p>
 
                    </div>
                    <div class="text-right">
                        <?php if (isset($deal['lastcontact']) && is_date($deal['lastcontact']) && $deal['lastcontact'] != '0000-00-00 00:00:00') { ?>
                            <small class="text-dark tw-text-sm">
                                <?= _l('deals_dt_last_contact'); ?>
                                <span class="bold">
                                    <span class="text-has-action" data-toggle="tooltip" data-title="<?= e(_dt($deal['lastcontact'])); ?>">
                                        <?= e(time_ago($deal['lastcontact'])); ?>
                                    </span>
                                </span>
                            </small><br />
                        <?php } ?>
                        <small class="text-dark">
                            <?= _l('deal_created'); ?>:
                            <span class="bold">
                                <span class="text-has-action" data-toggle="tooltip" data-title="<?= e(_dt($deal['dateadded'])); ?>">
 
                                    <?= e(time_ago($deal['dateadded'])); ?>
                                </span>
                            </span>
                        </small><br />
                        <?php hooks()->do_action('before_deals_kanban_card_icons', $deal); ?>
                        <span class="mright5 mtop5 inline-block text-muted" data-toggle="tooltip" data-placement="left"
                            data-title="<?= _l('deals_canban_notes', $deal['total_notes'] ?? 0); ?>">
                            <i class="fa-regular fa-note-sticky"></i> <?= e($deal['total_notes'] ?? 0); ?>
                        </span>
                        <span class="mtop5 inline-block text-muted" data-placement="left" data-toggle="tooltip"
                            data-title="<?= _l('deal_kan_ban_attachments', $deal['total_files'] ?? 0); ?>">
                            <i class="fa fa-paperclip"></i> <?= e($deal['total_files'] ?? 0); ?>
                        </span>
                        <?php hooks()->do_action('after_deals_kanban_card_icons', $deal); ?>
                    </div>
                </div>
            </div>
            <?php if (!empty($deal['tags'] ?? [])) { ?>
                <div class="col-md-12">
                    <div class="kanban-tags tw-text-sm tw-inline-flex">
                        <?= render_tags($deal['tags'] ?? []); ?>
                    </div>
                </div>
            <?php } ?>
            <a href="javascript:void(0)" class="pull-right text-muted kan-ban-expand-top"
                onclick="$('#kan-ban-expand-<?= e($deal['id']); ?>').slideToggle(); return false;">
                <i class="fa fa-expand" aria-hidden="true"></i>
            </a>
 
            <div class="clearfix no-margin"></div>
            <div id="kan-ban-expand-<?= e($deal['id']); ?>" class="padding-10" style="display:none;">
                <div class="clearfix"></div>
                <hr class="hr-10" />
                <p class="text-muted deal-field-heading"><?= _l('deal_title'); ?></p>
                <p class="bold tw-text-sm"><?= e($deal['name'] ?? '-'); ?></p>
                <p class="text-muted deal-field-heading"><?= _l('deal_add_edit_email'); ?></p>
                <p class="bold tw-text-sm">
                    <?= !empty($deal['email']) ? '<a href="mailto:' . e($deal['email']) . '">' . e($deal['email']) . '</a>' : '-'; ?>
                </p>
                <p class="text-muted deal-field-heading"><?= _l('deal_website'); ?></p>
                <p class="bold tw-text-sm">
                    <?= !empty($deal['website']) ? '<a href="' . e(maybe_add_http($deal['website'])) . '" target="_blank">' . e($deal['website']) . '</a>' : '-'; ?>
                </p>
                <p class="text-muted deal-field-heading"><?= _l('deal_add_edit_phonenumber'); ?></p>
                <p class="bold tw-text-sm">
                    <?= !empty($deal['phonenumber']) ? '<a href="tel:' . e($deal['phonenumber']) . '">' . e($deal['phonenumber']) . '</a>' : '-'; ?>
                </p>
                <p class="text-muted deal-field-heading"><?= _l('deal_company'); ?></p>
                <p class="bold tw-text-sm"><?= e(!empty($deal['company']) ? $deal['company'] : '-'); ?></p>
 
                <p class="text-muted deal-field-heading"><?= _l('deal_address'); ?></p>
                <p class="bold tw-text-sm"><?= e(!empty($deal['address']) ? $deal['address'] : '-'); ?></p>
 
                <p class="text-muted deal-field-heading"><?= _l('deal_city'); ?></p>
                <p class="bold tw-text-sm"><?= e(!empty($deal['city']) ? $deal['city'] : '-'); ?></p>
 
                <p class="text-muted deal-field-heading"><?= _l('deal_state'); ?></p>
                <p class="bold tw-text-sm"><?= e(!empty($deal['state']) ? $deal['state'] : '-'); ?></p>
 
                <p class="text-muted deal-field-heading"><?= _l('deal_country'); ?></p>
                <p class="bold tw-text-sm"><?= e(!empty($deal['country']) && $deal['country'] != 0 ? get_country($deal['country'])->short_name : '-'); ?></p>
 
                <p class="text-muted deal-field-heading"><?= _l('deal_zip'); ?></p>
                <p class="bold tw-text-sm"><?= e(!empty($deal['zip']) ? $deal['zip'] : '-'); ?></p>
 
            </div>
        </div>
</li>