# Deals Module - Updated Features

## Overview
This deals module has been updated to include comprehensive contact, company, and attachment management features similar to modern CRM systems.

## New Features

### 1. Contact Management
- **Add Existing Contacts**: Select from existing contacts in the system
- **Create New Contacts**: Add new contacts directly from the deal view
- **Contact Association**: Link multiple contacts to a single deal
- **Contact Removal**: Remove contacts from deals with confirmation

### 2. Company Management
- **Add Existing Companies**: Select from existing companies in the system
- **Create New Companies**: Add new companies directly from the deal view
- **Company Association**: Link multiple companies to a single deal
- **Company Details**: Store company information including website, phone, address
- **Company Removal**: Remove companies from deals with confirmation

### 3. Attachment Management
- **Add Existing Attachments**: Select from existing attachments in the system
- **Upload New Attachments**: Upload new files directly from the deal view
- **Attachment Association**: Link multiple attachments to a single deal
- **Attachment Removal**: Remove attachments from deals with confirmation

### 4. Enhanced Activity Log
- **Activity Tracking**: Track all actions performed on deals
- **Activity Tabs**: Organized tabs for different types of activities
- **Activity Filtering**: Filter activities by type
- **Activity Pinning**: Pin important activities to the top

### 5. Improved Pipeline Stages
- **Visual Stage Progress**: Circular stage indicators with checkmarks
- **Stage Navigation**: Click to move between stages
- **Stage Status**: Visual indication of completed, current, and pending stages
- **Stage Arrows**: Visual flow between stages

## Database Changes

### New Tables Created:
1. **deal_contacts** - Links contacts to deals
2. **deal_companies** - Links companies to deals
3. **companies** - Stores company information
4. **deal_attachments_relations** - Links attachments to deals

### Existing Tables Enhanced:
1. **deals_activity** - Enhanced for better activity tracking

## API Endpoints

### Contact Management:
- `GET /deals/get_deal_contacts/{deal_id}` - Get contacts for a deal
- `GET /deals/get_available_contacts/{deal_id}` - Get available contacts
- `POST /deals/add_contact_to_deal/{deal_id}` - Add contact to deal
- `POST /deals/remove_contact_from_deal/{deal_id}/{contact_id}` - Remove contact from deal

### Company Management:
- `GET /deals/get_deal_companies/{deal_id}` - Get companies for a deal
- `GET /deals/get_available_companies/{deal_id}` - Get available companies
- `POST /deals/add_company_to_deal/{deal_id}` - Add company to deal
- `POST /deals/remove_company_from_deal/{deal_id}/{company_id}` - Remove company from deal

### Attachment Management:
- `GET /deals/get_deal_attachments/{deal_id}` - Get attachments for a deal
- `GET /deals/get_available_attachments/{deal_id}` - Get available attachments
- `POST /deals/add_attachment_to_deal/{deal_id}` - Add attachment to deal
- `POST /deals/remove_attachment_from_deal/{deal_id}/{attachment_id}` - Remove attachment from deal

### Activity Management:
- `GET /deals/get_deal_activities/{deal_id}` - Get activities for a deal

## Installation

1. Run the module installation script to create the new database tables
2. The module will automatically create the required tables and relationships
3. Existing deals will continue to work without any data migration

## Usage

### Adding Contacts to a Deal:
1. Navigate to the deal view page
2. Click the "+" button in the Contacts section
3. Choose between "Select Existing" or "Create New"
4. Fill in the required information
5. Click "Save"

### Adding Companies to a Deal:
1. Navigate to the deal view page
2. Click the "+" button in the Companies section
3. Choose between "Select Existing" or "Create New"
4. Fill in the company information
5. Click "Save"

### Adding Attachments to a Deal:
1. Navigate to the deal view page
2. Click the "+" button in the Attachments section
3. Choose between "Select Existing" or "Upload New"
4. Select or upload the file
5. Add a description (optional)
6. Click "Save"

### Managing Pipeline Stages:
1. Click on any stage button to move the deal to that stage
2. Completed stages show a green checkmark
3. Current stage is highlighted in blue
4. Pending stages are shown in gray

## Customization

### Styling:
- Custom CSS file: `modules/deals/views/deals.css`
- Modify colors, spacing, and layout as needed
- Responsive design included for mobile devices

### Language:
- Language file: `modules/deals/language/english/deals_lang.php`
- Add new language strings as needed
- Support for multiple languages

## Technical Details

### Dependencies:
- CodeIgniter 3.x
- jQuery (for AJAX functionality)
- Bootstrap (for UI components)
- Font Awesome (for icons)

### Browser Support:
- Modern browsers (Chrome, Firefox, Safari, Edge)
- Mobile responsive design
- Progressive enhancement for older browsers

## Troubleshooting

### Common Issues:
1. **Contacts not loading**: Check if the contacts table exists and has data
2. **File upload errors**: Verify upload directory permissions
3. **AJAX errors**: Check browser console for JavaScript errors
4. **Database errors**: Verify all tables were created during installation

### Debug Mode:
Enable debug mode in CodeIgniter to see detailed error messages.

## Support

For technical support or feature requests, please contact the development team.
